/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.interceptors.MarshalledValueInterceptor;
import org.jboss.cache.marshall.MarshalledValueHelper;
import org.jboss.cache.util.CachePrinter;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="interceptors.MarshalledValueInterceptorTest")
public class MarshalledValueInterceptorTest {
    CacheSPI c;

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.c});
        this.c = null;
    }

    public void testDefaultInterceptorStack() {
        this.c = (CacheSPI)new UnitTestCacheFactory().createCache();
        assert (TestingUtil.findInterceptor(this.c, MarshalledValueInterceptor.class) == null);
        TestingUtil.killCaches(new Cache[]{this.c});
        this.c = (CacheSPI)new UnitTestCacheFactory().createCache(false);
        this.c.getConfiguration().setUseLazyDeserialization(true);
        this.c.start();
        assert (TestingUtil.findInterceptor(this.c, MarshalledValueInterceptor.class) != null);
    }

    public void testEnabledInterceptorStack() {
        Configuration cfg = new Configuration();
        cfg.setUseLazyDeserialization(true);
        this.c = (CacheSPI)new UnitTestCacheFactory().createCache(cfg);
        System.out.println(CachePrinter.printCacheInterceptors((CacheSPI)this.c));
        assert (TestingUtil.findInterceptor(this.c, MarshalledValueInterceptor.class) != null);
    }

    public void testDisabledInterceptorStack() {
        Configuration cfg = new Configuration();
        cfg.setUseLazyDeserialization(false);
        this.c = (CacheSPI)new UnitTestCacheFactory().createCache(cfg);
        System.out.println(CachePrinter.printCacheInterceptors((CacheSPI)this.c));
        assert (TestingUtil.findInterceptor(this.c, MarshalledValueInterceptor.class) == null);
    }

    public void testExcludedTypes() {
        assert (MarshalledValueHelper.isTypeExcluded(String.class));
        assert (MarshalledValueHelper.isTypeExcluded(String[].class));
        assert (MarshalledValueHelper.isTypeExcluded(String[][].class));
        assert (MarshalledValueHelper.isTypeExcluded(String[][][].class));
        assert (MarshalledValueHelper.isTypeExcluded(Void.TYPE));
        assert (MarshalledValueHelper.isTypeExcluded(Boolean.TYPE));
        assert (MarshalledValueHelper.isTypeExcluded(Character.TYPE));
        assert (MarshalledValueHelper.isTypeExcluded(Byte.TYPE));
        assert (MarshalledValueHelper.isTypeExcluded(Short.TYPE));
        assert (MarshalledValueHelper.isTypeExcluded(Integer.TYPE));
        assert (MarshalledValueHelper.isTypeExcluded(Long.TYPE));
        assert (MarshalledValueHelper.isTypeExcluded(Float.TYPE));
        assert (MarshalledValueHelper.isTypeExcluded(Double.TYPE));
        assert (MarshalledValueHelper.isTypeExcluded(boolean[].class));
        assert (MarshalledValueHelper.isTypeExcluded(char[].class));
        assert (MarshalledValueHelper.isTypeExcluded(byte[].class));
        assert (MarshalledValueHelper.isTypeExcluded(short[].class));
        assert (MarshalledValueHelper.isTypeExcluded(int[].class));
        assert (MarshalledValueHelper.isTypeExcluded(long[].class));
        assert (MarshalledValueHelper.isTypeExcluded(float[].class));
        assert (MarshalledValueHelper.isTypeExcluded(double[].class));
        assert (MarshalledValueHelper.isTypeExcluded(boolean[][].class));
        assert (MarshalledValueHelper.isTypeExcluded(char[][].class));
        assert (MarshalledValueHelper.isTypeExcluded(byte[][].class));
        assert (MarshalledValueHelper.isTypeExcluded(short[][].class));
        assert (MarshalledValueHelper.isTypeExcluded(int[][].class));
        assert (MarshalledValueHelper.isTypeExcluded(long[][].class));
        assert (MarshalledValueHelper.isTypeExcluded(float[][].class));
        assert (MarshalledValueHelper.isTypeExcluded(double[][].class));
        assert (MarshalledValueHelper.isTypeExcluded(Void.class));
        assert (MarshalledValueHelper.isTypeExcluded(Boolean.class));
        assert (MarshalledValueHelper.isTypeExcluded(Character.class));
        assert (MarshalledValueHelper.isTypeExcluded(Byte.class));
        assert (MarshalledValueHelper.isTypeExcluded(Short.class));
        assert (MarshalledValueHelper.isTypeExcluded(Integer.class));
        assert (MarshalledValueHelper.isTypeExcluded(Long.class));
        assert (MarshalledValueHelper.isTypeExcluded(Float.class));
        assert (MarshalledValueHelper.isTypeExcluded(Double.class));
        assert (MarshalledValueHelper.isTypeExcluded(Boolean[].class));
        assert (MarshalledValueHelper.isTypeExcluded(Character[].class));
        assert (MarshalledValueHelper.isTypeExcluded(Byte[].class));
        assert (MarshalledValueHelper.isTypeExcluded(Short[].class));
        assert (MarshalledValueHelper.isTypeExcluded(Integer[].class));
        assert (MarshalledValueHelper.isTypeExcluded(Long[].class));
        assert (MarshalledValueHelper.isTypeExcluded(Float[].class));
        assert (MarshalledValueHelper.isTypeExcluded(Double[].class));
        assert (MarshalledValueHelper.isTypeExcluded(Boolean[][].class));
        assert (MarshalledValueHelper.isTypeExcluded(Character[][].class));
        assert (MarshalledValueHelper.isTypeExcluded(Byte[][].class));
        assert (MarshalledValueHelper.isTypeExcluded(Short[][].class));
        assert (MarshalledValueHelper.isTypeExcluded(Integer[][].class));
        assert (MarshalledValueHelper.isTypeExcluded(Long[][].class));
        assert (MarshalledValueHelper.isTypeExcluded(Float[][].class));
        assert (MarshalledValueHelper.isTypeExcluded(Double[][].class));
    }

    public void testNonExcludedTypes() {
        assert (!MarshalledValueHelper.isTypeExcluded(Object.class));
        assert (!MarshalledValueHelper.isTypeExcluded(List.class));
        assert (!MarshalledValueHelper.isTypeExcluded(Collection.class));
        assert (!MarshalledValueHelper.isTypeExcluded(Map.class));
        assert (!MarshalledValueHelper.isTypeExcluded(Date.class));
        assert (!MarshalledValueHelper.isTypeExcluded(Thread.class));
        assert (!MarshalledValueHelper.isTypeExcluded(Collection.class));
        assert (!MarshalledValueHelper.isTypeExcluded(new Object(){
            String blah;
        }.getClass()));
    }
}

