/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invocationcontext;

import java.util.Map;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.transaction.TransactionContext;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"}, testName="invocationcontext.TransactionTest")
public class TransactionTest {
    private CacheSPI<Object, Object> cache;
    private TransactionManager tm;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache("configs/local-tx.xml");
        this.tm = this.cache.getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testTxExistenceAfterWrite() throws Exception {
        this.tm.begin();
        AssertJUnit.assertNull((String)"Tx should not have been set up yet", (Object)this.cache.getInvocationContext().getTransaction());
        AssertJUnit.assertNull((String)"Gtx should not have been set up yet", (Object)this.cache.getInvocationContext().getGlobalTransaction());
        this.cache.getRoot().put((Object)"k", (Object)"v");
        Map data = this.cache.getRoot().getData();
        AssertJUnit.assertEquals((String)"Data map should not empty", (int)1, (int)data.size());
        AssertJUnit.assertNotNull((String)"Tx should have been set up by now", (Object)this.cache.getInvocationContext().getTransaction());
        AssertJUnit.assertEquals((String)"The same current transaction should be associated with this invocation ctx.", (Object)this.tm.getTransaction(), (Object)this.cache.getInvocationContext().getTransaction());
        AssertJUnit.assertNotNull((String)"Gtx should have been set up by now", (Object)this.cache.getInvocationContext().getGlobalTransaction());
        this.tm.commit();
    }

    public void testTxExistenceAfterRead() throws Exception {
        this.tm.begin();
        AssertJUnit.assertNull((String)"Tx should not have been set up yet", (Object)this.cache.getInvocationContext().getTransaction());
        AssertJUnit.assertNull((String)"Gtx should not have been set up yet", (Object)this.cache.getInvocationContext().getGlobalTransaction());
        Object value = this.cache.get(Fqn.ROOT, (Object)"k");
        AssertJUnit.assertNull((String)"Value should be null", (Object)value);
        AssertJUnit.assertNotNull((String)"Tx should have been set up by now", (Object)this.cache.getInvocationContext().getTransaction());
        AssertJUnit.assertEquals((String)"The same current transaction should be associated with this invocation ctx.", (Object)this.tm.getTransaction(), (Object)this.cache.getInvocationContext().getTransaction());
        AssertJUnit.assertNotNull((String)"Gtx should have been set up by now", (Object)this.cache.getInvocationContext().getGlobalTransaction());
        this.tm.commit();
    }

    public void testScrubbingAfterCommit() throws Exception {
        this.doScrubbingTest(true);
    }

    public void testScrubbingAfterOnePhaseCommit() throws Exception {
        this.setUpOnePhaseCache();
        this.doScrubbingTest(true);
    }

    public void testScrubbingAfterRollback() throws Exception {
        this.doScrubbingTest(false);
    }

    public void testScrubbingAfterOnePhaseRollback() throws Exception {
        this.setUpOnePhaseCache();
        this.doScrubbingTest(true);
    }

    private void doScrubbingTest(boolean commit) throws Exception {
        this.cache.getInvocationContext().reset();
        this.tm.begin();
        TransactionTable tt = this.cache.getTransactionTable();
        this.cache.getRoot().put((Object)"key", (Object)"value");
        AssertJUnit.assertNotNull((String)"Tx should have been set up by now", (Object)this.cache.getInvocationContext().getTransaction());
        AssertJUnit.assertEquals((String)"The same current transaction should be associated with this invocation ctx.", (Object)this.tm.getTransaction(), (Object)this.cache.getInvocationContext().getTransaction());
        AssertJUnit.assertNotNull((String)"Gtx should have been set up by now", (Object)this.cache.getInvocationContext().getGlobalTransaction());
        Transaction tx = this.tm.getTransaction();
        TransactionContext transactionContext = tt.get(tt.get(tx));
        if (commit) {
            this.tm.commit();
        } else {
            this.tm.rollback();
        }
        AssertJUnit.assertNull((String)"Tx should have been scrubbed", (Object)this.cache.getInvocationContext().getTransaction());
        AssertJUnit.assertNull((String)"Gtx should have been scrubbed", (Object)this.cache.getInvocationContext().getGlobalTransaction());
        AssertJUnit.assertEquals((String)"Method call should have been scrubbed", null, (Object)this.cache.getInvocationContext().getMethodCall());
        AssertJUnit.assertEquals((String)"Cache command should have been scrubbed", null, (Object)this.cache.getInvocationContext().getCommand());
        assert (transactionContext.getModifications().isEmpty()) : "Should have scrubbed modifications in transaction transactionContext";
        assert (transactionContext.getLocks().isEmpty()) : "Should have scrubbed modifications in transaction transactionContext";
        assert (transactionContext.getOrderedSynchronizationHandler() == null) : "Should have removed the ordered sync handler";
    }

    private void setUpOnePhaseCache() {
        if (this.cache != null) {
            this.cache.stop();
            this.cache = null;
        }
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache("configs/replSync.xml", false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        this.cache.start();
        this.tm = this.cache.getTransactionManager();
    }
}

