/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.jmx.deprecated;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.cache.Cache;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.jmx.CacheJmxWrapper;
import org.jboss.cache.jmx.CacheJmxWrapperMBean;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, testName="jmx.deprecated.CacheJmxWrapperTestBase")
public abstract class CacheJmxWrapperTestBase {
    public static final String CLUSTER_NAME_BASE = "CacheMBeanTest";
    protected String clusterName;
    protected Cache<String, String> cache;
    protected CacheJmxWrapperMBean<String, String> jmxWrapper;
    protected MBeanServer mBeanServer;
    protected ObjectName mBeanName;
    protected String mBeanNameStr;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.clusterName = "CacheMBeanTest-" + Thread.currentThread().getName();
        this.mBeanServer = MBeanServerFactory.createMBeanServer(CLUSTER_NAME_BASE);
        this.mBeanNameStr = "jboss.cache:service=JBossCache,cluster=" + this.clusterName;
        this.mBeanName = new ObjectName(this.mBeanNameStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        try {
            this.cleanup();
            Object var2_1 = null;
            if (this.mBeanServer == null) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.mBeanServer == null) throw throwable;
            MBeanServerFactory.releaseMBeanServer(this.mBeanServer);
            this.mBeanServer = null;
            throw throwable;
        }
        MBeanServerFactory.releaseMBeanServer(this.mBeanServer);
        this.mBeanServer = null;
    }

    protected CacheJmxWrapperMBean<String, String> registerWrapper() throws Exception {
        if (this.cache == null) {
            this.cache = this.createCache(this.createConfiguration());
        }
        return this.registerWrapper(this.cache);
    }

    protected CacheJmxWrapperMBean<String, String> registerWrapper(Cache<String, String> toWrap) throws Exception {
        CacheJmxWrapper wrapper = new CacheJmxWrapper(toWrap);
        return this.registerWrapper((CacheJmxWrapperMBean<String, String>)wrapper);
    }

    protected CacheJmxWrapperMBean<String, String> registerWrapper(Configuration config) throws Exception {
        CacheJmxWrapper wrapper = new CacheJmxWrapper();
        wrapper.setConfiguration(config);
        return this.registerWrapper((CacheJmxWrapperMBean<String, String>)wrapper);
    }

    protected CacheJmxWrapperMBean<String, String> registerWrapper(CacheJmxWrapperMBean<String, String> wrapper) throws Exception {
        ObjectName on = new ObjectName(this.mBeanNameStr);
        if (!this.mBeanServer.isRegistered(on)) {
            this.mBeanServer.registerMBean(wrapper, on);
        }
        this.jmxWrapper = MBeanServerInvocationHandler.newProxyInstance(this.mBeanServer, this.mBeanName, CacheJmxWrapperMBean.class, false);
        return this.jmxWrapper;
    }

    protected void unregisterWrapper() throws Exception {
        this.mBeanServer.unregisterMBean(this.mBeanName);
    }

    protected CacheJmxWrapper<String, String> createWrapper(Configuration config) {
        CacheJmxWrapper wrapper = new CacheJmxWrapper();
        config.setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        wrapper.setConfiguration(config);
        return wrapper;
    }

    protected Cache<String, String> createCache(Configuration config) {
        UnitTestCacheFactory factory = new UnitTestCacheFactory();
        this.cache = factory.createCache(config, false);
        return this.cache;
    }

    protected Configuration createConfiguration() {
        Configuration c = new Configuration();
        c.setClusterName(this.clusterName);
        c.setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        c.setExposeManagementStatistics(true);
        c.setCacheMode(Configuration.CacheMode.LOCAL);
        return c;
    }

    private void cleanup() throws Exception {
        if (this.cache != null) {
            try {
                this.cache.stop();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            this.cache = null;
        }
        if (this.jmxWrapper != null) {
            try {
                this.jmxWrapper.stop();
                this.jmxWrapper.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.jmxWrapper = null;
        }
        if (this.mBeanServer != null && this.mBeanName != null && this.mBeanServer.isRegistered(this.mBeanName)) {
            this.mBeanServer.unregisterMBean(this.mBeanName);
        }
    }

    protected void interceptorRegistrationTest(boolean expectMbeans) throws MalformedObjectNameException, NullPointerException {
        this.interceptorRegistrationTest(this.mBeanNameStr, expectMbeans);
    }

    protected void interceptorRegistrationTest(String baseName, boolean expectMbeans) throws MalformedObjectNameException, NullPointerException {
        ObjectName[] interceptorMBeanNames;
        for (ObjectName n : interceptorMBeanNames = new ObjectName[]{new ObjectName(baseName + ",jmx-resource=" + "TxInterceptor"), new ObjectName(baseName + ",jmx-resource=" + "CacheMgmtInterceptor")}) {
            if (expectMbeans) {
                AssertJUnit.assertTrue((String)(n + " should be registered"), (boolean)this.mBeanServer.isRegistered(n));
                continue;
            }
            AssertJUnit.assertFalse((String)(n + " should not be registered"), (boolean)this.mBeanServer.isRegistered(n));
        }
    }
}

