/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.statetransfer.DefaultStateTransferManager;
import org.jboss.cache.util.TestingUtil;
import org.jboss.util.stream.MarshalledValueInputStream;
import org.jboss.util.stream.MarshalledValueOutputStream;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="loader.AsyncFileCacheLoaderTest")
public class AsyncFileCacheLoaderTest
extends AbstractCacheLoaderTestBase {
    private CacheSPI<Object, Object> cache;

    protected void configureCache() throws Exception {
        this.configureCache("");
    }

    protected void configureCache(String props) throws Exception {
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(false);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.FileCacheLoader", props, true, false, true));
        this.cache.create();
        this.cache.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache != null) {
            TestingUtil.killCaches(new Cache[]{this.cache});
            this.cache = null;
        }
    }

    public void testRestrictionOnAddingToQueue() throws Exception {
        this.configureCache();
        CacheLoader loader = this.cache.getCacheLoaderManager().getCacheLoader();
        loader.remove(Fqn.fromString((String)"/blah"));
        loader.put(Fqn.fromString((String)"/blah"), (Object)"one", (Object)"two");
        loader.put(Fqn.fromString((String)"/blah"), (Object)"three", (Object)"four");
        loader.put(Fqn.fromString((String)"/blah"), (Object)"five", (Object)"six");
        loader.put(Fqn.fromString((String)"/blah"), (Object)"seven", (Object)"eight");
        loader.stop();
        try {
            loader.remove(Fqn.fromString((String)"/blah"));
            AssertJUnit.assertTrue((String)"Should have restricted this entry from being made", (boolean)false);
        }
        catch (CacheException e) {
            AssertJUnit.assertTrue((boolean)true);
        }
        loader.start();
        loader.remove(Fqn.fromString((String)"/blah"));
    }

    public void testPutImmediate() throws Exception {
        this.configureCache("cache.async.put=false\ncache.async.pollWait=10000\n");
        CacheLoader loader = this.cache.getCacheLoaderManager().getCacheLoader();
        Fqn fqn = Fqn.fromString((String)"/a/b/c/d");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("c", "d");
        Modification mod = new Modification(Modification.ModificationType.PUT_KEY_VALUE, fqn, (Object)"e", (Object)"f");
        loader.put(fqn, map);
        loader.put(fqn, (Object)"a", (Object)"b");
        loader.put(Collections.singletonList(mod));
        System.out.println(loader.get(fqn));
        AssertJUnit.assertEquals((String)"put right away", (int)3, (int)loader.get(fqn).size());
        loader.remove(fqn);
    }

    public void testBounded() throws Exception {
        this.configureCache("cache.async.queueSize=1\ncache.async.pollWait=10\n");
        CacheLoader loader = this.cache.getCacheLoaderManager().getCacheLoader();
        Fqn fqn = Fqn.fromString((String)"/bound");
        loader.remove(fqn);
        for (int i = 0; i < 50; ++i) {
            this.cache.put(fqn, (Object)("key" + i), (Object)"value1");
        }
        Thread.sleep(1000L);
        AssertJUnit.assertEquals((int)50, (int)loader.get(fqn).size());
        loader.remove(fqn);
    }

    public void testNoReturnOld() throws Exception {
        this.configureCache("cache.async.returnOld=false\ncache.async.pollWait=10\n");
        CacheLoader loader = this.cache.getCacheLoaderManager().getCacheLoader();
        System.out.println("Loader " + loader);
        this.cache.put(Fqn.ROOT, (Object)"key1", (Object)"value1");
        Thread.sleep(100L);
        AssertJUnit.assertEquals(null, (Object)loader.put(Fqn.ROOT, (Object)"key1", (Object)"value1"));
        AssertJUnit.assertEquals(null, (Object)loader.remove(Fqn.ROOT, (Object)"key1"));
        loader.remove(Fqn.ROOT);
    }

    public void testStoreState() throws Exception {
        this.configureCache();
        Fqn X = Fqn.fromString((String)"/x");
        CacheLoader loader = this.cache.getCacheLoaderManager().getCacheLoader();
        loader.remove(X);
        this.cache.put(X, (Object)"key1", (Object)"value1");
        Thread.sleep(1000L);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
        loader.loadEntireState((ObjectOutputStream)os);
        this.cache.getMarshaller().objectToObjectStream((Object)DefaultStateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)os);
        AssertJUnit.assertTrue((baos.size() > 0 ? 1 : 0) != 0);
        loader.remove(X);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        MarshalledValueInputStream is = new MarshalledValueInputStream((InputStream)bais);
        loader.storeEntireState((ObjectInputStream)is);
        AssertJUnit.assertEquals((String)"X found", (boolean)true, (boolean)loader.exists(X));
        loader.remove(X);
    }

    public void testMultipleThreads() throws Exception {
        this.configureCache("cache.async.queueSize=1\ncache.async.pollWait=10\ncache.async.threadPoolSize=5");
        CacheLoader loader = this.cache.getCacheLoaderManager().getCacheLoader();
        Fqn fqn = Fqn.fromString((String)"/bound");
        loader.remove(fqn);
        for (int i = 0; i < 50; ++i) {
            this.cache.put(fqn, (Object)("key" + i), (Object)"value1");
        }
        Thread.sleep(1000L);
        AssertJUnit.assertEquals((int)50, (int)loader.get(fqn).size());
        loader.remove(fqn);
    }
}

