/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.loader.CacheLoaderTestsBase;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loader.BdbjeCacheLoaderTest")
public class BdbjeCacheLoaderTest
extends CacheLoaderTestsBase {
    protected void configureCache() throws Exception {
        CacheSPI cache = (CacheSPI)this.cacheTL.get();
        String tmpDir = System.getProperty("java.io.tmpdir", "/tmp");
        String threadId = Thread.currentThread().getName();
        String tmpCLLoc = tmpDir + "/JBossCache-BdbjeCacheLoaderTest-" + threadId;
        cache.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.bdbje.BdbjeCacheLoader", "location=" + tmpCLLoc, false, true, false));
        TestingUtil.recursiveFileRemove(tmpCLLoc);
    }

    public void testTransaction() throws Exception {
        CacheSPI cache = (CacheSPI)this.cacheTL.get();
        Fqn fqn = Fqn.fromString((String)"/a/b/c");
        String key = "key";
        String value = "value";
        cache.put(fqn, (Object)key, (Object)value);
        cache.getTransactionManager().begin();
        AssertJUnit.assertEquals((Object)value, (Object)cache.get(fqn, (Object)key));
        cache.getTransactionManager().commit();
        cache.getTransactionManager().begin();
        AssertJUnit.assertEquals((Object)value, (Object)cache.get(fqn, (Object)key));
        cache.getTransactionManager().commit();
    }
}

