/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.ChainingCacheLoader;
import org.jboss.cache.loader.ReadOnlyDelegatingCacheLoader;
import org.jboss.cache.loader.SamplePojo;
import org.jboss.cache.statetransfer.DefaultStateTransferManager;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.cache.util.TestingUtil;
import org.jboss.util.stream.MarshalledValueInputStream;
import org.jboss.util.stream.MarshalledValueOutputStream;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, sequential=true, testName="loader.CacheLoaderTestsBase")
public abstract class CacheLoaderTestsBase
extends AbstractCacheLoaderTestBase {
    private static final Log log = LogFactory.getLog(CacheLoaderTestsBase.class);
    protected ThreadLocal<CacheSPI<Object, Object>> cacheTL = new ThreadLocal();
    ThreadLocal<CacheLoader> loaderTL = new ThreadLocal();
    static final Fqn FQN = Fqn.fromString((String)"/key");
    private static final Fqn SUBTREE_FQN = Fqn.fromRelativeElements((Fqn)FQN, (Object[])new String[]{"subtree"});
    private static final Fqn BUDDY_BASE = Fqn.fromRelativeElements((Fqn)BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{"test"});
    private static final Fqn BUDDY_PLUS_FQN = Fqn.fromRelativeFqn((Fqn)BUDDY_BASE, (Fqn)FQN);
    private static final Fqn BUDDY_PLUS_SUBTREE_FQN = Fqn.fromRelativeFqn((Fqn)BUDDY_BASE, (Fqn)SUBTREE_FQN);

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        CacheSPI cache = (CacheSPI)new UnitTestCacheFactory().createCache(false);
        this.cacheTL.set((CacheSPI<Object, Object>)cache);
        Configuration c = cache.getConfiguration();
        c.setCacheMode(Configuration.CacheMode.LOCAL);
        c.setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        this.configureCache();
        cache.start();
        CacheLoader loader = cache.getCacheLoaderManager().getCacheLoader();
        this.loaderTL.set(loader);
        this.postConfigure();
    }

    protected void postConfigure() {
    }

    protected abstract void configureCache() throws Exception;

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cleanup();
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        TestingUtil.killCaches(new Cache[]{cache});
        this.cacheTL.set(null);
        this.loaderTL.set(null);
    }

    protected void cleanup() {
    }

    protected void addDelay() {
    }

    protected boolean exists(String fqn, String key) {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        NodeSPI n = cache.peek(Fqn.fromString((String)fqn), false, false);
        if (key == null) {
            return n != null;
        }
        return n != null && n.getKeysDirect().contains(key);
    }

    public void testPrint() throws CacheException {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        Fqn NODE = Fqn.fromString((String)"/test");
        String KEY = "key";
        cache.put(NODE, (Object)"key", (Object)10);
        cache.evict(NODE, false);
        this.addDelay();
        NodeSPI ret = cache.getNode(NODE);
        AssertJUnit.assertNotNull((Object)ret);
    }

    public void testPut() throws CacheException {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        String NODE = "/test";
        String KEY = "key";
        cache.removeNode("/test");
        this.addDelay();
        Object retval = cache.put("/test", (Object)"key", (Object)10);
        AssertJUnit.assertEquals(null, (Object)retval);
        retval = cache.put("/test", (Object)"key", (Object)20);
        this.addDelay();
        AssertJUnit.assertEquals((Object)10, (Object)retval);
        cache.evict(Fqn.fromString((String)"/test"), false);
        this.addDelay();
        log.debug((Object)"put 30, expect 20 back");
        retval = cache.put("/test", (Object)"key", (Object)30);
        AssertJUnit.assertEquals((Object)20, (Object)retval);
    }

    public void testPut2() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        String NODE = "/a/b/c";
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/a/b/c")));
        String KEY = "key";
        cache.removeNode("/a/b/c");
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/a/b/c")));
        this.addDelay();
        Object retval = cache.put("/a/b/c", (Object)"key", (Object)10);
        AssertJUnit.assertNull((Object)retval);
        this.addDelay();
        retval = cache.put("/a/b/c", (Object)"key", (Object)20);
        AssertJUnit.assertEquals((Object)10, (Object)retval);
        cache.evict(Fqn.fromString((String)"/a/b/c"), false);
        cache.evict(Fqn.fromString((String)"/a/b"), false);
        cache.evict(Fqn.fromString((String)"/a"), false);
        this.addDelay();
        log.debug((Object)"replace KEY with 30, expect 20");
        retval = cache.put("/a/b/c", (Object)"key", (Object)30);
        AssertJUnit.assertEquals((Object)20, (Object)retval);
    }

    public void testPut3() throws Exception {
        Fqn NODE = Fqn.fromString((String)"/a/b/c");
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        cache.removeNode(NODE);
        this.addDelay();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "b");
        m.put("c", "d");
        HashMap<String, String> m2 = new HashMap<String, String>();
        m2.put("e", "f");
        m2.put("g", "h");
        cache.put(NODE, m);
        this.addDelay();
        cache.get(NODE, (Object)"X");
        AssertJUnit.assertEquals(m, (Object)loader.get(NODE));
        AssertJUnit.assertEquals(m, (Object)cache.getNode(NODE).getData());
        cache.evict(NODE, false);
        this.addDelay();
        cache.get(NODE, (Object)"X");
        AssertJUnit.assertEquals(m, (Object)cache.getNode(NODE).getData());
        cache.evict(NODE, false);
        cache.get(NODE, (Object)"X");
        cache.put(NODE, m2);
        AssertJUnit.assertEquals((String)"combined", (int)4, (int)cache.getNode(NODE).getData().size());
    }

    public void testPutNullDataMap() throws Exception {
        Fqn f = Fqn.fromString((String)"/a");
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        assert (!cache.exists(f));
        assert (!loader.exists(f));
        cache.put(f, null);
        Map fromLoader = loader.get(f);
        assert (fromLoader != null) : "Node should exist in the loader";
        assert (fromLoader.isEmpty()) : "Should not contain any data";
    }

    public void testPutNullDataMapNodeHasData() throws Exception {
        Fqn f = Fqn.fromString((String)"/a");
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        cache.put(f, (Object)"key", (Object)"value");
        assert (cache.exists(f));
        assert (loader.exists(f));
        cache.put(f, null);
        Map fromLoader = loader.get(f);
        assert (fromLoader != null) : "Node should exist in the loader";
        assert (fromLoader.size() == 1) : "Should contain original data";
    }

    public void testShallowMove() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        Fqn a = Fqn.fromString((String)"/a");
        Fqn b = Fqn.fromString((String)"/b");
        Fqn a_b = Fqn.fromString((String)"/a/b");
        String key = "key";
        String valueA = "A";
        String valueB = "B";
        cache.put(a, (Object)key, (Object)valueA);
        cache.put(b, (Object)key, (Object)valueB);
        this.addDelay();
        CacheLoader loader = cache.getCacheLoaderManager().getCacheLoader();
        AssertJUnit.assertEquals((Object)valueA, loader.get(a).get(key));
        AssertJUnit.assertEquals((Object)valueB, loader.get(b).get(key));
        AssertJUnit.assertTrue((boolean)loader.getChildrenNames(Fqn.ROOT).contains("a"));
        AssertJUnit.assertTrue((boolean)loader.getChildrenNames(Fqn.ROOT).contains("b"));
        cache.move(b, a);
        this.addDelay();
        AssertJUnit.assertEquals((Object)valueA, loader.get(a).get(key));
        AssertJUnit.assertNull((Object)loader.get(b));
        AssertJUnit.assertEquals((Object)valueB, loader.get(a_b).get(key));
    }

    public void testDeepMove() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        Fqn a = Fqn.fromString((String)"/a");
        Fqn b = Fqn.fromString((String)"/b");
        Fqn a_b = Fqn.fromString((String)"/a/b");
        Fqn b_c = Fqn.fromString((String)"/b/c");
        Fqn a_b_c = Fqn.fromString((String)"/a/b/c");
        String key = "key";
        String valueA = "A";
        String valueB = "B";
        String valueC = "C";
        cache.put(a, (Object)key, (Object)valueA);
        cache.put(b, (Object)key, (Object)valueB);
        cache.put(b_c, (Object)key, (Object)valueC);
        this.addDelay();
        AssertJUnit.assertEquals((Object)valueA, cache.getCacheLoaderManager().getCacheLoader().get(a).get(key));
        AssertJUnit.assertEquals((Object)valueB, cache.getCacheLoaderManager().getCacheLoader().get(b).get(key));
        AssertJUnit.assertEquals((Object)valueC, cache.getCacheLoaderManager().getCacheLoader().get(b_c).get(key));
        cache.move(b, a);
        this.addDelay();
        AssertJUnit.assertEquals((Object)valueA, cache.getCacheLoaderManager().getCacheLoader().get(a).get(key));
        AssertJUnit.assertNull((Object)cache.getCacheLoaderManager().getCacheLoader().get(b));
        AssertJUnit.assertEquals((Object)valueB, cache.getCacheLoaderManager().getCacheLoader().get(a_b).get(key));
        AssertJUnit.assertNull((Object)cache.getCacheLoaderManager().getCacheLoader().get(b_c));
        AssertJUnit.assertEquals((Object)valueC, cache.getCacheLoaderManager().getCacheLoader().get(a_b_c).get(key));
    }

    public void testPutRemoveCombos() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        String NODE = "/a/b/c";
        cache.removeNode("/a/b/c");
        Fqn fqn = Fqn.fromString((String)"/a/b/c");
        this.addDelay();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("a", "b");
        m.put("c", "d");
        loader.put(fqn, m);
        cache.put("/a/b/c", (Object)"e", (Object)"f");
        this.addDelay();
        cache.get("/a/b/c", (Object)"X");
        AssertJUnit.assertEquals((int)3, (int)cache.getNode("/a/b/c").getData().size());
        cache.evict(fqn, false);
        cache.get("/a/b/c", (Object)"X");
        cache.remove("/a/b/c", (Object)"e");
        AssertJUnit.assertEquals((int)2, (int)cache.getNode("/a/b/c").getData().size());
    }

    public void testGet() throws CacheException {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        String NODE = "/a/b/c";
        cache.removeNode("/a/b/c");
        this.addDelay();
        Object retval = cache.put("/a/b/c", (Object)"1", (Object)10);
        AssertJUnit.assertNull((Object)retval);
        this.addDelay();
        cache.put("/a/b/c", (Object)"2", (Object)20);
        cache.evict(Fqn.fromString((String)"/a/b/c"), false);
        AssertJUnit.assertNull((String)"DataNode should not exisit ", (Object)cache.peek(Fqn.fromString((String)"/a/b/c"), false, false));
        this.addDelay();
        retval = cache.get("/a/b/c", (Object)"1");
        AssertJUnit.assertEquals((Object)10, (Object)retval);
        retval = cache.get("/a/b/c", (Object)"2");
        AssertJUnit.assertEquals((Object)20, (Object)retval);
    }

    public void testGetNode() throws CacheException {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        String NODE = "/a/b/c";
        cache.removeNode("/a/b/c");
        this.addDelay();
        cache.put("/a/b/c", (Object)"1", (Object)10);
        cache.evict(Fqn.fromString((String)"/a/b/c"), false);
        AssertJUnit.assertNull((String)"DataNode should not exisit ", (Object)cache.peek(Fqn.fromString((String)"/a/b/c"), false, false));
        this.addDelay();
        NodeSPI retval = cache.getNode("/a/b/c");
        AssertJUnit.assertNotNull((String)"Should not be null", (Object)retval);
        AssertJUnit.assertEquals((Object)10, (Object)retval.get((Object)"1"));
    }

    public void testSerialization() throws CacheException {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        SamplePojo pojo = new SamplePojo(39, "Bela");
        pojo.getHobbies().add("Running");
        pojo.getHobbies().add("Beerathlon");
        pojo.getHobbies().add("Triathlon");
        cache.put("/mypojo", (Object)322649, (Object)pojo);
        this.addDelay();
        AssertJUnit.assertNotNull((Object)cache.get("/mypojo", (Object)322649));
        cache.evict(Fqn.fromString((String)"/mypojo"), false);
        AssertJUnit.assertNull((Object)cache.peek(Fqn.fromString((String)"/mypojo"), false, false));
        SamplePojo pojo2 = (SamplePojo)cache.get("/mypojo", (Object)322649);
        AssertJUnit.assertNotNull((Object)pojo2);
        AssertJUnit.assertEquals((int)39, (int)pojo2.getAge());
        AssertJUnit.assertEquals((String)"Bela", (String)pojo2.getName());
        AssertJUnit.assertEquals((int)3, (int)pojo2.getHobbies().size());
    }

    public void testPopulate() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            for (int i = 0; i < 10; ++i) {
                m.put("key" + i, "val" + i);
            }
            cache.put("/a/b/c", m);
            cache.getCacheLoaderManager().preload(Fqn.fromString((String)"/1/2/3/4/5"), true, true);
            cache.put("/1/2/3/4/5", null);
            cache.put("/1/2/3/4/5/a", null);
            cache.put("/1/2/3/4/5/b", null);
            cache.put("/1/2/3/4/5/c", null);
            cache.put("/1/2/3/4/5/d", null);
            cache.put("/1/2/3/4/5/e", null);
            cache.put("/1/2/3/4/5/d/one", null);
            cache.put("/1/2/3/4/5/d/two", null);
            cache.put("/1/2/3/4/5/d/three", null);
            System.out.println("cache: " + cache);
            AssertJUnit.assertTrue((boolean)cache.exists("/1/2/3/4"));
            AssertJUnit.assertTrue((boolean)cache.exists("/a/b/c"));
            assert (!this.exists("/a/b/c/d", null));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testPreloading() throws CacheException {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        cache.removeNode(Fqn.ROOT);
        cache.put("1/2/3/4/5/d", (Object)"key", (Object)"val");
        cache.evict(Fqn.fromString((String)"1/2/3/4/5/d"));
        System.out.println("-- checking for 1/2/3/4/5/d");
        this.addDelay();
        assert (!this.exists("1/2/3/4/5/d", null));
        cache.getNode("1/2/3/4/5/d");
        AssertJUnit.assertTrue((boolean)cache.exists("1/2/3/4/5/d"));
        System.out.println("-- 1/2/3/4/5/d exists");
    }

    public void testCacheLoading2() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        Set keys = null;
        cache.put("/a/b/c", (Object)"key", (Object)"val");
        keys = cache.getNode("/a/b/c").getKeys();
        AssertJUnit.assertNotNull((Object)keys);
        AssertJUnit.assertEquals((int)1, (int)keys.size());
    }

    public void testExists() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        cache.put("/eins/zwei/drei", (Object)"key1", (Object)"val1");
        AssertJUnit.assertTrue((boolean)cache.exists("/eins/zwei/drei"));
        assert (this.exists("/eins/zwei/drei", "key1"));
        assert (!this.exists("/eins/zwei/drei", "key2"));
        assert (!this.exists("/uno/due/tre", null));
        assert (!this.exists("/une/due/tre", "key1"));
    }

    public void testGetChildren() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        try {
            cache.put("/1/2/3/4/5/d/one", null);
            cache.put("/1/2/3/4/5/d/two", null);
            cache.put("/1/2/3/4/5/d/three", null);
            Set children = cache.getNode("/1/2/3/4/5/d").getChildrenNames();
            AssertJUnit.assertNotNull((Object)children);
            AssertJUnit.assertEquals((int)3, (int)children.size());
            AssertJUnit.assertTrue((boolean)children.contains("one"));
            AssertJUnit.assertTrue((boolean)children.contains("two"));
            AssertJUnit.assertTrue((boolean)children.contains("three"));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildrenWithEviction() throws CacheException {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        cache.put("/a/b/c/1", null);
        cache.put("/a/b/c/2", null);
        cache.put("/a/b/c/3", null);
        cache.evict(Fqn.fromString((String)"/a/b/c/1"));
        cache.evict(Fqn.fromString((String)"/a/b/c/2"));
        cache.evict(Fqn.fromString((String)"/a/b/c/3"));
        cache.evict(Fqn.fromString((String)"/a/b/c"));
        cache.evict(Fqn.fromString((String)"/a/b"));
        cache.evict(Fqn.fromString((String)"/a"));
        cache.evict(Fqn.fromString((String)"/"));
        this.addDelay();
        Set children = cache.getNode("/a/b/c").getChildrenNames();
        AssertJUnit.assertNotNull((Object)children);
        AssertJUnit.assertEquals((int)3, (int)children.size());
        AssertJUnit.assertTrue((boolean)children.contains("1"));
        AssertJUnit.assertTrue((boolean)children.contains("2"));
        AssertJUnit.assertTrue((boolean)children.contains("3"));
    }

    public void testGetChildren2() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        try {
            cache.put("/1", null);
            cache.put("a", null);
            Set children = cache.getRoot().getChildrenNames();
            AssertJUnit.assertNotNull((Object)children);
            AssertJUnit.assertEquals((int)2, (int)children.size());
            AssertJUnit.assertTrue((boolean)children.contains("1"));
            AssertJUnit.assertTrue((boolean)children.contains("a"));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren3() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        try {
            cache.put("/1", null);
            cache.put("a", null);
            Set children = cache.getRoot().getChildrenNames();
            AssertJUnit.assertNotNull((Object)children);
            AssertJUnit.assertEquals((int)2, (int)children.size());
            AssertJUnit.assertTrue((boolean)children.contains("1"));
            AssertJUnit.assertTrue((boolean)children.contains("a"));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren4() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        try {
            if (!cache.exists("/a/b/c")) {
                cache.put("/a/b/c", null);
            }
            Set children = cache.getChildrenNames((Fqn)null);
            AssertJUnit.assertTrue((boolean)children.isEmpty());
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren5() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        try {
            cache.put("/a/1", null);
            cache.put("/a/2", null);
            cache.put("/a/3", null);
            NodeSPI n = cache.getNode("/a");
            AssertJUnit.assertNotNull((Object)n);
            Set children = n.getChildrenNames();
            AssertJUnit.assertNotNull((Object)children);
            AssertJUnit.assertEquals((int)3, (int)children.size());
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren6() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        try {
            cache.put("/a/1", null);
            cache.put("/a/2", null);
            cache.put("/a/3", null);
            cache.evict(Fqn.fromString((String)"/a/1"));
            cache.evict(Fqn.fromString((String)"/a/2"));
            cache.evict(Fqn.fromString((String)"/a/3"));
            cache.evict(Fqn.fromString((String)"/a"));
            this.addDelay();
            AssertJUnit.assertNotNull((Object)cache.getNode("/a"));
            Set children = cache.getNode("/a").getChildrenNames();
            AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
            System.out.println("children: " + children);
            AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren7() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        try {
            cache.put("/a/1", null);
            cache.put("/a/2", null);
            cache.put("/a/3", null);
            cache.put("/a", (Object)"test", (Object)"test");
            cache.evict(Fqn.fromString((String)"/a/1"));
            cache.evict(Fqn.fromString((String)"/a/2"));
            cache.evict(Fqn.fromString((String)"/a/3"));
            cache.evict(Fqn.fromString((String)"/a"));
            this.addDelay();
            Object val = cache.get("/a", (Object)"test");
            AssertJUnit.assertEquals((String)"attributes weren't loaded", (Object)"test", (Object)val);
            Set children = cache.getNode("/a").getChildrenNames();
            AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
            System.out.println("children: " + children);
            AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren8() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        cache.put("/a/1", null);
        cache.put("/a/2", null);
        cache.put("/a/3", null);
        cache.evict(Fqn.fromString((String)"/a/1"));
        cache.evict(Fqn.fromString((String)"/a/2"));
        cache.evict(Fqn.fromString((String)"/a/3"));
        cache.evict(Fqn.fromString((String)"/a"));
        this.addDelay();
        AssertJUnit.assertNull((Object)cache.get("/a", (Object)"test"));
        cache.getNode("/a/1");
        Set children = cache.getNode("/a").getChildrenNames();
        AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
        System.out.println("children: " + children);
        AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
    }

    public void testGetChildren9() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        try {
            cache.put("/a/1", null);
            cache.put("/a/2", null);
            cache.put("/a/3", null);
            cache.evict(Fqn.fromString((String)"/a/1"));
            cache.evict(Fqn.fromString((String)"/a/2"));
            cache.evict(Fqn.fromString((String)"/a/3"));
            cache.evict(Fqn.fromString((String)"/a"));
            this.addDelay();
            AssertJUnit.assertNull((Object)cache.get("/a", (Object)"test"));
            cache.getNode("/a/1");
            Set children = cache.getNode("/a").getChildrenNames();
            AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
            System.out.println("children: " + children);
            AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
            cache.evict(Fqn.fromString((String)"/a/1"));
            cache.evict(Fqn.fromString((String)"/a/2"));
            cache.evict(Fqn.fromString((String)"/a/3"));
            cache.evict(Fqn.fromString((String)"/a"));
            AssertJUnit.assertNull((Object)cache.get("/a", (Object)"test"));
            cache.getNode("/a/1");
            children = cache.getNode("/a").getChildrenNames();
            AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
            System.out.println("children: " + children);
            AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren10() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        try {
            cache.put("/a/1", null);
            cache.put("/a/2", null);
            cache.put("/a/3", null);
            cache.evict(Fqn.fromString((String)"/a/1"));
            cache.evict(Fqn.fromString((String)"/a/2"));
            cache.evict(Fqn.fromString((String)"/a/3"));
            cache.evict(Fqn.fromString((String)"/a"));
            this.addDelay();
            AssertJUnit.assertNull((Object)cache.get("/a", (Object)"test"));
            cache.getNode("/a/1");
            Set children = cache.getNode("/a").getChildrenNames();
            AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
            System.out.println("children: " + children);
            AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
            children = cache.getNode("/a").getChildrenNames();
            AssertJUnit.assertNotNull((String)"No children were loaded", (Object)children);
            System.out.println("children: " + children);
            AssertJUnit.assertEquals((String)"3 children weren't loaded", (int)3, (int)children.size());
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren11() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        try {
            cache.put("/a/b", (Object)"key", (Object)"val");
            cache.put("/a/b/1", (Object)"key", (Object)"val");
            cache.put("/a/b/2", (Object)"key", (Object)"val");
            cache.put("/a/b/3", (Object)"key", (Object)"val");
            cache.put("/a/b/1/tmp", (Object)"key", (Object)"val");
            cache.put("/a/b/2/tmp", (Object)"key", (Object)"val");
            cache.put("/a/b/3/tmp", (Object)"key", (Object)"val");
            cache.evict(Fqn.fromString((String)"/a"));
            cache.evict(Fqn.fromString((String)"/a/b"));
            cache.evict(Fqn.fromString((String)"/a/b/1"));
            cache.evict(Fqn.fromString((String)"/a/b/2"));
            cache.evict(Fqn.fromString((String)"/a/b/3"));
            Set children = cache.getNode("/a/b").getChildrenNames();
            AssertJUnit.assertEquals((int)3, (int)children.size());
            cache.evict(Fqn.fromString((String)"/a/b"));
            cache.evict(Fqn.fromString((String)"/a/b/1/tmp"));
            cache.evict(Fqn.fromString((String)"/a/b/2/tmp"));
            cache.evict(Fqn.fromString((String)"/a/b/3/tmp"));
            cache.evict(Fqn.fromString((String)"/a/b/1"));
            cache.evict(Fqn.fromString((String)"/a/b/2"));
            cache.evict(Fqn.fromString((String)"/a/b/3"));
            cache.evict(Fqn.fromString((String)"/a"));
            children = cache.getNode("/a/b").getChildrenNames();
            AssertJUnit.assertEquals((int)3, (int)children.size());
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testGetChildren12() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        cache.put("/a/b", (Object)"key", (Object)"val");
        cache.put("/a/b/1", (Object)"key", (Object)"val");
        cache.put("/a/b/2", (Object)"key", (Object)"val");
        cache.put("/a/b/3", (Object)"key", (Object)"val");
        Set children = cache.getNode("/a/b").getChildrenNames();
        AssertJUnit.assertEquals((int)3, (int)children.size());
        cache.evict(Fqn.fromString((String)"/a/b/3"));
        cache.evict(Fqn.fromString((String)"/a/b/2"));
        cache.evict(Fqn.fromString((String)"/a/b"));
        cache.evict(Fqn.fromString((String)"/a"));
        NodeSPI n = cache.getNode("/a/b");
        assert (!n.isChildrenLoaded());
        children = cache.getNode("/a/b").getChildrenNames();
        AssertJUnit.assertEquals((int)3, (int)children.size());
        cache.evict(Fqn.fromString((String)"/a/b/3"));
        cache.evict(Fqn.fromString((String)"/a/b/2"));
        cache.evict(Fqn.fromString((String)"/a/b"));
        cache.evict(Fqn.fromString((String)"/a"));
        children = cache.getNode("/a/b").getChildrenNames();
        AssertJUnit.assertEquals((int)3, (int)children.size());
    }

    public void testLoaderGetChildrenNames() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        Fqn f = Fqn.fromString((String)"/a");
        cache.put(f, (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", loader.get(f).get("k"));
        AssertJUnit.assertNull((Object)loader.getChildrenNames(f));
    }

    public void testGetKeys() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        Fqn f = Fqn.fromString((String)"/a");
        cache.put(f, (Object)"one", (Object)"one");
        cache.put(f, (Object)"two", (Object)"two");
        cache.evict(f);
        Set keys = cache.getRoot().getChild(f).getKeys();
        AssertJUnit.assertEquals((String)"Correct # of keys", (int)2, (int)keys.size());
        AssertJUnit.assertTrue((String)"Has key 'one", (boolean)keys.contains("one"));
        AssertJUnit.assertTrue((String)"Has key 'two", (boolean)keys.contains("two"));
    }

    public void testGetData() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        Fqn f = Fqn.fromString((String)"/a");
        assert (!cache.exists(f));
        assert (!loader.exists(f));
        cache.put(f, (Object)"one", (Object)"one");
        cache.put(f, (Object)"two", (Object)"two");
        cache.evict(f);
        Map data = cache.getRoot().getChild(f).getData();
        AssertJUnit.assertEquals((String)"incorrect # of entries", (int)2, (int)data.size());
        AssertJUnit.assertEquals((String)"Has key 'one", (Object)"one", data.get("one"));
        AssertJUnit.assertEquals((String)"Has key 'two", (Object)"two", data.get("two"));
    }

    public void testRemoveData() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        String key = "/x/y/z/";
        cache.put(key, (Object)"keyA", (Object)"valA");
        cache.put(key, (Object)"keyB", (Object)"valB");
        cache.put(key, (Object)"keyC", (Object)"valC");
        AssertJUnit.assertEquals((int)3, (int)cache.getNode(key).getKeys().size());
        cache.getNode(key).clearData();
        Set keys = cache.getNode(key).getKeys();
        AssertJUnit.assertEquals((int)0, (int)keys.size());
        cache.removeNode("/x");
        Object val = cache.get(key, (Object)"keyA");
        AssertJUnit.assertNull((Object)val);
    }

    public void testRemoveData2() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        Fqn key = Fqn.fromString((String)"/x/y/z/");
        cache.put(key, (Object)"keyA", (Object)"valA");
        cache.put(key, (Object)"keyB", (Object)"valB");
        cache.put(key, (Object)"keyC", (Object)"valC");
        this.addDelay();
        Set keys = cache.getNode(key).getKeys();
        AssertJUnit.assertEquals((int)3, (int)keys.size());
        cache.getNode(key).clearData();
        cache.evict(key);
        this.addDelay();
        keys = cache.getNode(key).getKeys();
        AssertJUnit.assertNotNull((Object)keys);
        AssertJUnit.assertEquals((int)0, (int)keys.size());
    }

    public void testRemoveData3() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        Fqn key = Fqn.fromString((String)"/x/y/z/");
        cache.put(key, (Object)"keyA", (Object)"valA");
        cache.put(key, (Object)"keyB", (Object)"valB");
        cache.put(key, (Object)"keyC", (Object)"valC");
        Set keys = cache.getNode(key).getKeys();
        AssertJUnit.assertEquals((int)3, (int)keys.size());
        cache.evict(key);
        cache.getNode(key).clearData();
        keys = cache.getNode(key).getKeys();
        AssertJUnit.assertEquals((String)"no more keys", (int)0, (int)keys.size());
    }

    public void testRemoveData4() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        Fqn key = Fqn.fromString((String)"/x/y/z/");
        cache.put(key, (Object)"keyA", (Object)"valA");
        cache.put(key, (Object)"keyB", (Object)"valB");
        cache.put(key, (Object)"keyC", (Object)"valC");
        Set keys = cache.getNode(key).getKeys();
        AssertJUnit.assertEquals((int)3, (int)keys.size());
        cache.evict(key);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("keyA", "valA");
        map.put("keyB", "valB");
        map.put("keyC", "valC");
        AssertJUnit.assertEquals(map, (Object)loader.get(key));
        Node n = cache.getRoot().getChild(key);
        n.clearData();
        AssertJUnit.assertEquals(Collections.emptyMap(), (Object)loader.get(key));
    }

    public void testReplaceAll() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        Fqn key = Fqn.fromString((String)"/x/y/z/");
        cache.put(key, (Object)"keyA", (Object)"valA");
        cache.put(key, (Object)"keyB", (Object)"valB");
        cache.put(key, (Object)"keyC", (Object)"valC");
        Set keys = cache.getNode(key).getKeys();
        AssertJUnit.assertEquals((int)3, (int)keys.size());
        cache.evict(key);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("keyA", "valA");
        map.put("keyB", "valB");
        map.put("keyC", "valC");
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.put("keyD", "valD");
        newMap.put("keyE", "valE");
        AssertJUnit.assertEquals(map, (Object)loader.get(key));
        Node n = cache.getRoot().getChild(key);
        n.replaceAll(newMap);
        AssertJUnit.assertEquals(newMap, (Object)loader.get(key));
    }

    public void testRemoveKey() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        String key = "/x/y/z/";
        cache.put(key, (Object)"keyA", (Object)"valA");
        AssertJUnit.assertEquals((int)1, (int)cache.getNode(key).getKeys().size());
        cache.put(key, (Object)"keyB", (Object)"valB");
        AssertJUnit.assertEquals((int)2, (int)cache.getNode(key).getKeys().size());
        cache.put(key, (Object)"keyC", (Object)"valC");
        AssertJUnit.assertEquals((int)3, (int)cache.getNode(key).getKeys().size());
        cache.remove(key, (Object)"keyA");
        AssertJUnit.assertEquals((int)2, (int)cache.getNode(key).getKeys().size());
        cache.removeNode("/x");
    }

    public void testRemoveKey2() throws CacheException {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        String NODE = "/test";
        String KEY = "key";
        cache.removeNode("/test");
        Object retval = cache.put("/test", (Object)"key", (Object)10);
        AssertJUnit.assertNull((Object)retval);
        this.addDelay();
        retval = cache.remove("/test", (Object)"key");
        AssertJUnit.assertEquals((Object)10, (Object)retval);
        this.addDelay();
        retval = cache.remove("/test", (Object)"key");
        AssertJUnit.assertNull((Object)retval);
    }

    public void testRemoveKey3() throws CacheException {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        String NODE = "/test";
        String KEY = "key";
        cache.removeNode("/test");
        Object retval = cache.put("/test", (Object)"key", (Object)10);
        AssertJUnit.assertNull((Object)retval);
        cache.evict(Fqn.fromString((String)"/test"));
        this.addDelay();
        retval = cache.remove("/test", (Object)"key");
        AssertJUnit.assertEquals((Object)10, (Object)retval);
        cache.evict(Fqn.fromString((String)"/test"));
        this.addDelay();
        retval = cache.remove("/test", (Object)"key");
        AssertJUnit.assertNull((Object)retval);
    }

    public void testRemove() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        String key = "/x/y/z/";
        cache.put(key, (Object)"keyA", (Object)"valA");
        cache.put(key, (Object)"keyB", (Object)"valB");
        cache.put(key, (Object)"keyC", (Object)"valC");
        cache.removeNode("/x");
        AssertJUnit.assertNull((Object)cache.get(key, (Object)"keyA"));
        this.addDelay();
        Set keys = cache.getKeys(key);
        AssertJUnit.assertNull((String)("got keys " + keys), (Object)keys);
        cache.removeNode("/x");
    }

    public void testRemoveRoot() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        AssertJUnit.assertEquals((int)0, (int)cache.getRoot().getKeys().size());
        cache.put("/1/2/3/4/5", null);
        cache.put("uno/due/tre", null);
        cache.put("1/2/3/a", null);
        cache.put("/eins/zwei/drei", null);
        cache.put("/one/two/three", null);
        cache.removeNode(Fqn.ROOT);
        AssertJUnit.assertEquals((int)0, (int)cache.getRoot().getKeys().size());
    }

    public void testLoaderRemoveRoot() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        Fqn f = Fqn.fromString((String)"/a");
        loader.put(f, (Object)"k", (Object)"v");
        AssertJUnit.assertTrue((boolean)loader.get(f).containsKey("k"));
        loader.remove(f);
        AssertJUnit.assertNull((Object)loader.get(f));
        loader.put(f, (Object)"k", (Object)"v");
        AssertJUnit.assertTrue((boolean)loader.get(f).containsKey("k"));
        loader.remove(Fqn.ROOT);
        AssertJUnit.assertNull((String)"Removing Fqn.ROOT should cause all children to be removed as well", (Object)loader.get(f));
    }

    public void testEvictionWithCacheLoader() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        cache.put("/first/second", (Object)"key1", (Object)"val1");
        cache.put("/first/second/third", (Object)"key2", (Object)"val2");
        cache.evict(Fqn.fromString((String)"/first/second"));
        this.addDelay();
        AssertJUnit.assertTrue((boolean)cache.exists("/first/second/third"));
        AssertJUnit.assertTrue((boolean)cache.exists("/first/second"));
        AssertJUnit.assertTrue((boolean)cache.exists("/first"));
        String val = (String)cache.get("/first/second", (Object)"key1");
        AssertJUnit.assertEquals((String)"val1", (String)val);
        AssertJUnit.assertTrue((boolean)cache.exists("/first/second/third"));
        AssertJUnit.assertTrue((boolean)cache.exists("/first/second"));
        AssertJUnit.assertTrue((boolean)cache.exists("/first"));
    }

    public void testEvictionWithCacheLoader2() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        cache.put("/first/second/third", (Object)"key1", (Object)"val1");
        cache.evict(Fqn.fromString((String)"/first/second/third"));
        this.addDelay();
        assert (!this.exists("/first/second/third", null));
        AssertJUnit.assertTrue((boolean)cache.exists("/first/second"));
        AssertJUnit.assertTrue((boolean)cache.exists("/first"));
        String val = (String)cache.get("/first/second/third", (Object)"key1");
        AssertJUnit.assertEquals((String)"val1", (String)val);
        AssertJUnit.assertTrue((boolean)cache.exists("/first/second/third"));
        AssertJUnit.assertTrue((boolean)cache.exists("/first/second"));
        AssertJUnit.assertTrue((boolean)cache.exists("/first"));
    }

    public void testEvictionWithGetChildrenNames() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        cache.put("/a/1", null);
        cache.put("/a/2", null);
        cache.put("/a/3", null);
        cache.evict(Fqn.fromString((String)"/a/1"));
        cache.evict(Fqn.fromString((String)"/a/2"));
        cache.evict(Fqn.fromString((String)"/a/3"));
        cache.evict(Fqn.fromString((String)"/a"));
        this.addDelay();
        TransactionManager mgr = this.getTransactionManager();
        mgr.begin();
        Set children = cache.getNode("/a").getChildrenNames();
        AssertJUnit.assertEquals((int)3, (int)children.size());
        AssertJUnit.assertTrue((boolean)children.contains("1"));
        AssertJUnit.assertTrue((boolean)children.contains("2"));
        AssertJUnit.assertTrue((boolean)children.contains("3"));
        mgr.commit();
    }

    public void testTxPutCommit() throws Exception {
        TransactionManager mgr = this.getTransactionManager();
        mgr.begin();
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        cache.put("/one/two/three", (Object)"key1", (Object)"val1");
        cache.put("/one/two/three/four", (Object)"key2", (Object)"val2");
        mgr.commit();
        AssertJUnit.assertNotNull((String)"Cache has node /one/two/three", (Object)cache.getNode("/one/two/three").getKeys());
        AssertJUnit.assertNotNull((String)"Loader has node /one/two/three", (Object)loader.get(Fqn.fromString((String)"/one/two/three")));
        Set children = cache.getNode("/one").getChildrenNames();
        AssertJUnit.assertEquals((String)"Cache has correct number of children", (int)1, (int)children.size());
        children = loader.getChildrenNames(Fqn.fromString((String)"/one"));
        AssertJUnit.assertEquals((String)"Loader has correct number of children", (int)1, (int)children.size());
        cache.removeNode(Fqn.ROOT);
    }

    public void testTxPutRollback() throws Exception {
        TransactionManager mgr = this.getTransactionManager();
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        cache.removeNode("/one");
        this.addDelay();
        mgr.begin();
        cache.put("/one/two/three", (Object)"key1", (Object)"val1");
        cache.put("/one/two/three/four", (Object)"key2", (Object)"val2");
        log.debug((Object)("NODE1 " + cache.getNode("/one/two/three").getData()));
        mgr.rollback();
        log.debug((Object)("NODE2 " + cache.getNode("/one/two/three")));
        AssertJUnit.assertEquals(null, (Object)cache.get("/one/two/three", (Object)"key1"));
        AssertJUnit.assertEquals(null, (Object)cache.get("/one/two/three/four", (Object)"key2"));
        this.addDelay();
        AssertJUnit.assertNull((String)"Loader should not have node /one/two/three", (Object)loader.get(Fqn.fromString((String)"/one/two/three")));
        AssertJUnit.assertNull((String)"Cache should not have node /one/two/three", (Object)cache.getKeys("/one/two/three"));
        Set children = cache.getChildrenNames("/one");
        AssertJUnit.assertEquals((String)"Cache has no children under /one", (int)0, (int)children.size());
        children = loader.getChildrenNames(Fqn.fromString((String)"/one"));
        AssertJUnit.assertEquals((String)"Loader has no children under /one", null, (Object)children);
    }

    public void testBasicOperations() throws Exception {
        this.doTestBasicOperations();
    }

    public void testBasicOperationsTransactional() throws Exception {
        TransactionManager mgr = this.getTransactionManager();
        mgr.begin();
        this.doTestBasicOperations();
        mgr.commit();
    }

    private void doTestBasicOperations() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        this.doPutTests(Fqn.fromString((String)"/key"));
        this.doRemoveTests(Fqn.fromString((String)"/key"));
        this.doPutTests(Fqn.fromString((String)"/key1"));
        this.doPutTests(Fqn.fromString((String)"/key3"));
        this.doPutTests(Fqn.fromString((String)"/key2"));
        AssertJUnit.assertEquals((int)4, (int)loader.get(Fqn.fromString((String)"/key1")).size());
        AssertJUnit.assertEquals((int)4, (int)loader.get(Fqn.fromString((String)"/key2")).size());
        AssertJUnit.assertEquals((int)4, (int)loader.get(Fqn.fromString((String)"/key3")).size());
        this.doRemoveTests(Fqn.fromString((String)"/key2"));
        this.doRemoveTests(Fqn.fromString((String)"/key3"));
        this.doRemoveTests(Fqn.fromString((String)"/key1"));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key1")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key3")));
    }

    private void doPutTests(Fqn fqn) throws Exception {
        CacheLoader loader = this.loaderTL.get();
        AssertJUnit.assertTrue((!loader.exists(fqn) ? 1 : 0) != 0);
        Object oldVal = loader.put(fqn, (Object)"one", (Object)"two");
        AssertJUnit.assertNull((Object)oldVal);
        this.addDelay();
        oldVal = loader.put(fqn, (Object)"three", (Object)"four");
        AssertJUnit.assertNull((Object)oldVal);
        this.addDelay();
        AssertJUnit.assertEquals((Object)"two", loader.get(fqn).get("one"));
        AssertJUnit.assertEquals((Object)"four", loader.get(fqn).get("three"));
        this.addDelay();
        oldVal = loader.put(fqn, (Object)"one", (Object)"xxx");
        AssertJUnit.assertEquals((Object)"two", (Object)oldVal);
        this.addDelay();
        oldVal = loader.put(fqn, (Object)"one", (Object)"two");
        AssertJUnit.assertEquals((Object)"xxx", (Object)oldVal);
        this.addDelay();
        HashMap<String, String> map = new HashMap<String, String>(loader.get(fqn));
        AssertJUnit.assertEquals((int)2, (int)map.size());
        AssertJUnit.assertEquals((Object)"two", map.get("one"));
        AssertJUnit.assertEquals((Object)"four", map.get("three"));
        map.put("five", "six");
        map.put("seven", "eight");
        loader.put(fqn, map);
        this.addDelay();
        AssertJUnit.assertEquals((Object)"six", loader.get(fqn).get("five"));
        AssertJUnit.assertEquals((Object)"eight", loader.get(fqn).get("seven"));
        AssertJUnit.assertEquals(map, (Object)loader.get(fqn));
        AssertJUnit.assertEquals((int)4, (int)map.size());
        AssertJUnit.assertTrue((boolean)loader.exists(fqn));
    }

    private void doRemoveTests(Fqn fqn) throws Exception {
        CacheLoader loader = this.loaderTL.get();
        Object oldVal = loader.remove(fqn, (Object)"one");
        AssertJUnit.assertEquals((Object)"two", (Object)oldVal);
        this.addDelay();
        oldVal = loader.remove(fqn, (Object)"five");
        AssertJUnit.assertEquals((Object)"six", (Object)oldVal);
        this.addDelay();
        AssertJUnit.assertNull(loader.get(fqn).get("one"));
        AssertJUnit.assertNull(loader.get(fqn).get("five"));
        AssertJUnit.assertEquals((Object)"four", loader.get(fqn).get("three"));
        AssertJUnit.assertEquals((Object)"eight", loader.get(fqn).get("seven"));
        Map map = loader.get(fqn);
        AssertJUnit.assertEquals((int)2, (int)map.size());
        AssertJUnit.assertEquals((Object)"four", map.get("three"));
        AssertJUnit.assertEquals((Object)"eight", map.get("seven"));
        AssertJUnit.assertTrue((boolean)loader.exists(fqn));
        loader.remove(fqn);
        this.addDelay();
        map = loader.get(fqn);
        AssertJUnit.assertNull((String)"Should be null", (Object)map);
        AssertJUnit.assertTrue((!loader.exists(fqn) ? 1 : 0) != 0);
    }

    public void testMultiLevelTree() throws Exception {
        CacheLoader loader = this.loaderTL.get();
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key0")) ? 1 : 0) != 0);
        loader.put(Fqn.fromString((String)"/key0/level1/level2"), null);
        this.addDelay();
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key0/level1/level2")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key0/level1")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key0")));
        loader.put(Fqn.fromString((String)"/key0/x/y"), null);
        this.addDelay();
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key0/x/y")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key0/x")));
        loader.remove(Fqn.fromString((String)"/key0/x/y"));
        this.addDelay();
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key0/x/y")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key0/x")));
        loader.remove(Fqn.fromString((String)"/key0"));
        this.addDelay();
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key0")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key0/level1/level2")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key0/level1")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key0/x")) ? 1 : 0) != 0);
        loader.put(Fqn.fromString((String)"/key1"), null);
        loader.put(Fqn.fromString((String)"/key2"), null);
        loader.put(Fqn.fromString((String)"/key3"), null);
        this.addDelay();
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key1")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key3")));
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key3/level1")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key3/level1/level2")) ? 1 : 0) != 0);
        loader.put(Fqn.fromString((String)"/key3/level1/level2"), null);
        this.addDelay();
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key3/level1/level2")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key1")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key3")));
        loader.remove(Fqn.fromString((String)"/key3/level1"));
        this.addDelay();
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key3/level1/level2")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key3/level1")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key1")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key3")));
        loader.remove(Fqn.fromString((String)"/key1"));
        this.addDelay();
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key1")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key3")));
        loader.remove(Fqn.fromString((String)"/key3"));
        this.addDelay();
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key3")) ? 1 : 0) != 0);
        loader.remove(Fqn.fromString((String)"/key2"));
        this.addDelay();
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key0")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key1")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key2")) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!loader.exists(Fqn.fromString((String)"/key3")) ? 1 : 0) != 0);
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key0")));
        loader.put(Fqn.fromString((String)"/key0/level1/level2"), (Object)"a", (Object)"b");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key0/level1/level2")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key0/level1")));
        AssertJUnit.assertEquals((int)0, (int)loader.get(Fqn.fromString((String)"/key0/level1")).size());
        AssertJUnit.assertEquals((int)0, (int)loader.get(Fqn.fromString((String)"/key0")).size());
        loader.put(Fqn.fromString((String)"/key0/x/y"), (Object)"a", (Object)"b");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key0/x/y")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key0/x")));
        AssertJUnit.assertEquals((int)0, (int)loader.get(Fqn.fromString((String)"/key0/x")).size());
        loader.remove(Fqn.fromString((String)"/key0/x/y"));
        this.addDelay();
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key0/x/y")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key0/x")));
        AssertJUnit.assertEquals((int)0, (int)loader.get(Fqn.fromString((String)"/key0/x")).size());
        loader.remove(Fqn.fromString((String)"/key0"));
        this.addDelay();
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key0")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key0/level1/level2")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key0/level1")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key0/x")));
        loader.put(Fqn.fromString((String)"/key1"), (Object)"a", (Object)"b");
        loader.put(Fqn.fromString((String)"/key2"), (Object)"a", (Object)"b");
        loader.put(Fqn.fromString((String)"/key3"), (Object)"a", (Object)"b");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key1")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key3")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key3/level1/level2")));
        loader.put(Fqn.fromString((String)"/key3/level1/level2"), (Object)"a", (Object)"b");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key3/level1/level2")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertEquals((int)0, (int)loader.get(Fqn.fromString((String)"/key3/level1")).size());
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key1")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key3")));
        loader.remove(Fqn.fromString((String)"/key3/level1"));
        this.addDelay();
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key3/level1/level2")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key3/level1")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key1")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key3")));
        loader.remove(Fqn.fromString((String)"/key1"));
        this.addDelay();
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key1")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key3")));
        loader.remove(Fqn.fromString((String)"/key3"));
        this.addDelay();
        AssertJUnit.assertNotNull((Object)loader.get(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key3")));
        loader.remove(Fqn.fromString((String)"/key2"));
        this.addDelay();
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key0")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key1")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key2")));
        AssertJUnit.assertNull((Object)loader.get(Fqn.fromString((String)"/key3")));
    }

    public void testGetChildrenNames() throws Exception {
        CacheLoader loader = this.loaderTL.get();
        this.checkChildren(Fqn.ROOT, null);
        this.checkChildren(Fqn.fromString((String)"/key0"), null);
        loader.put(Fqn.fromString((String)"/key0"), null);
        this.addDelay();
        this.checkChildren(Fqn.ROOT, new String[]{"key0"});
        loader.put(Fqn.fromString((String)"/key1/x"), null);
        this.addDelay();
        this.checkChildren(Fqn.ROOT, new String[]{"key0", "key1"});
        this.checkChildren(Fqn.fromString((String)"/key1"), new String[]{"x"});
        loader.remove(Fqn.fromString((String)"/key1/x"));
        this.addDelay();
        this.checkChildren(Fqn.ROOT, new String[]{"key0", "key1"});
        this.checkChildren(Fqn.fromString((String)"/key0"), null);
        this.checkChildren(Fqn.fromString((String)"/key1"), null);
        loader.put(Fqn.fromString((String)"/key0/a"), null);
        loader.put(Fqn.fromString((String)"/key0/ab"), null);
        loader.put(Fqn.fromString((String)"/key0/abc"), null);
        this.addDelay();
        this.checkChildren(Fqn.fromString((String)"/key0"), new String[]{"a", "ab", "abc"});
        loader.put(Fqn.fromString((String)"/key0/xxx"), null);
        loader.put(Fqn.fromString((String)"/key0/xx"), null);
        loader.put(Fqn.fromString((String)"/key0/x"), null);
        this.addDelay();
        this.checkChildren(Fqn.fromString((String)"/key0"), new String[]{"a", "ab", "abc", "x", "xx", "xxx"});
        loader.put(Fqn.fromString((String)"/key0/a/1"), null);
        loader.put(Fqn.fromString((String)"/key0/a/2"), null);
        loader.put(Fqn.fromString((String)"/key0/a/2/1"), null);
        this.addDelay();
        this.checkChildren(Fqn.fromString((String)"/key0/a/2"), new String[]{"1"});
        this.checkChildren(Fqn.fromString((String)"/key0/a"), new String[]{"1", "2"});
        this.checkChildren(Fqn.fromString((String)"/key0"), new String[]{"a", "ab", "abc", "x", "xx", "xxx"});
    }

    private void checkChildren(Fqn fqn, String[] names) throws Exception {
        CacheLoader loader = this.loaderTL.get();
        Set set = loader.getChildrenNames(fqn);
        if (names != null) {
            AssertJUnit.assertEquals((int)names.length, (int)set.size());
            for (int i = 0; i < names.length; ++i) {
                AssertJUnit.assertTrue((boolean)set.contains(names[i]));
            }
        } else {
            AssertJUnit.assertNull((Object)set);
        }
    }

    public void testModifications() throws Exception {
        this.doTestModifications();
    }

    public void testModificationsTransactional() throws Exception {
        TransactionManager mgr = this.getTransactionManager();
        mgr.begin();
        this.doTestModifications();
        mgr.commit();
    }

    private void doTestModifications() throws Exception {
        CacheLoader loader = this.loaderTL.get();
        List<Modification> list = this.createUpdates();
        loader.put(list);
        this.addDelay();
        this.checkModifications(list);
        list = new ArrayList<Modification>();
        Modification mod = new Modification();
        mod.setType(Modification.ModificationType.REMOVE_KEY_VALUE);
        mod.setFqn(FQN);
        mod.setKey((Object)"one");
        list.add(mod);
        loader.put(list);
        this.addDelay();
        this.checkModifications(list);
        list = new ArrayList<Modification>();
        mod = new Modification();
        mod.setType(Modification.ModificationType.REMOVE_NODE);
        mod.setFqn(FQN);
        list.add(mod);
        loader.put(list);
        this.addDelay();
        this.checkModifications(list);
        AssertJUnit.assertNull((Object)loader.get(FQN));
        loader.put(FQN, (Object)"one", (Object)"two");
        list = new ArrayList<Modification>();
        mod = new Modification();
        mod.setType(Modification.ModificationType.REMOVE_DATA);
        mod.setFqn(FQN);
        list.add(mod);
        loader.put(list);
        this.addDelay();
        this.checkModifications(list);
    }

    public void testOnePhaseTransaction() throws Exception {
        CacheLoader loader = this.loaderTL.get();
        List<Modification> mods = this.createUpdates();
        loader.prepare(null, mods, true);
        this.checkModifications(mods);
    }

    public void testTwoPhaseTransaction() throws Exception {
        CacheLoader loader = this.loaderTL.get();
        TransactionManager mgr = this.getTransactionManager();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        List<Modification> mods = this.createUpdates();
        loader.prepare((Object)tx, mods, false);
        loader.commit((Object)tx);
        this.addDelay();
        this.checkModifications(mods);
        mgr.commit();
    }

    public void testTransactionRollback() throws Exception {
        int num;
        CacheLoader loader = this.loaderTL.get();
        loader.remove(Fqn.fromString((String)"/"));
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
            loader.loadEntireState((ObjectOutputStream)os);
            num = baos.size();
        }
        catch (UnsupportedOperationException ex) {
            log.info((Object)"caught unsupported operation exception that's okay: ", (Throwable)ex);
            return;
        }
        Object txnKey = new Object();
        List<Modification> mods = this.createUpdates();
        loader.prepare(txnKey, mods, false);
        loader.rollback(txnKey);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
        loader.loadEntireState((ObjectOutputStream)os);
        AssertJUnit.assertEquals((int)num, (int)baos.size());
    }

    public void testIntegratedTransactionRollback() throws Exception {
        CacheLoader loader = this.loaderTL.get();
        loader.remove(Fqn.fromString((String)"/"));
        int num = 0;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
            loader.loadEntireState((ObjectOutputStream)os);
            num = baos.size();
        }
        catch (UnsupportedOperationException ex) {
            System.out.println("caught unsupported operation exception that's okay: " + ex);
            return;
        }
        Object txnKey = new Object();
        List<Modification> mods = this.createUpdates();
        loader.prepare(txnKey, mods, false);
        loader.rollback(txnKey);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
        loader.loadEntireState((ObjectOutputStream)os);
        AssertJUnit.assertEquals((int)num, (int)baos.size());
    }

    private List<Modification> createUpdates() {
        ArrayList<Modification> list = new ArrayList<Modification>();
        Modification mod = new Modification();
        mod.setType(Modification.ModificationType.PUT_KEY_VALUE);
        mod.setFqn(FQN);
        mod.setKey((Object)"one");
        mod.setValue((Object)"two");
        list.add(mod);
        mod = new Modification();
        mod.setType(Modification.ModificationType.PUT_KEY_VALUE);
        mod.setFqn(FQN);
        mod.setKey((Object)"three");
        mod.setValue((Object)"four");
        list.add(mod);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("one", "two");
        map.put("three", "four");
        map.put("five", "six");
        map.put("seven", "eight");
        mod = new Modification();
        mod.setType(Modification.ModificationType.PUT_DATA);
        mod.setFqn(FQN);
        mod.setData(map);
        list.add(mod);
        return list;
    }

    private void checkModifications(List<Modification> list) throws Exception {
        CacheLoader loader = this.loaderTL.get();
        block7: for (Modification mod : list) {
            Fqn fqn = mod.getFqn();
            switch (mod.getType()) {
                case PUT_KEY_VALUE: {
                    AssertJUnit.assertEquals((Object)mod.getValue(), loader.get(fqn).get(mod.getKey()));
                    break;
                }
                case PUT_DATA: {
                    Map map = mod.getData();
                    for (Object key : map.keySet()) {
                        AssertJUnit.assertEquals(map.get(key), loader.get(fqn).get(key));
                    }
                    continue block7;
                }
                case REMOVE_KEY_VALUE: {
                    AssertJUnit.assertNull(loader.get(fqn).get(mod.getKey()));
                    break;
                }
                case REMOVE_DATA: {
                    Map map = loader.get(fqn);
                    AssertJUnit.assertNotNull((Object)map);
                    AssertJUnit.assertEquals((int)0, (int)map.size());
                    break;
                }
                case REMOVE_NODE: {
                    AssertJUnit.assertNull((Object)loader.get(fqn));
                    break;
                }
                default: {
                    AssertJUnit.fail((String)("unknown type: " + mod));
                }
            }
        }
    }

    public void testNullKeysAndValues() throws Exception {
        CacheLoader loader = this.loaderTL.get();
        loader.put(FQN, null, (Object)"x");
        this.addDelay();
        AssertJUnit.assertEquals((Object)"x", loader.get(FQN).get(null));
        HashMap<Object, Object> map = loader.get(FQN);
        AssertJUnit.assertEquals((int)1, (int)map.size());
        AssertJUnit.assertEquals((Object)"x", map.get(null));
        loader.put(FQN, (Object)"y", null);
        this.addDelay();
        AssertJUnit.assertNull(loader.get(FQN).get("y"));
        map = loader.get(FQN);
        AssertJUnit.assertEquals((int)2, (int)map.size());
        AssertJUnit.assertEquals((Object)"x", map.get(null));
        AssertJUnit.assertNull(map.get("y"));
        loader.remove(FQN, null);
        this.addDelay();
        AssertJUnit.assertNull(loader.get(FQN).get(null));
        AssertJUnit.assertEquals((int)1, (int)loader.get(FQN).size());
        loader.remove(FQN, (Object)"y");
        this.addDelay();
        AssertJUnit.assertNotNull((Object)loader.get(FQN));
        AssertJUnit.assertEquals((int)0, (int)loader.get(FQN).size());
        map = new HashMap<Object, Object>();
        map.put(null, null);
        loader.put(FQN, map);
        this.addDelay();
        Map m = loader.get(FQN);
        m.toString();
    }

    public void testDatabaseName() throws Exception {
        CacheLoader loader = this.loaderTL.get();
        loader.put(FQN, (Object)"one", (Object)"two");
        this.addDelay();
        AssertJUnit.assertEquals((Object)"two", loader.get(FQN).get("one"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testLoadAndStore() throws Exception {
        Complex c2;
        Complex c1;
        CacheLoader loader;
        block9: {
            void var5_10;
            block8: {
                byte[] state2;
                CacheSPI<Object, Object> cache = this.cacheTL.get();
                loader = this.loaderTL.get();
                loader.remove(Fqn.fromString((String)"/"));
                c1 = new Complex();
                c2 = new Complex(c1);
                loader.put(FQN, (Object)1, (Object)c1);
                loader.put(FQN, (Object)2, (Object)c2);
                this.addDelay();
                AssertJUnit.assertEquals((Object)c1, loader.get(FQN).get(1));
                AssertJUnit.assertEquals((Object)c2, loader.get(FQN).get(2));
                AssertJUnit.assertEquals((int)2, (int)loader.get(FQN).size());
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
                try {
                    Object var10_7;
                    try {
                        loader.loadEntireState((ObjectOutputStream)os);
                    }
                    catch (UnsupportedOperationException ex) {
                        System.out.println("caught unsupported operation exception (this is expected): " + ex);
                        var10_7 = null;
                        cache.getMarshaller().objectToObjectStream((Object)DefaultStateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)os);
                        os.close();
                        AssertJUnit.assertTrue((baos.size() > 0 ? 1 : 0) != 0);
                        state2 = baos.toByteArray();
                        break block8;
                    }
                    var10_7 = null;
                }
                catch (Throwable throwable) {
                    Object var10_8 = null;
                    cache.getMarshaller().objectToObjectStream((Object)DefaultStateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)os);
                    os.close();
                    AssertJUnit.assertTrue((baos.size() > 0 ? 1 : 0) != 0);
                    byte[] state2 = baos.toByteArray();
                    throw throwable;
                }
                cache.getMarshaller().objectToObjectStream((Object)DefaultStateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)os);
                os.close();
                AssertJUnit.assertTrue((baos.size() > 0 ? 1 : 0) != 0);
                state2 = baos.toByteArray();
            }
            ByteArrayInputStream bais = new ByteArrayInputStream((byte[])var5_10);
            MarshalledValueInputStream is = new MarshalledValueInputStream((InputStream)bais);
            try {
                try {
                    loader.storeEntireState((ObjectInputStream)is);
                }
                catch (UnsupportedOperationException ex) {
                    System.out.println("caught unsupported operation exception (this is expected): " + ex);
                    Object var12_17 = null;
                    is.close();
                    break block9;
                }
                Object var12_16 = null;
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                is.close();
                throw throwable;
            }
            is.close();
        }
        this.addDelay();
        AssertJUnit.assertEquals((Object)c1, loader.get(FQN).get(1));
        AssertJUnit.assertEquals((Object)c2, loader.get(FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)loader.get(FQN).size());
    }

    public void testRemoveInTransactionCommit() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        Fqn fqn = Fqn.fromString((String)"/a/b");
        loader.remove(fqn);
        String key = "key";
        String value = "value";
        cache.put(fqn, (Object)key, (Object)value);
        loader = cache.getCacheLoaderManager().getCacheLoader();
        AssertJUnit.assertEquals((Object)value, (Object)cache.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)value, loader.get(fqn).get(key));
        cache.getTransactionManager().begin();
        cache.removeNode(fqn);
        cache.getNode(fqn);
        cache.getTransactionManager().commit();
        log.debug((Object)"expect the cache and the loader to be null here.");
        AssertJUnit.assertEquals(null, (Object)cache.get(fqn, (Object)key));
        AssertJUnit.assertEquals(null, (Object)loader.get(fqn));
    }

    public void testRemoveInTransactionRollback() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        Fqn fqn = Fqn.fromString((String)"/a/b");
        loader.remove(fqn);
        String key = "key";
        String value = "value";
        cache.put(fqn, (Object)key, (Object)value);
        loader = cache.getCacheLoaderManager().getCacheLoader();
        AssertJUnit.assertEquals((Object)value, (Object)cache.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)value, loader.get(fqn).get(key));
        cache.getTransactionManager().begin();
        cache.removeNode(fqn);
        cache.getNode(fqn);
        cache.getTransactionManager().rollback();
        AssertJUnit.assertEquals((Object)value, (Object)cache.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)value, loader.get(fqn).get(key));
    }

    public void testRemoveAndGetInTransaction() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        Fqn fqn = Fqn.fromString((String)"/a/b");
        String key = "key";
        String value = "value";
        cache.put(fqn, (Object)key, (Object)value);
        CacheLoader loader = cache.getCacheLoaderManager().getCacheLoader();
        AssertJUnit.assertEquals((Object)value, (Object)cache.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)value, loader.get(fqn).get(key));
        cache.getTransactionManager().begin();
        cache.removeNode(fqn);
        AssertJUnit.assertNull((String)"Expecting a null since I have already called a remove() - see JBCACHE-352", (Object)cache.get(fqn, (Object)key));
        cache.getTransactionManager().rollback();
        AssertJUnit.assertEquals((Object)value, (Object)cache.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)value, loader.get(fqn).get(key));
    }

    public void testPutAllAfterEvict() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        Fqn fqn = Fqn.fromString((String)"/a/b");
        HashMap<String, String> original = new HashMap<String, String>();
        HashMap<String, String> toAdd = new HashMap<String, String>();
        HashMap<String, String> all = new HashMap<String, String>();
        original.put("1", "One");
        original.put("2", "Two");
        toAdd.put("3", "Three");
        toAdd.put("4", "Four");
        all.putAll(original);
        all.putAll(toAdd);
        cache.put(fqn, original);
        assert (((Object)loader.get(fqn)).equals(original));
        cache.evict(fqn);
        assert (((Object)loader.get(fqn)).equals(original));
        cache.put(fqn, toAdd);
        assert (((Object)loader.get(fqn)).equals(all));
        cache.evict(fqn);
        assert (((Object)loader.get(fqn)).equals(all));
    }

    public void testPutAllAfterEvictWithChild() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        Fqn fqn = Fqn.fromString((String)"/a/b");
        HashMap<String, String> original = new HashMap<String, String>();
        HashMap<String, String> toAdd = new HashMap<String, String>();
        HashMap<String, String> all = new HashMap<String, String>();
        original.put("1", "One");
        original.put("2", "Two");
        toAdd.put("3", "Three");
        toAdd.put("4", "Four");
        all.putAll(original);
        all.putAll(toAdd);
        cache.put(fqn, original);
        cache.put(Fqn.fromRelativeElements((Fqn)fqn, (Object[])new String[]{"c"}), (Object)"x", (Object)"y");
        assert (((Object)loader.get(fqn)).equals(original));
        cache.evict(fqn);
        assert (((Object)loader.get(fqn)).equals(original));
        cache.put(fqn, toAdd);
        assert (((Object)loader.get(fqn)).equals(all));
        cache.evict(fqn);
        assert (((Object)loader.get(fqn)).equals(all));
    }

    public void testPartialLoadAndStore() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        loader.remove(Fqn.fromString((String)"/"));
        Complex c1 = new Complex();
        Complex c2 = new Complex(c1);
        Complex c3 = new Complex();
        Complex c4 = new Complex(c3);
        loader.put(FQN, (Object)1, (Object)c1);
        loader.put(FQN, (Object)2, (Object)c2);
        loader.put(SUBTREE_FQN, (Object)1, (Object)c3);
        loader.put(SUBTREE_FQN, (Object)2, (Object)c4);
        this.addDelay();
        AssertJUnit.assertEquals((Object)c1, loader.get(FQN).get(1));
        AssertJUnit.assertEquals((Object)c2, loader.get(FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)loader.get(FQN).size());
        AssertJUnit.assertEquals((Object)c3, loader.get(SUBTREE_FQN).get(1));
        AssertJUnit.assertEquals((Object)c4, loader.get(SUBTREE_FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)loader.get(SUBTREE_FQN).size());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
        loader.loadState(SUBTREE_FQN, (ObjectOutputStream)os);
        cache.getMarshaller().objectToObjectStream((Object)DefaultStateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)os);
        os.close();
        AssertJUnit.assertTrue((baos.size() > 0 ? 1 : 0) != 0);
        loader.remove(SUBTREE_FQN);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        MarshalledValueInputStream is = new MarshalledValueInputStream((InputStream)bais);
        loader.storeState(SUBTREE_FQN, (ObjectInputStream)is);
        is.close();
        this.addDelay();
        AssertJUnit.assertEquals((Object)c1, loader.get(FQN).get(1));
        AssertJUnit.assertEquals((Object)c2, loader.get(FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)loader.get(FQN).size());
        AssertJUnit.assertEquals((Object)c3, loader.get(SUBTREE_FQN).get(1));
        AssertJUnit.assertEquals((Object)c4, loader.get(SUBTREE_FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)loader.get(SUBTREE_FQN).size());
    }

    public void testBuddyBackupStore() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        loader.remove(Fqn.ROOT);
        Complex c1 = new Complex();
        Complex c2 = new Complex(c1);
        Complex c3 = new Complex();
        Complex c4 = new Complex(c3);
        loader.put(FQN, (Object)1, (Object)c1);
        loader.put(FQN, (Object)2, (Object)c2);
        loader.put(SUBTREE_FQN, (Object)1, (Object)c3);
        loader.put(SUBTREE_FQN, (Object)2, (Object)c4);
        this.addDelay();
        AssertJUnit.assertEquals((Object)c1, loader.get(FQN).get(1));
        AssertJUnit.assertEquals((Object)c2, loader.get(FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)loader.get(FQN).size());
        AssertJUnit.assertEquals((Object)c3, loader.get(SUBTREE_FQN).get(1));
        AssertJUnit.assertEquals((Object)c4, loader.get(SUBTREE_FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)loader.get(SUBTREE_FQN).size());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        MarshalledValueOutputStream os = new MarshalledValueOutputStream((OutputStream)baos);
        loader.loadState(FQN, (ObjectOutputStream)os);
        cache.getMarshaller().objectToObjectStream((Object)DefaultStateTransferManager.STREAMING_DELIMITER_NODE, (ObjectOutputStream)os);
        os.close();
        AssertJUnit.assertTrue((baos.size() > 0 ? 1 : 0) != 0);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        MarshalledValueInputStream is = new MarshalledValueInputStream((InputStream)bais);
        loader.storeState(BUDDY_BASE, (ObjectInputStream)is);
        is.close();
        this.addDelay();
        AssertJUnit.assertEquals((Object)c1, loader.get(BUDDY_PLUS_FQN).get(1));
        AssertJUnit.assertEquals((Object)c2, loader.get(BUDDY_PLUS_FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)loader.get(BUDDY_PLUS_FQN).size());
        AssertJUnit.assertEquals((Object)c3, loader.get(BUDDY_PLUS_SUBTREE_FQN).get(1));
        AssertJUnit.assertEquals((Object)c4, loader.get(BUDDY_PLUS_SUBTREE_FQN).get(2));
        AssertJUnit.assertEquals((int)2, (int)loader.get(BUDDY_PLUS_SUBTREE_FQN).size());
    }

    public void testIgnoreModifications() throws Exception {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        CacheLoader loader = this.loaderTL.get();
        Fqn fqn = Fqn.fromString((String)"/a");
        cache.put(fqn, (Object)"k", (Object)"v");
        assert ("v".equals(cache.get(fqn, (Object)"k")));
        assert ("v".equals(loader.get(fqn).get("k")));
        assert ("v".equals(loader.get(fqn).get("k")));
        cache.stop();
        cache.destroy();
        assert (cache.getCacheLoaderManager() == null) : "Should nullify cache loader manager in the cache";
        ((CacheLoaderConfig.IndividualCacheLoaderConfig)cache.getConfiguration().getCacheLoaderConfig().getIndividualCacheLoaderConfigs().get(0)).setIgnoreModifications(true);
        cache.start();
        loader = cache.getCacheLoaderManager().getCacheLoader();
        this.postConfigure();
        if (!(loader instanceof ChainingCacheLoader)) assert (loader instanceof ReadOnlyDelegatingCacheLoader);
        assert ("v".equals(loader.get(fqn).get("k")));
        assert ("v".equals(cache.get(fqn, (Object)"k")));
        cache.put(fqn, (Object)"k", (Object)"v2");
        assert ("v2".equals(cache.get(fqn, (Object)"k")));
        assert ("v".equals(loader.get(fqn).get("k")));
    }

    public void testCacheLoaderThreadSafety() throws Exception {
        this.threadSafetyTest(true);
    }

    public void testCacheLoaderThreadSafetyMultipleFqns() throws Exception {
        this.threadSafetyTest(false);
    }

    protected void threadSafetyTest(final boolean singleFqn) throws Exception {
        final CacheLoader loader = this.loaderTL.get();
        final CountDownLatch latch = new CountDownLatch(1);
        final Fqn fqn = Fqn.fromString((String)"/a/b/c");
        final ArrayList<Fqn> fqns = new ArrayList<Fqn>(30);
        final Random r = new Random();
        if (!singleFqn) {
            for (int i = 0; i < 30; ++i) {
                Fqn f = Fqn.fromString((String)("/a/b/c/" + i));
                fqns.add(f);
                loader.put(f, (Object)"k", (Object)"v");
            }
        } else {
            loader.put(fqn, (Object)"k", (Object)"v");
        }
        int loops = 1000;
        final CopyOnWriteArraySet exceptions = new CopyOnWriteArraySet();
        Thread remover1 = new Thread("Remover-1"){

            public void run() {
                try {
                    latch.await();
                    for (int i = 0; i < 1000; ++i) {
                        loader.remove(singleFqn ? fqn : (Fqn)fqns.get(r.nextInt(fqns.size())));
                    }
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        remover1.start();
        Thread remover2 = new Thread("Remover-2"){

            public void run() {
                try {
                    latch.await();
                    for (int i = 0; i < 1000; ++i) {
                        loader.remove(singleFqn ? fqn : (Fqn)fqns.get(r.nextInt(fqns.size())), (Object)"k");
                    }
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        remover2.start();
        Thread reader1 = new Thread("Reader-1"){

            public void run() {
                try {
                    latch.await();
                    for (int i = 0; i < 1000; ++i) {
                        loader.get(singleFqn ? fqn : (Fqn)fqns.get(r.nextInt(fqns.size())));
                    }
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        reader1.start();
        Thread reader2 = new Thread("Reader-2"){

            public void run() {
                try {
                    latch.await();
                    for (int i = 0; i < 1000; ++i) {
                        loader.getChildrenNames(singleFqn ? fqn : (Fqn)fqns.get(r.nextInt(fqns.size())));
                    }
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        reader2.start();
        Thread writer1 = new Thread("Writer-1"){

            public void run() {
                try {
                    latch.await();
                    for (int i = 0; i < 1000; ++i) {
                        loader.put(singleFqn ? fqn : (Fqn)fqns.get(r.nextInt(fqns.size())), (Object)"k", (Object)"v");
                    }
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        writer1.start();
        Thread writer2 = new Thread("Writer-2"){

            public void run() {
                try {
                    latch.await();
                    for (int i = 0; i < 1000; ++i) {
                        loader.put(singleFqn ? fqn : (Fqn)fqns.get(r.nextInt(fqns.size())), new HashMap());
                    }
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        };
        writer2.start();
        latch.countDown();
        reader1.join();
        reader2.join();
        remover1.join();
        remover2.join();
        writer1.join();
        writer2.join();
        Iterator i$ = exceptions.iterator();
        if (i$.hasNext()) {
            Exception e = (Exception)i$.next();
            throw e;
        }
    }

    protected TransactionManager getTransactionManager() {
        CacheSPI<Object, Object> cache = this.cacheTL.get();
        return cache.getConfiguration().getRuntimeConfig().getTransactionManager();
    }

    public static class Complex
    implements Serializable {
        private static final long serialVersionUID = -6810871775584708565L;
        Complex nested;

        Complex() {
            this(null);
        }

        Complex(Complex nested) {
            this.nested = nested;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Complex)) {
                return false;
            }
            Complex x = (Complex)o;
            return this.nested != null ? this.nested.equals(x.nested) : x.nested == null;
        }

        public int hashCode() {
            if (this.nested == null) {
                return super.hashCode();
            }
            return 13 + this.nested.hashCode();
        }
    }
}

