/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Properties;
import org.jboss.cache.loader.AdjListJDBCCacheLoaderConfig;
import org.jboss.cache.loader.JDBCCacheLoaderConfig;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true, testName="loader.JDBCCacheLoaderConfigTest")
public class JDBCCacheLoaderConfigTest {
    private AdjListJDBCCacheLoaderConfig cacheLoaderConfig;

    @BeforeMethod(alwaysRun=true)
    protected void setUp() throws Exception {
        this.cacheLoaderConfig = new AdjListJDBCCacheLoaderConfig();
    }

    public void testSetGetConnectionFactory() {
        this.cacheLoaderConfig.setConnectionFactoryClass("com.acme.Paradise");
        AssertJUnit.assertEquals((String)"com.acme.Paradise", (String)this.cacheLoaderConfig.getConnectionFactoryClass());
    }

    public void testEqualsHashCode() {
        this.cacheLoaderConfig.setConnectionFactoryClass("com.acme.Paradise");
        AdjListJDBCCacheLoaderConfig other = new AdjListJDBCCacheLoaderConfig();
        other.setConnectionFactoryClass("com.acme.Paradise");
        AssertJUnit.assertTrue((boolean)this.cacheLoaderConfig.equals((Object)other));
        AssertJUnit.assertEquals((int)this.cacheLoaderConfig.hashCode(), (int)other.hashCode());
        other.setConnectionFactoryClass("com.ibm.flaming.Gala");
        AssertJUnit.assertFalse((boolean)this.cacheLoaderConfig.equals((Object)other));
    }

    public void testSetGetBatchInfo() {
        Properties props = new Properties();
        props.put("ache.jdbc.table.name", "jbosscache" + TestingUtil.getThreadId());
        props.put("cache.jdbc.table.create", "true");
        props.put("cache.jdbc.table.drop", "true");
        props.put("cache.jdbc.table.primarykey", "jbosscache_pk" + TestingUtil.getThreadId());
        props.put("cache.jdbc.fqn.column", "fqn");
        props.put("cache.jdbc.fqn.type", "varchar(255)");
        props.put("cache.jdbc.node.column", "node");
        props.put("cache.jdbc.node.type", "blob");
        props.put("cache.jdbc.parent.column", "parent");
        props.put("cache.jdbc.sql-concat", "1 || 2");
        props.put("cache.jdbc.driver", "org.apache.derby.jdbc.EmbeddedDriver");
        props.put("cache.jdbc.url", "jdbc:derby:jbossdb;create=true");
        props.put("cache.jdbc.user", "user1");
        props.put("cache.jdbc.password", "user1");
        props.put("cache.jdbc.batch.enable", "false");
        props.put("cache.jdbc.batch.size", "1001");
        JDBCCacheLoaderConfig config = new JDBCCacheLoaderConfig();
        config.setProperties(props);
        assert (!config.isBatchEnabled());
        assert (config.getBatchSize() == 1001L);
    }
}

