/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Properties;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.CacheLoaderTestsBase;
import org.jboss.cache.loader.JDBCCacheLoader;
import org.jboss.cache.util.TestDbPropertiesFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="loader.JDBCCacheLoaderTest")
public class JDBCCacheLoaderTest
extends CacheLoaderTestsBase {
    protected void configureCache() throws Exception {
        String props = this.props2String(TestDbPropertiesFactory.getTestDbProperties());
        CacheSPI cache = (CacheSPI)this.cacheTL.get();
        cache.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", JDBCCacheLoader.class.getName(), props, false, true, false));
    }

    private String props2String(Properties prop) {
        StringBuilder p = new StringBuilder();
        this.append("cache.jdbc.driver", prop, p);
        this.append("cache.jdbc.url", prop, p);
        this.append("cache.jdbc.user", prop, p);
        this.append("cache.jdbc.password", prop, p);
        this.append("cache.jdbc.node.type", prop, p);
        this.append("cache.jdbc.sql-concat", prop, p);
        this.append("cache.jdbc.table.name", prop, p);
        this.append("cache.jdbc.table.primarykey", prop, p);
        return p.toString();
    }

    private void append(String propertyName, Properties prop, StringBuilder builder) {
        if (prop.containsKey(propertyName)) {
            builder.append(propertyName).append("=").append(prop.getProperty(propertyName)).append("\n");
        }
    }

    public void testLargeObject() {
        CacheLoader loader = (CacheLoader)this.loaderTL.get();
        try {
            String key = "LargeObj";
            StringBuilder text = new StringBuilder("LargeObject");
            while (text.toString().getBytes().length < 102400) {
                text.append((CharSequence)text);
            }
            String initialValue = text.toString();
            loader.remove(Fqn.fromString((String)"/"));
            Object retVal = loader.put(FQN, (Object)key, (Object)initialValue);
            AssertJUnit.assertNull((Object)retVal);
            this.addDelay();
            AssertJUnit.assertEquals((String)initialValue, (String)((String)loader.get(FQN).get(key)));
            String updatedValue = initialValue.concat("UpdatedValue");
            retVal = loader.put(FQN, (Object)key, (Object)updatedValue);
            AssertJUnit.assertEquals((String)initialValue, (String)((String)retVal));
            AssertJUnit.assertEquals((String)updatedValue, (String)((String)loader.get(FQN).get(key)));
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    public void testRootIsCreated() throws Exception {
        CacheLoader loader = (CacheLoader)this.loaderTL.get();
        loader.put(Fqn.fromString((String)"/a/b/c"), (Object)"a", (Object)"b");
        AssertJUnit.assertTrue((boolean)loader.exists(Fqn.ROOT));
    }
}

