/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader.deadlock;

import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, enabled=false, testName="loader.deadlock.ConcurrentCreationDeadlockTest")
public class ConcurrentCreationDeadlockTest
extends AbstractCacheLoaderTestBase {
    private static final int NUM_WORKERS = 10;
    private static final int NUM_RUNS = 100;
    private static final int NUM_FQNS_PER_RUN = 10;
    private static final Properties PROPERTIES;
    private static final String CONTEXT_FACTORY = "org.jboss.cache.transaction.DummyContextFactory";
    private static volatile Exception mcl_exception;
    private CacheSPI<Object, Object> cache = null;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        mcl_exception = null;
        System.setProperty("java.naming.factory.initial", CONTEXT_FACTORY);
        Configuration c = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC);
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(c, false);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killTransaction((TransactionManager)DummyTransactionManager.getInstance());
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    private void startCache(Configuration.CacheMode cacheMode, String cacheLoaderClass) throws Exception {
        this.cache.getConfiguration().setCacheMode(cacheMode);
        if (cacheLoaderClass != null) {
            this.cache.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", cacheLoaderClass, "", false, false, false));
        }
        this.cache.getConfiguration().setLockAcquisitionTimeout(600000L);
        this.cache.start();
    }

    public void testLocalCacheLoader2Modifications() throws Exception {
        this.startCache(Configuration.CacheMode.LOCAL, DummyInMemoryCacheLoader.class.getName());
        this.performTest(2);
    }

    public void testReplSyncCacheLoader2Modifications() throws Exception {
        this.startCache(Configuration.CacheMode.REPL_SYNC, DummyInMemoryCacheLoader.class.getName());
        this.performTest(2);
    }

    private void performTest(int modificationsPerTx) throws Exception {
        for (int i = 0; i < 100; ++i) {
            if (mcl_exception != null) {
                throw mcl_exception;
            }
            Worker[] t = new Worker[10];
            CountDownLatch latch = new CountDownLatch(1);
            for (int j = 0; j < t.length; ++j) {
                t[j] = new Worker(latch, 10 * i, 10, modificationsPerTx);
                t[j].start();
            }
            latch.countDown();
            for (Worker worker : t) {
                worker.join();
            }
        }
    }

    private UserTransaction getTransaction() throws Exception {
        return (UserTransaction)new InitialContext(PROPERTIES).lookup("UserTransaction");
    }

    private void log(String msg) {
        System.out.println(System.currentTimeMillis() + " " + Thread.currentThread() + " " + msg);
    }

    static {
        mcl_exception = null;
        PROPERTIES = new Properties();
        PROPERTIES.put("java.naming.factory.initial", CONTEXT_FACTORY);
    }

    private class Worker
    extends Thread {
        private final CountDownLatch m_latch;
        private final int m_start;
        private final int m_count;
        private final int m_modificationsPerTx;
        private int m_state;

        public Worker(CountDownLatch latch, int start, int count, int modificationsPerTx) {
            this.m_latch = latch;
            this.m_start = start;
            this.m_count = count;
            this.m_state = -1;
            this.m_modificationsPerTx = modificationsPerTx;
        }

        public void run() {
            try {
                this.m_latch.await();
                for (int i = this.m_start; i < this.m_start + this.m_count; ++i) {
                    this.m_state = -1;
                    ConcurrentCreationDeadlockTest.this.log("enter " + i);
                    if (this.checkAndSetState()) {
                        return;
                    }
                    long time = System.currentTimeMillis();
                    UserTransaction tx = ConcurrentCreationDeadlockTest.this.getTransaction();
                    tx.begin();
                    if (this.checkAndSetState()) {
                        try {
                            tx.rollback();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        return;
                    }
                    Fqn fqn = Fqn.fromString((String)("/NODE/" + i));
                    for (int m = 0; m < this.m_modificationsPerTx; ++m) {
                        ConcurrentCreationDeadlockTest.this.cache.put(fqn, (Object)m, (Object)i);
                        if (!this.checkAndSetState()) continue;
                        try {
                            tx.rollback();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        return;
                    }
                    tx.commit();
                    if (this.checkAndSetState()) {
                        return;
                    }
                    time = System.currentTimeMillis() - time;
                    ConcurrentCreationDeadlockTest.this.log("leave " + i + " took " + time + " msec");
                }
            }
            catch (Exception e) {
                ConcurrentCreationDeadlockTest.this.log("caught exception in state " + this.m_state + ": " + e);
                e.printStackTrace();
                mcl_exception = e;
            }
        }

        private boolean checkAndSetState() {
            if (mcl_exception != null) {
                ConcurrentCreationDeadlockTest.this.log("detected failure in state " + this.m_state);
                return true;
            }
            ++this.m_state;
            return false;
        }
    }
}

