/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import org.jboss.cache.Cache;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.LockParentRootFlagTest")
public class LockParentRootFlagTest {
    public void testMVCCSet() {
        this.doTest(Configuration.NodeLockingScheme.MVCC, true);
    }

    public void testMVCCUnset() {
        this.doTest(Configuration.NodeLockingScheme.MVCC, false);
    }

    public void testPessimisticSet() {
        this.doTest(Configuration.NodeLockingScheme.PESSIMISTIC, true);
    }

    public void testPessimisticUnset() {
        this.doTest(Configuration.NodeLockingScheme.PESSIMISTIC, false);
    }

    public void testOptimisticSet() {
        this.doTest(Configuration.NodeLockingScheme.OPTIMISTIC, true);
    }

    public void testOptimisticUnset() {
        this.doTest(Configuration.NodeLockingScheme.OPTIMISTIC, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(Configuration.NodeLockingScheme nls, boolean set) {
        Cache c = null;
        try {
            c = new UnitTestCacheFactory().createCache(false);
            c.getConfiguration().setNodeLockingScheme(nls);
            c.getConfiguration().setLockParentForChildInsertRemove(set);
            if (nls.isVersionedScheme()) {
                c.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
            }
            c.start();
            assert (c.getRoot().isLockForChildInsertRemove() == set);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            TestingUtil.killCaches(c);
            throw throwable;
        }
        TestingUtil.killCaches(c);
    }
}

