/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.jboss.cache.lock.LockStrategy;
import org.jboss.cache.lock.LockStrategyReadCommitted;
import org.jboss.cache.lock.LockStrategyReadUncommitted;
import org.jboss.cache.lock.LockStrategyRepeatableRead;
import org.jboss.cache.lock.LockStrategySerializable;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.LockTest")
public class LockTest {
    int value = 10;
    Throwable t1_ex;
    Throwable t2_ex;
    long start = 0L;
    final long TIMEOUT = 5000L;
    final long SLEEP = 500L;
    volatile boolean committed;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.value = 10;
        this.t2_ex = null;
        this.t1_ex = null;
        this.committed = false;
    }

    public void testReadUncommitted() throws Throwable {
        LockStrategyReadUncommitted s = new LockStrategyReadUncommitted();
        final MyFIFOSemaphore sem = new MyFIFOSemaphore(1);
        final CyclicBarrier barrier = new CyclicBarrier(2);
        Thread t1 = new Thread("t1", (LockStrategy)s){
            Lock lock;
            final /* synthetic */ LockStrategy val$s;
            {
                this.val$s = lockStrategy;
                super(x0);
                this.lock = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        sem.acquire();
                        barrier.await();
                        this.lock = this.val$s.readLock();
                        this.lock.tryLock(5000L, TimeUnit.MILLISECONDS);
                        LockTest.this.log("1st read: value is " + LockTest.this.value);
                        AssertJUnit.assertEquals((int)10, (int)LockTest.this.value);
                        sem.release();
                        TestingUtil.sleepThread(100L);
                        sem.acquire();
                        LockTest.this.log("2nd read: value is " + LockTest.this.value + "; we should see t2's uncommitted change (20)");
                        AssertJUnit.assertEquals((int)20, (int)LockTest.this.value);
                        sem.release();
                        TestingUtil.sleepThread(100L);
                        sem.acquire();
                        LockTest.this.log("3rd read: value is still " + LockTest.this.value + "; we should see t2's committed change");
                        AssertJUnit.assertEquals((int)20, (int)LockTest.this.value);
                    }
                    catch (Throwable ex) {
                        LockTest.this.t1_ex = ex;
                        Object var3_2 = null;
                        if (this.lock != null) {
                            this.lock.unlock();
                        }
                        sem.release();
                    }
                    Object var3_1 = null;
                    if (this.lock != null) {
                        this.lock.unlock();
                    }
                    sem.release();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (this.lock != null) {
                        this.lock.unlock();
                    }
                    sem.release();
                    throw throwable;
                }
            }
        };
        Thread t2 = new Thread("t2", (LockStrategy)s){
            Lock lock;
            final /* synthetic */ LockStrategy val$s;
            {
                this.val$s = lockStrategy;
                super(x0);
                this.lock = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        TestingUtil.sleepThread(100L);
                        barrier.await();
                        sem.acquire();
                        this.lock = this.val$s.writeLock();
                        this.lock.tryLock(5000L, TimeUnit.MILLISECONDS);
                        LockTest.this.log("changing value from " + LockTest.this.value + " to 20");
                        LockTest.this.value = 20;
                        sem.release();
                        TestingUtil.sleepThread(100L);
                        sem.acquire();
                        LockTest.this.log("committing the TX");
                        this.lock.unlock();
                    }
                    catch (Throwable ex) {
                        LockTest.this.t2_ex = ex;
                        Object var3_2 = null;
                        if (this.lock != null) {
                            this.lock.unlock();
                        }
                        sem.release();
                    }
                    Object var3_1 = null;
                    if (this.lock != null) {
                        this.lock.unlock();
                    }
                    sem.release();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (this.lock != null) {
                        this.lock.unlock();
                    }
                    sem.release();
                    throw throwable;
                }
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        if (this.t1_ex != null) {
            throw this.t1_ex;
        }
        if (this.t2_ex != null) {
            throw this.t2_ex;
        }
    }

    public void testWriteThanRead() throws Throwable {
        LockStrategyReadCommitted s = new LockStrategyReadCommitted();
        Thread t1 = new Thread("t1", (LockStrategy)s){
            Lock lock;
            final /* synthetic */ LockStrategy val$s;
            {
                this.val$s = lockStrategy;
                super(x0);
                this.lock = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        TestingUtil.sleepThread(100L);
                        this.lock = this.val$s.readLock();
                        this.lock.tryLock(5000L, TimeUnit.MILLISECONDS);
                        LockTest.this.log("1st read: value is " + LockTest.this.value);
                        AssertJUnit.assertEquals((int)20, (int)LockTest.this.value);
                        TestingUtil.sleepThread(500L);
                        LockTest.this.log("2nd read: value is " + LockTest.this.value + "; we should see t2's uncommitted change (20)");
                        AssertJUnit.assertEquals((int)20, (int)LockTest.this.value);
                        TestingUtil.sleepThread(500L);
                    }
                    catch (Throwable ex) {
                        LockTest.this.t1_ex = ex;
                        Object var3_2 = null;
                        this.lock.unlock();
                    }
                    Object var3_1 = null;
                    this.lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.lock.unlock();
                    throw throwable;
                }
            }
        };
        Thread t2 = new Thread("t2", (LockStrategy)s){
            Lock lock;
            final /* synthetic */ LockStrategy val$s;
            {
                this.val$s = lockStrategy;
                super(x0);
                this.lock = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        this.lock = this.val$s.writeLock();
                        this.lock.tryLock(5000L, TimeUnit.MILLISECONDS);
                        LockTest.this.log("changing value from " + LockTest.this.value + " to 20");
                        LockTest.this.value = 20;
                        TestingUtil.sleepThread(500L);
                        LockTest.this.log("committing the TX");
                        this.lock.unlock();
                    }
                    catch (Throwable ex) {
                        LockTest.this.t2_ex = ex;
                        Object var3_2 = null;
                        this.lock.unlock();
                    }
                    Object var3_1 = null;
                    this.lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.lock.unlock();
                    throw throwable;
                }
            }
        };
        t2.start();
        t1.start();
        t2.join();
        t1.join();
        if (this.t1_ex != null) {
            throw this.t1_ex;
        }
        if (this.t2_ex != null) {
            throw this.t2_ex;
        }
    }

    public void testRepeatableRead() throws Throwable {
        LockStrategyRepeatableRead s = new LockStrategyRepeatableRead();
        Thread t1 = new Thread("t1", (LockStrategy)s){
            Lock lock;
            final /* synthetic */ LockStrategy val$s;
            {
                this.val$s = lockStrategy;
                super(x0);
                this.lock = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        this.lock = this.val$s.readLock();
                        this.lock.tryLock(5000L, TimeUnit.MILLISECONDS);
                        LockTest.this.log("1st read: value is " + LockTest.this.value);
                        AssertJUnit.assertEquals((int)10, (int)LockTest.this.value);
                        TestingUtil.sleepThread(500L);
                        LockTest.this.log("2nd read: value is " + LockTest.this.value + "; we should *not* see t2's uncommitted change (20)");
                        AssertJUnit.assertEquals((int)10, (int)LockTest.this.value);
                        TestingUtil.sleepThread(500L);
                        LockTest.this.log("3rd read: value is still " + LockTest.this.value + "; we should not see t2's committed change");
                        AssertJUnit.assertEquals((int)10, (int)LockTest.this.value);
                        this.lock.unlock();
                        TestingUtil.sleepThread(500L);
                        this.lock.tryLock(5000L, TimeUnit.MILLISECONDS);
                        LockTest.this.log("4th read: value is now " + LockTest.this.value + "; we should see t2's committed change in our new TX");
                        AssertJUnit.assertEquals((int)20, (int)LockTest.this.value);
                    }
                    catch (Throwable ex) {
                        LockTest.this.t1_ex = ex;
                        Object var3_2 = null;
                        this.lock.unlock();
                    }
                    Object var3_1 = null;
                    this.lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.lock.unlock();
                    throw throwable;
                }
            }
        };
        Thread t2 = new Thread("t2", (LockStrategy)s){
            Lock lock;
            final /* synthetic */ LockStrategy val$s;
            {
                this.val$s = lockStrategy;
                super(x0);
                this.lock = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        TestingUtil.sleepThread(100L);
                        this.lock = this.val$s.writeLock();
                        this.lock.tryLock(5000L, TimeUnit.MILLISECONDS);
                        LockTest.this.log("changing value from " + LockTest.this.value + " to 20");
                        LockTest.this.value = 20;
                        TestingUtil.sleepThread(500L);
                        LockTest.this.log("committing the TX");
                        this.lock.unlock();
                    }
                    catch (Throwable ex) {
                        LockTest.this.t2_ex = ex;
                        Object var3_2 = null;
                        this.lock.unlock();
                    }
                    Object var3_1 = null;
                    this.lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.lock.unlock();
                    throw throwable;
                }
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        if (this.t1_ex != null) {
            throw this.t1_ex;
        }
        if (this.t2_ex != null) {
            throw this.t2_ex;
        }
    }

    public void testSerializable() throws Throwable {
        LockStrategySerializable s = new LockStrategySerializable();
        Thread t1 = new Thread("t1", (LockStrategy)s){
            Lock lock;
            final /* synthetic */ LockStrategy val$s;
            {
                this.val$s = lockStrategy;
                super(x0);
                this.lock = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        this.lock = this.val$s.readLock();
                        this.lock.tryLock(5000L, TimeUnit.MILLISECONDS);
                        LockTest.this.log("1st read: value is " + LockTest.this.value);
                        AssertJUnit.assertEquals((int)10, (int)LockTest.this.value);
                        this.lock.unlock();
                        TestingUtil.sleepThread(500L);
                        this.lock.tryLock(5000L, TimeUnit.MILLISECONDS);
                        LockTest.this.log("2nd read: value is " + LockTest.this.value + "; we should see t2's committed change (20)");
                        AssertJUnit.assertEquals((int)20, (int)LockTest.this.value);
                    }
                    catch (Throwable ex) {
                        LockTest.this.t1_ex = ex;
                        Object var3_2 = null;
                        this.lock.unlock();
                    }
                    Object var3_1 = null;
                    this.lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.lock.unlock();
                    throw throwable;
                }
            }
        };
        Thread t2 = new Thread("t2", (LockStrategy)s){
            Lock lock;
            final /* synthetic */ LockStrategy val$s;
            {
                this.val$s = lockStrategy;
                super(x0);
                this.lock = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        TestingUtil.sleepThread(100L);
                        this.lock = this.val$s.writeLock();
                        this.lock.tryLock(5000L, TimeUnit.MILLISECONDS);
                        LockTest.this.log("changing value from " + LockTest.this.value + " to 20");
                        LockTest.this.value = 20;
                        LockTest.this.log("committing the TX");
                        this.lock.unlock();
                    }
                    catch (Throwable ex) {
                        LockTest.this.t2_ex = ex;
                        Object var3_2 = null;
                        this.lock.unlock();
                    }
                    Object var3_1 = null;
                    this.lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.lock.unlock();
                    throw throwable;
                }
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        if (this.t1_ex != null) {
            throw this.t1_ex;
        }
        if (this.t2_ex != null) {
            throw this.t2_ex;
        }
    }

    void log(String s) {
        if (this.start == 0L) {
            this.start = System.currentTimeMillis();
        }
        long now = System.currentTimeMillis();
        System.out.println("[" + Thread.currentThread().getName() + "] [" + (now - this.start) + "] " + s);
    }

    static class MyFIFOSemaphore
    extends Semaphore {
        private static final long serialVersionUID = 3247961778517846603L;

        public MyFIFOSemaphore(int permits) {
            super(permits);
        }

        public void acquire() throws InterruptedException {
            super.acquire();
        }

        public void release() {
            super.release();
        }
    }
}

