/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.ArrayList;
import javax.transaction.TransactionManager;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.context.MVCCContextFactory;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.lock.AbstractLockManagerRecordingTest;
import org.jboss.cache.lock.MVCCLockManager;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.concurrent.locks.LockContainer;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit", "mvcc"}, testName="lock.MVCCLockManagerRecordingTest")
public class MVCCLockManagerRecordingTest
extends AbstractLockManagerRecordingTest {
    @BeforeMethod
    public void setUp() {
        AbstractLockManagerRecordingTest.AbstractLockManagerRecordingTestTL tl = new AbstractLockManagerRecordingTest.AbstractLockManagerRecordingTestTL();
        this.threadLocal.set(tl);
        tl.icc = new InvocationContextContainer();
        MVCCLockManager mvccLockManager = new MVCCLockManager();
        DummyTransactionManager tm = DummyTransactionManager.getInstance();
        mvccLockManager.injectConfiguration(new Configuration());
        mvccLockManager.injectDependencies(null, null, (TransactionManager)tm, tl.icc);
        mvccLockManager.startLockManager();
        tl.lm = mvccLockManager;
        tl.contextFactory = new MVCCContextFactory();
        tl.icc.injectContextFactory(tl.contextFactory);
    }

    public void testFqnHashing() {
        AbstractLockManagerRecordingTest.AbstractLockManagerRecordingTestTL tl = (AbstractLockManagerRecordingTest.AbstractLockManagerRecordingTestTL)this.threadLocal.get();
        LockContainer lc = (LockContainer)TestingUtil.extractField(tl.lm, "lockContainer");
        ArrayList<Fqn> fqns = new ArrayList<Fqn>();
        fqns.add(Fqn.ROOT);
        fqns.add(Fqn.fromString((String)"/1"));
        fqns.add(Fqn.fromString((String)"/1/2"));
        fqns.add(Fqn.fromString((String)"/1/2/3"));
        fqns.add(Fqn.fromString((String)"/a/b/c/d"));
        for (Fqn f : fqns) {
            System.out.println("Fqn: " + f + "; hash = " + lc.hashToIndex((Object)f));
        }
    }
}

