/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.util.Collections;
import java.util.Properties;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.loader.JDBCCacheLoaderConfig;
import org.jboss.cache.marshall.FooClassLoader;
import org.jboss.cache.marshall.RegionBasedMarshallingTestBase;
import org.jboss.cache.marshall.SelectedClassnameClassLoader;
import org.jboss.cache.util.TestDbPropertiesFactory;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.CacheLoaderMarshallingJDBCTest")
public class CacheLoaderMarshallingJDBCTest
extends RegionBasedMarshallingTestBase {
    private static final String className = "org.jboss.cache.marshall.MyUUID";
    private Cache<Object, Object> cache;
    private Fqn fqn = Fqn.fromString((String)"/a");

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(this.cache);
        super.tearDown();
        this.cache = null;
    }

    protected ClassLoader getClassLoader() {
        String[] includesClasses = new String[]{className};
        String[] excludesClasses = new String[]{};
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return new SelectedClassnameClassLoader(includesClasses, excludesClasses, cl);
    }

    public void testCacheLoaderMarshalling() throws Exception {
        this.cacheLoaderMarshallingTest(false);
    }

    public void testCacheLoaderRegionBasedMarshalling() throws Exception {
        this.cacheLoaderMarshallingTest(true);
    }

    private void cacheLoaderMarshallingTest(boolean useRegionBased) throws Exception {
        this.cache = this.createCache(useRegionBased);
        this.cache.start();
        FooClassLoader loader = new FooClassLoader((ClassLoader)this.originalClassLoaderTL.get());
        if (useRegionBased) {
            Region r = this.cache.getRegion(Fqn.ROOT, true);
            r.registerContextClassLoader((ClassLoader)loader);
            r.activate();
        }
        Class clazz = loader.loadFoo();
        Object obj = clazz.newInstance();
        Thread.currentThread().setContextClassLoader(loader);
        this.cache.put(this.fqn, (Object)"key", obj);
        this.resetContextClassLoader();
        this.cache.evict(this.fqn);
        Thread.currentThread().setContextClassLoader(loader);
        AssertJUnit.assertEquals(obj, (Object)this.cache.get(this.fqn, (Object)"key"));
    }

    private Cache createCache(boolean useRegionBased) throws Exception {
        Properties prop = TestDbPropertiesFactory.getTestDbProperties();
        prop.setProperty("cache.jdbc.table.drop", "true");
        Cache cache = new UnitTestCacheFactory().createCache(false);
        Configuration config = cache.getConfiguration();
        config.setUseRegionBasedMarshalling(useRegionBased);
        config.setInactiveOnStartup(useRegionBased);
        int wakeupInterval = 1000000;
        EvictionConfig ec = new EvictionConfig(new EvictionRegionConfig(Fqn.ROOT, (EvictionAlgorithmConfig)new LRUAlgorithmConfig(1000000L, 0L, 1000)), wakeupInterval);
        config.setEvictionConfig(ec);
        CacheLoaderConfig clc = new CacheLoaderConfig();
        clc.setPassivation(true);
        clc.setShared(false);
        JDBCCacheLoaderConfig jdbc_clc = new JDBCCacheLoaderConfig();
        jdbc_clc.setProperties(prop);
        clc.setIndividualCacheLoaderConfigs(Collections.singletonList(jdbc_clc));
        config.setCacheLoaderConfig(clc);
        return cache;
    }
}

