/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.RegionManager;
import org.jboss.cache.RegionManagerImpl;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.remote.ReplicateCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.invocation.CacheInvocationDelegate;
import org.jboss.cache.marshall.AbstractVersionAwareMarshallerTest;
import org.jboss.cache.marshall.CacheMarshaller200;
import org.jboss.cache.marshall.CacheMarshaller210;
import org.jboss.cache.marshall.CacheMarshaller300;
import org.jboss.cache.marshall.VersionAwareMarshaller;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="marshall.CacheMarshallerTestBase")
public abstract class CacheMarshallerTestBase
extends AbstractVersionAwareMarshallerTest {
    protected String currentVersion;
    protected int currentVersionShort;
    protected Class expectedMarshallerClass;
    protected Class latestMarshallerClass = CacheMarshaller300.class;
    protected ThreadLocal<CacheMarshallerTestBaseTL> threadLocal = new ThreadLocal();

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        ComponentRegistry cr;
        CacheMarshallerTestBaseTL tl = new CacheMarshallerTestBaseTL();
        this.threadLocal.set(tl);
        tl.c = new Configuration();
        tl.c.setUseRegionBasedMarshalling(false);
        tl.c.setInactiveOnStartup(false);
        tl.c.setReplVersionString(this.currentVersion);
        this.cr = cr = new ComponentRegistry(tl.c, (CacheSPI)new CacheInvocationDelegate());
        tl.marshaller = this.createVAMandRestartCache((RegionManager)new RegionManagerImpl());
        tl.regionManager = (RegionManager)cr.getComponent(RegionManager.class);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.threadLocal.set(null);
    }

    protected void assertObjectArraysAreEqual(Object[] a1, Object[] a2) {
        AssertJUnit.assertEquals((String)"Number of args should match", (int)a1.length, (int)a2.length);
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] instanceof List && a2[i] instanceof List) {
                Object[] a1Elements = ((List)a1[i]).toArray();
                Object[] a2Elements = ((List)a2[i]).toArray();
                this.assertObjectArraysAreEqual(a1Elements, a2Elements);
                continue;
            }
            AssertJUnit.assertEquals((String)("Argument # " + i + " should be equal"), (Object)a1[i], (Object)a2[i]);
        }
    }

    public void testGetMarshaller() {
        CacheMarshallerTestBaseTL tl = this.threadLocal.get();
        VersionAwareMarshaller marshaller = tl.marshaller;
        AssertJUnit.assertEquals((String)"Only one marshaller should be in the map by this stage", (int)1, (int)marshaller.marshallers.size());
        AssertJUnit.assertEquals((Object)this.expectedMarshallerClass, marshaller.getMarshaller(this.currentVersionShort).getClass());
        assert (marshaller.defaultMarshaller.getClass().equals(this.expectedMarshallerClass));
        AssertJUnit.assertEquals((Object)this.latestMarshallerClass, marshaller.getMarshaller(15).getClass());
        AssertJUnit.assertEquals((Object)this.latestMarshallerClass, marshaller.getMarshaller(1).getClass());
        AssertJUnit.assertEquals((Object)this.latestMarshallerClass, marshaller.getMarshaller(-1).getClass());
        AssertJUnit.assertEquals((Object)this.latestMarshallerClass, marshaller.getMarshaller(0).getClass());
        AssertJUnit.assertEquals(CacheMarshaller200.class, marshaller.getMarshaller(20).getClass());
        AssertJUnit.assertEquals(CacheMarshaller210.class, marshaller.getMarshaller(21).getClass());
        assert (marshaller.marshallers.size() == 3) : "Should have 3 marshallers now";
    }

    public void testStringBasedFqn() throws Exception {
        CacheMarshallerTestBaseTL tl = this.threadLocal.get();
        VersionAwareMarshaller marshaller = tl.marshaller;
        Fqn fqn = Fqn.fromElements((Object[])new String[]{"JSESSIONID", "1010.10.5:3000", "1234567890", "1"});
        byte[] asBytes = marshaller.objectToByteBuffer((Object)fqn);
        System.out.println("Marshalled to " + asBytes.length + " bytes");
        Object o2 = marshaller.objectFromByteBuffer(asBytes);
        AssertJUnit.assertEquals((Object)fqn, (Object)o2);
    }

    public void testNonStringBasedFqn() throws Exception {
        CacheMarshallerTestBaseTL tl = this.threadLocal.get();
        VersionAwareMarshaller marshaller = tl.marshaller;
        Fqn fqn = Fqn.fromElements((Object[])new Serializable[]{Integer.valueOf(3), Boolean.valueOf(false)});
        byte[] asBytes = marshaller.objectToByteBuffer((Object)fqn);
        Object o2 = marshaller.objectFromByteBuffer(asBytes);
        AssertJUnit.assertEquals((Object)fqn, (Object)o2);
    }

    public void testMethodCall() throws Exception {
        CacheMarshallerTestBaseTL tl = this.threadLocal.get();
        VersionAwareMarshaller marshaller = tl.marshaller;
        Fqn fqn = Fqn.fromElements((Object[])new Serializable[]{Integer.valueOf(3), Boolean.valueOf(false)});
        PutKeyValueCommand cmd = new PutKeyValueCommand(null, fqn, (Object)"key", (Object)"value");
        byte[] asBytes = marshaller.objectToByteBuffer((Object)cmd);
        Object o2 = marshaller.objectFromByteBuffer(asBytes);
        AssertJUnit.assertTrue((String)"Unmarshalled object should be a method call", (boolean)(o2 instanceof ReplicableCommand));
        ReplicableCommand cmd2 = (ReplicableCommand)o2;
        AssertJUnit.assertEquals((Object)cmd, (Object)cmd2);
    }

    public void testNestedMethodCall() throws Exception {
        CacheMarshallerTestBaseTL tl = this.threadLocal.get();
        VersionAwareMarshaller marshaller = tl.marshaller;
        Fqn fqn = Fqn.fromElements((Object[])new Serializable[]{Integer.valueOf(3), Boolean.valueOf(false)});
        PutKeyValueCommand cmd = new PutKeyValueCommand(null, fqn, (Object)"key", (Object)"value");
        ReplicateCommand replicateCmd = new ReplicateCommand((ReplicableCommand)cmd);
        byte[] asBytes = marshaller.objectToByteBuffer((Object)replicateCmd);
        Object o2 = marshaller.objectFromByteBuffer(asBytes);
        AssertJUnit.assertTrue((String)"Unmarshalled object should be a method call", (boolean)(o2 instanceof ReplicableCommand));
        ReplicableCommand cmd2 = (ReplicableCommand)o2;
        AssertJUnit.assertEquals((Object)replicateCmd, (Object)cmd2);
    }

    public void testLargeString() throws Exception {
        this.doLargeStringTest(Short.MAX_VALUE, false);
    }

    public void testLargerString() throws Exception {
        this.doLargeStringTest(32768, false);
    }

    public void test64KString() throws Exception {
        this.doLargeStringTest(65526, false);
        this.doLargeStringTest(65546, false);
    }

    public void test128KString() throws Exception {
        this.doLargeStringTest(131062, false);
        this.doLargeStringTest(131082, false);
    }

    public void testLargeStringMultiByte() throws Exception {
        this.doLargeStringTest(Short.MAX_VALUE, true);
    }

    public void testLargerStringMultiByte() throws Exception {
        this.doLargeStringTest(32768, true);
    }

    public void test64KStringMultiByte() throws Exception {
        this.doLargeStringTest(65526, true);
        this.doLargeStringTest(65546, true);
    }

    public void test128KStringMultiByte() throws Exception {
        this.doLargeStringTest(131062, true);
        this.doLargeStringTest(131082, true);
    }

    protected void doLargeStringTest(int stringSize, boolean multiByteChars) throws Exception {
        CacheMarshallerTestBaseTL tl = this.threadLocal.get();
        VersionAwareMarshaller marshaller = tl.marshaller;
        StringBuilder sb = new StringBuilder();
        int startingChar = multiByteChars ? 210 : 65;
        for (int i = 0; i < stringSize; ++i) {
            sb.append((char)(startingChar + i % 26));
        }
        String largeString = sb.toString();
        AssertJUnit.assertEquals((int)stringSize, (int)largeString.length());
        byte[] buf = marshaller.objectToByteBuffer((Object)largeString);
        AssertJUnit.assertEquals((Object)largeString, (Object)marshaller.objectFromByteBuffer(buf));
    }

    public void testReplicationQueue() throws Exception {
        this.doReplicationQueueTest();
    }

    public void testReplicationQueueWithRegionBasedMarshalling() throws Exception {
        CacheMarshallerTestBaseTL tl = this.threadLocal.get();
        VersionAwareMarshaller marshaller = tl.marshaller;
        tl.c.setUseRegionBasedMarshalling(true);
        marshaller.init();
        this.doReplicationQueueTest();
    }

    protected void doReplicationQueueTest() throws Exception {
        CacheMarshallerTestBaseTL tl = this.threadLocal.get();
        VersionAwareMarshaller marshaller = tl.marshaller;
        ArrayList<ReplicateCommand> calls = new ArrayList<ReplicateCommand>();
        Fqn f = Fqn.fromElements((Object[])new Serializable[]{"BlahBlah", Integer.valueOf(3), Boolean.valueOf(false)});
        String k = "key";
        String v = "value";
        PutKeyValueCommand cmd = new PutKeyValueCommand(null, f, (Object)k, (Object)v);
        ReplicateCommand replCmd = new ReplicateCommand((ReplicableCommand)cmd);
        calls.add(replCmd);
        cmd = new PutKeyValueCommand(null, f, (Object)k, (Object)v);
        replCmd = new ReplicateCommand((ReplicableCommand)cmd);
        calls.add(replCmd);
        ReplicateCommand replAllCmd = new ReplicateCommand(calls);
        byte[] buf = marshaller.objectToByteBuffer((Object)replAllCmd);
        AssertJUnit.assertEquals((Object)replAllCmd, (Object)marshaller.objectFromByteBuffer(buf));
    }

    protected class CacheMarshallerTestBaseTL {
        protected VersionAwareMarshaller marshaller;
        protected RegionManager regionManager;
        protected Configuration c;

        protected CacheMarshallerTestBaseTL() {
        }
    }
}

