/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.marshall.MyList;
import org.jboss.cache.marshall.MyMap;
import org.jboss.cache.marshall.MySet;
import org.jboss.cache.marshall.RegionBasedMarshallingTestBase;
import org.jboss.cache.marshall.SelectedClassnameClassLoader;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, testName="marshall.CustomCollectionTest")
public class CustomCollectionTest
extends RegionBasedMarshallingTestBase
implements Serializable {
    private transient Cache<Object, Object> cache1 = null;
    private transient Cache<Object, Object> cache2 = null;
    private String myListClass = MyList.class.getName();
    private String mySetClass = MySet.class.getName();
    private String myMapClass = MyMap.class.getName();

    @Override
    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        super.setUp();
        this.cache1 = this.createCache();
        this.cache2 = this.createCache();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(this.cache1, this.cache2);
        this.cache1 = null;
        this.cache2 = null;
        super.tearDown();
    }

    public void testMap() throws Exception {
        this.doMapTest(MarshallingMode.DEFAULT_WITHOUT_MARSHALLED_VALUES);
    }

    public void testMapWithRegions() throws Exception {
        this.doMapTest(MarshallingMode.CUSTOM_CLASSLOADER_WITH_REGIONS);
    }

    public void testMapWithMarshalledValues() throws Exception {
        this.doMapTest(MarshallingMode.CUSTOM_CLASSLOADER_WITH_MARSHALLEDVALUES);
    }

    public void testMapWithMarshalledValuesDefaultClassloader() throws Exception {
        this.doMapTest(MarshallingMode.DEFAULT_WITH_MARSHALLED_VALUES);
    }

    public void testSet() throws Exception {
        this.doSetTest(MarshallingMode.DEFAULT_WITHOUT_MARSHALLED_VALUES);
    }

    public void testSetWithRegions() throws Exception {
        this.doSetTest(MarshallingMode.CUSTOM_CLASSLOADER_WITH_REGIONS);
    }

    public void testSetWithMarshalledValues() throws Exception {
        this.doSetTest(MarshallingMode.CUSTOM_CLASSLOADER_WITH_MARSHALLEDVALUES);
    }

    public void testSetWithMarshalledValuesDefaultClassloader() throws Exception {
        this.doSetTest(MarshallingMode.DEFAULT_WITH_MARSHALLED_VALUES);
    }

    public void testList() throws Exception {
        this.doListTest(MarshallingMode.DEFAULT_WITHOUT_MARSHALLED_VALUES);
    }

    public void testListWithRegions() throws Exception {
        this.doListTest(MarshallingMode.CUSTOM_CLASSLOADER_WITH_REGIONS);
    }

    public void testListWithMarshalledValues() throws Exception {
        this.doListTest(MarshallingMode.CUSTOM_CLASSLOADER_WITH_MARSHALLEDVALUES);
    }

    public void testListWithMarshalledValuesDefaultClassloader() throws Exception {
        this.doListTest(MarshallingMode.DEFAULT_WITH_MARSHALLED_VALUES);
    }

    private void doMapTest(MarshallingMode marshallingMode) throws Exception {
        ClassLoader customClassLoader = this.getCollectionsClassLoader();
        Class<?> mapClass = customClassLoader.loadClass(this.myMapClass);
        Map map = (Map)(marshallingMode.isUsingCustomClassLoader() ? mapClass.newInstance() : new MyMap());
        map.put("k", "v");
        this.configureCaches(customClassLoader, marshallingMode);
        this.cache1.start();
        this.cache2.start();
        if (marshallingMode == MarshallingMode.CUSTOM_CLASSLOADER_WITH_MARSHALLEDVALUES) {
            Thread.currentThread().setContextClassLoader(customClassLoader);
        }
        this.cache1.put(CustomCollectionTest.fqn("/a"), (Object)"key", (Object)map);
        Object o = this.cache2.get(CustomCollectionTest.fqn("/a"), (Object)"key");
        if (marshallingMode == MarshallingMode.CUSTOM_CLASSLOADER_WITH_MARSHALLEDVALUES) {
            this.resetContextClassLoader();
        }
        AssertJUnit.assertTrue((boolean)(o instanceof Map));
        if (marshallingMode.isUsingCustomClassLoader()) {
            AssertJUnit.assertNotSame(MyMap.class, o.getClass());
            AssertJUnit.assertSame(mapClass, o.getClass());
        } else {
            AssertJUnit.assertSame(MyMap.class, o.getClass());
            AssertJUnit.assertNotSame(mapClass, o.getClass());
        }
        AssertJUnit.assertEquals((Object)"v", ((Map)o).get("k"));
    }

    private void doSetTest(MarshallingMode marshallingMode) throws Exception {
        ClassLoader customClassLoader = this.getCollectionsClassLoader();
        Class<?> setClass = customClassLoader.loadClass(this.mySetClass);
        Set set = (Set)(marshallingMode.isUsingCustomClassLoader() ? setClass.newInstance() : new MySet());
        set.add("k");
        this.configureCaches(customClassLoader, marshallingMode);
        this.cache1.start();
        this.cache2.start();
        if (marshallingMode == MarshallingMode.CUSTOM_CLASSLOADER_WITH_MARSHALLEDVALUES) {
            Thread.currentThread().setContextClassLoader(customClassLoader);
        }
        this.cache1.put(CustomCollectionTest.fqn("/a"), (Object)"key", (Object)set);
        Object o = this.cache2.get(CustomCollectionTest.fqn("/a"), (Object)"key");
        if (marshallingMode == MarshallingMode.CUSTOM_CLASSLOADER_WITH_MARSHALLEDVALUES) {
            this.resetContextClassLoader();
        }
        AssertJUnit.assertTrue((boolean)(o instanceof Set));
        if (marshallingMode.isUsingCustomClassLoader()) {
            AssertJUnit.assertNotSame(MySet.class, o.getClass());
            AssertJUnit.assertSame(setClass, o.getClass());
        } else {
            AssertJUnit.assertSame(MySet.class, o.getClass());
            AssertJUnit.assertNotSame(setClass, o.getClass());
        }
        AssertJUnit.assertTrue((boolean)((Set)o).contains("k"));
    }

    private void doListTest(MarshallingMode marshallingMode) throws Exception {
        ClassLoader customClassLoader = this.getCollectionsClassLoader();
        Class<?> listClass = customClassLoader.loadClass(this.myListClass);
        List list = (List)(marshallingMode.isUsingCustomClassLoader() ? listClass.newInstance() : new MyList());
        list.add("k");
        this.configureCaches(customClassLoader, marshallingMode);
        this.cache1.start();
        this.cache2.start();
        if (marshallingMode == MarshallingMode.CUSTOM_CLASSLOADER_WITH_MARSHALLEDVALUES) {
            Thread.currentThread().setContextClassLoader(customClassLoader);
        }
        this.cache1.put(CustomCollectionTest.fqn("/a"), (Object)"key", (Object)list);
        Object o = this.cache2.get(CustomCollectionTest.fqn("/a"), (Object)"key");
        if (marshallingMode == MarshallingMode.CUSTOM_CLASSLOADER_WITH_MARSHALLEDVALUES) {
            this.resetContextClassLoader();
        }
        AssertJUnit.assertTrue((boolean)(o instanceof List));
        if (marshallingMode.isUsingCustomClassLoader()) {
            AssertJUnit.assertSame(listClass, o.getClass());
            AssertJUnit.assertNotSame(MyList.class, o.getClass());
        } else {
            AssertJUnit.assertSame(MyList.class, o.getClass());
            AssertJUnit.assertNotSame(listClass, o.getClass());
        }
        AssertJUnit.assertTrue((boolean)((List)o).contains("k"));
    }

    public void testHarnessClassLoader() throws Exception {
        Class<?> myListFromCustomLoader = this.getCollectionsClassLoader().loadClass(this.myListClass);
        AssertJUnit.assertNotNull(myListFromCustomLoader);
        AssertJUnit.assertFalse((boolean)MyList.class.equals(myListFromCustomLoader));
        Object customLoaderMyList = myListFromCustomLoader.newInstance();
        try {
            MyList m = (MyList)customLoaderMyList;
            AssertJUnit.fail((String)"Should have barfed");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private void configureCaches(ClassLoader customClassLoader, MarshallingMode marshallingMode) {
        switch (marshallingMode) {
            case CUSTOM_CLASSLOADER_WITH_REGIONS: {
                this.cache1.getConfiguration().setUseRegionBasedMarshalling(true);
                Region region1 = this.cache1.getRegion(CustomCollectionTest.fqn("/a"), true);
                region1.registerContextClassLoader(customClassLoader);
                this.cache2.getConfiguration().setUseRegionBasedMarshalling(true);
                Region region2 = this.cache2.getRegion(CustomCollectionTest.fqn("/a"), true);
                region2.registerContextClassLoader(customClassLoader);
            }
            case DEFAULT_WITHOUT_MARSHALLED_VALUES: {
                this.cache1.getConfiguration().setUseLazyDeserialization(false);
                this.cache2.getConfiguration().setUseLazyDeserialization(false);
                break;
            }
            case DEFAULT_WITH_MARSHALLED_VALUES: 
            case CUSTOM_CLASSLOADER_WITH_MARSHALLEDVALUES: {
                this.cache1.getConfiguration().setUseLazyDeserialization(true);
                this.cache2.getConfiguration().setUseLazyDeserialization(true);
            }
        }
    }

    private ClassLoader getCollectionsClassLoader() {
        String[] includesClasses = new String[]{this.myListClass, this.mySetClass, this.myMapClass};
        String[] excludesClasses = new String[]{};
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return new SelectedClassnameClassLoader(includesClasses, excludesClasses, cl);
    }

    private Cache<Object, Object> createCache() {
        Configuration c = new Configuration();
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        c.setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        Cache cache = new UnitTestCacheFactory().createCache(c, false);
        return cache;
    }

    private static Fqn fqn(String fqn) {
        return Fqn.fromString((String)fqn);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MarshallingMode {
        DEFAULT_WITH_MARSHALLED_VALUES,
        DEFAULT_WITHOUT_MARSHALLED_VALUES,
        CUSTOM_CLASSLOADER_WITH_REGIONS,
        CUSTOM_CLASSLOADER_WITH_MARSHALLEDVALUES;


        boolean isUsingCustomClassLoader() {
            return this == CUSTOM_CLASSLOADER_WITH_MARSHALLEDVALUES || this == CUSTOM_CLASSLOADER_WITH_REGIONS;
        }
    }
}

