/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.mock;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;

public class NodeSpiMock
implements NodeSPI {
    boolean isChildrenLoaded;
    boolean isDataLoaded;
    Map<Object, NodeSpiMock> children = new HashMap<Object, NodeSpiMock>();
    boolean isDeleted = false;
    boolean isValid = true;
    DataVersion version = null;
    Map data = new HashMap();
    NodeSpiMock parent;
    Fqn fqn;
    private boolean isResident = false;

    public NodeSpiMock(Fqn fqn) {
        this.fqn = fqn;
    }

    public boolean isChildrenLoaded() {
        return this.isChildrenLoaded;
    }

    public void setChildrenLoaded(boolean loaded) {
        this.isChildrenLoaded = loaded;
    }

    public boolean isDataLoaded() {
        return this.isDataLoaded;
    }

    public void setDataLoaded(boolean dataLoaded) {
        this.isDataLoaded = dataLoaded;
    }

    public Map getChildrenMapDirect() {
        return this.children;
    }

    public void setChildrenMapDirect(Map children) {
        this.children = new HashMap<Object, NodeSpiMock>(children);
    }

    public NodeSPI getOrCreateChild(Object name, GlobalTransaction tx) {
        if (this.children.containsKey(name)) {
            return this.children.get(name);
        }
        NodeSpiMock child = this.newChild(name);
        return child;
    }

    private NodeSpiMock newChild(Object name) {
        NodeSpiMock child = new NodeSpiMock(Fqn.fromRelativeElements((Fqn)this.fqn, (Object[])new Object[]{name}));
        child.parent = this;
        this.children.put(name, child);
        return child;
    }

    public NodeLock getLock() {
        throw new UnsupportedOperationException();
    }

    public void setFqn(Fqn f) {
        throw new UnsupportedOperationException();
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void markAsDeleted(boolean marker) {
        this.isDeleted = marker;
    }

    public void markAsDeleted(boolean marker, boolean recursive) {
        this.isDeleted = marker;
        if (recursive) {
            for (NodeSpiMock child : this.children.values()) {
                child.markAsDeleted(marker, true);
            }
        }
    }

    public void addChild(Object nodeName, Node nodeToAdd) {
        this.children.put(nodeName, (NodeSpiMock)nodeToAdd);
        ((NodeSpiMock)nodeToAdd).parent = this;
        ((NodeSpiMock)nodeToAdd).fqn = Fqn.fromRelativeElements((Fqn)this.fqn, (Object[])new Object[]{nodeName});
    }

    public void printDetails(StringBuilder sb, int indent) {
    }

    public void print(StringBuilder sb, int indent) {
    }

    public void setVersion(DataVersion version) {
        this.version = version;
    }

    public DataVersion getVersion() {
        return this.version;
    }

    public Set getChildrenDirect() {
        return new HashSet<NodeSpiMock>(this.children.values());
    }

    public void removeChildrenDirect() {
        this.children.clear();
    }

    public Set getChildrenDirect(boolean includeMarkedAsDeleted) {
        HashSet<NodeSpiMock> result = new HashSet<NodeSpiMock>();
        for (NodeSpiMock child : this.children.values()) {
            if (!includeMarkedAsDeleted && child.isDeleted()) continue;
            result.add(child);
        }
        return result;
    }

    public NodeSPI getChildDirect(Object childName) {
        return this.children.get(childName);
    }

    public NodeSPI addChildDirect(Fqn childName) {
        if (childName.size() == 0) {
            return this;
        }
        Object directChildName = childName.get(0);
        NodeSpiMock directChild = this.children.get(directChildName);
        Fqn subFqn = childName.getSubFqn(1, childName.size());
        if (directChild == null) {
            directChild = this.newChild(directChildName);
        }
        return directChild.addChildDirect(subFqn);
    }

    public NodeSPI addChildDirect(Fqn f, boolean notify) {
        return this.addChildDirect(f);
    }

    public NodeSPI addChildDirect(Object childName, boolean notify) {
        return this.newChild(childName);
    }

    public void addChildDirect(NodeSPI child) {
        throw new UnsupportedOperationException();
    }

    public NodeSPI getChildDirect(Fqn childName) {
        return this.children.get(childName.getLastElement());
    }

    public boolean removeChildDirect(Fqn fqn) {
        throw new UnsupportedOperationException();
    }

    public boolean removeChildDirect(Object childName) {
        return this.children.remove(childName) != null;
    }

    public Object removeDirect(Object key) {
        return this.data.remove(key);
    }

    public Object putDirect(Object key, Object value) {
        return this.data.put(key, value);
    }

    public void putAllDirect(Map data) {
        this.data.putAll(data);
    }

    public Map getDataDirect() {
        return this.data;
    }

    public Object getDirect(Object key) {
        return this.data.get(key);
    }

    public void clearDataDirect() {
        this.data.clear();
    }

    public Set getKeysDirect() {
        return this.data.keySet();
    }

    public Set getChildrenNamesDirect() {
        return new HashSet<Object>(this.children.keySet());
    }

    public CacheSPI getCache() {
        throw new UnsupportedOperationException();
    }

    public NodeSPI getParentDirect() {
        return this.parent;
    }

    public Node getParent() {
        return this.parent;
    }

    public boolean hasChildrenDirect() {
        return !this.children.isEmpty();
    }

    public Map getInternalState(boolean onlyInternalState) {
        throw new UnsupportedOperationException();
    }

    public void setInternalState(Map state) {
        throw new UnsupportedOperationException();
    }

    public void setValid(boolean valid, boolean recursive) {
        this.isValid = valid;
        if (recursive) {
            for (NodeSpiMock child : this.children.values()) {
                child.setValid(valid, true);
                child.isValid = valid;
            }
        }
    }

    public boolean isNullNode() {
        throw new UnsupportedOperationException();
    }

    public void markForUpdate(DataContainer container, boolean writeSkewCheck) {
        throw new UnsupportedOperationException();
    }

    public void commitUpdate(InvocationContext ctx, DataContainer container) {
        throw new UnsupportedOperationException();
    }

    public boolean isChanged() {
        throw new UnsupportedOperationException();
    }

    public boolean isCreated() {
        throw new UnsupportedOperationException();
    }

    public InternalNode getDelegationTarget() {
        throw new UnsupportedOperationException();
    }

    public void setCreated(boolean created) {
        throw new UnsupportedOperationException();
    }

    public void rollbackUpdate() {
        throw new UnsupportedOperationException();
    }

    public Set getChildren() {
        return this.getChildrenDirect();
    }

    public Set getChildrenNames() {
        return this.getChildrenNamesDirect();
    }

    public Map getData() {
        return this.getDataDirect();
    }

    public Set getKeys() {
        return this.getKeysDirect();
    }

    public Fqn getFqn() {
        return this.fqn;
    }

    public Node addChild(Fqn f) {
        return this.addChildDirect(f);
    }

    public boolean removeChild(Fqn f) {
        return this.removeChildDirect(f);
    }

    public boolean removeChild(Object childName) {
        return this.removeChildDirect(childName);
    }

    public Node getChild(Fqn f) {
        return this.getChildDirect(f);
    }

    public Node getChild(Object name) {
        return this.getChildDirect(name);
    }

    public Object put(Object key, Object value) {
        return this.putDirect(key, value);
    }

    public Object putIfAbsent(Object key, Object value) {
        if (this.data.containsKey(key)) {
            return this.data.get(key);
        }
        return this.data.put(key, value);
    }

    public Object replace(Object key, Object value) {
        return this.data.put(key, value);
    }

    public boolean replace(Object key, Object oldValue, Object newValue) {
        if (this.data.get(key).equals(oldValue)) {
            this.data.put(key, newValue);
            return true;
        }
        return false;
    }

    public void putAll(Map map) {
        this.putAllDirect(map);
    }

    public void replaceAll(Map map) {
        this.data = map;
    }

    public Object get(Object key) {
        return this.getDirect(key);
    }

    public Object remove(Object key) {
        return this.removeDirect(key);
    }

    public void clearData() {
        this.clearDataDirect();
    }

    public int dataSize() {
        return this.data.size();
    }

    public boolean hasChild(Fqn f) {
        NodeSpiMock directChild = this.children.get(this.fqn.getLastElement());
        return directChild != null && (this.fqn.size() == 1 || directChild.hasChild(f.getSubFqn(1, f.size())));
    }

    public boolean hasChild(Object o) {
        return this.children.containsKey(o);
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isResident() {
        return this.isResident;
    }

    public void setResident(boolean resident) {
        this.isResident = resident;
    }

    public boolean isLockForChildInsertRemove() {
        return false;
    }

    public void setLockForChildInsertRemove(boolean lockForChildInsertRemove) {
    }

    public void releaseObjectReferences(boolean recursive) {
    }
}

