/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.notifications;

import org.jboss.cache.Cache;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.BuddyGroupChangeNotificationTest")
public class BuddyGroupChangeNotificationTest
extends BuddyReplicationTestsBase {
    Cache c1;
    Cache c2;
    Cache c3;
    static boolean stage2 = false;
    static boolean notificationsReceived = true;

    @BeforeMethod
    public void setUp() throws CloneNotSupportedException {
        UnitTestCacheFactory cf = new UnitTestCacheFactory();
        Configuration conf = new Configuration();
        conf.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        conf.setBuddyReplicationConfig(brc);
        this.c1 = cf.createCache(conf, false);
        this.c2 = cf.createCache(conf.clone(), false);
        this.c3 = cf.createCache(conf.clone(), false);
        this.c1.start();
        this.c2.start();
        this.c3.start();
        TestingUtil.blockUntilViewsReceived(60000L, this.c1, this.c2, this.c3);
    }

    @AfterMethod
    public void tearDown() {
        System.out.println("***** BuddyGroupChangeNotificationTest.tearDown");
        TestingUtil.killCaches(this.c1, this.c2, this.c3);
        this.c1 = null;
        this.c2 = null;
        this.c3 = null;
    }

    @Test(timeOut=60000L)
    public void testChangingGroups() throws Exception {
        this.waitForBuddy(this.c1, this.c2, true, 60000L);
        this.waitForBuddy(this.c2, this.c3, true, 60000L);
        this.waitForBuddy(this.c3, this.c1, true, 60000L);
        this.c3.stop();
        this.waitForBuddy(this.c1, this.c2, true, 60000L);
        this.waitForBuddy(this.c2, this.c1, true, 60000L);
        stage2 = true;
        this.c3.start();
        this.waitForBuddy(this.c1, this.c2, true, 60000L);
        this.waitForBuddy(this.c2, this.c3, true, 60000L);
        this.waitForBuddy(this.c3, this.c1, true, 60000L);
        assert (notificationsReceived);
    }
}

