/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.notifications;

import java.util.HashMap;
import org.jboss.cache.util.Util;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.NodeMapDiffTest")
public class NodeMapDiffTest {
    public void testDataAdded() {
        Util.MapModifications expected = new Util.MapModifications();
        expected.addedEntries.put("key", "value");
        expected.addedEntries.put("key1", "value1");
        HashMap<String, String> pre = new HashMap<String, String>();
        pre.put("oldKey", "oldValue");
        HashMap<String, String> post = new HashMap<String, String>();
        post.putAll(pre);
        post.put("key", "value");
        post.put("key1", "value1");
        AssertJUnit.assertEquals((Object)expected, (Object)Util.diffNodeData(pre, post));
    }

    public void testDataRemoved() {
        Util.MapModifications expected = new Util.MapModifications();
        expected.removedEntries.put("key", "value");
        expected.removedEntries.put("key1", "value1");
        HashMap<String, String> post = new HashMap<String, String>();
        post.put("oldKey", "oldValue");
        HashMap<String, String> pre = new HashMap<String, String>();
        pre.putAll(post);
        pre.put("key", "value");
        pre.put("key1", "value1");
        AssertJUnit.assertEquals((Object)expected, (Object)Util.diffNodeData(pre, post));
    }

    public void testDataChanged() {
        Util.MapModifications expected = new Util.MapModifications();
        expected.modifiedEntries.put("key", "value");
        expected.modifiedEntries.put("key1", "value1");
        HashMap<String, String> pre = new HashMap<String, String>();
        pre.put("oldKey", "oldValue");
        pre.put("key", "valueOLD");
        pre.put("key1", "value1OLD");
        HashMap<String, String> post = new HashMap<String, String>();
        post.putAll(pre);
        post.put("key", "value");
        post.put("key1", "value1");
        AssertJUnit.assertEquals((Object)expected, (Object)Util.diffNodeData(pre, post));
    }

    public void testNullMaps() {
        try {
            Util.diffNodeData(null, null);
            AssertJUnit.fail((String)"Expected NPE");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            Util.diffNodeData(new HashMap(), null);
            AssertJUnit.fail((String)"Expected NPE");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            Util.diffNodeData(null, new HashMap());
            AssertJUnit.fail((String)"Expected NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testEmptyMaps() {
        Util.MapModifications expected = new Util.MapModifications();
        HashMap pre = new HashMap();
        HashMap post = new HashMap();
        AssertJUnit.assertEquals((Object)expected, (Object)Util.diffNodeData(pre, post));
    }

    public void testNoChange() {
        Util.MapModifications expected = new Util.MapModifications();
        HashMap<String, String> pre = new HashMap<String, String>();
        pre.put("a", "b");
        pre.put("c", "d");
        pre.put("e", "f");
        HashMap<String, String> post = new HashMap<String, String>();
        post.put("a", "b");
        post.put("c", "d");
        post.put("e", "f");
        AssertJUnit.assertEquals((Object)expected, (Object)Util.diffNodeData(pre, post));
    }

    public void testMultipleChanges() {
        Util.MapModifications expected = new Util.MapModifications();
        expected.modifiedEntries.put("key", "value");
        expected.modifiedEntries.put("key1", "value1");
        expected.addedEntries.put("key2", "value2");
        expected.addedEntries.put("key3", "value3");
        expected.removedEntries.put("key4", "value4");
        expected.removedEntries.put("key5", "value5");
        HashMap<String, String> pre = new HashMap<String, String>();
        pre.put("oldKey", "oldValue");
        pre.put("key", "valueOLD");
        pre.put("key1", "value1OLD");
        pre.put("key4", "value4");
        pre.put("key5", "value5");
        HashMap<String, String> post = new HashMap<String, String>();
        post.put("oldKey", "oldValue");
        post.put("key", "value");
        post.put("key1", "value1");
        post.put("key2", "value2");
        post.put("key3", "value3");
        AssertJUnit.assertEquals((Object)expected, (Object)Util.diffNodeData(pre, post));
    }
}

