/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.notifications;

import java.util.ArrayList;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.notifications.EventLog;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.EventImpl;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="notifications.NotifyNodeInvalidatedTest")
public class NotifyNodeInvalidatedTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidatedCallback() throws CloneNotSupportedException {
        Cache c1 = null;
        Cache c2 = null;
        try {
            Configuration cfg = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.INVALIDATION_SYNC, false);
            cfg.setNodeLockingScheme(Configuration.NodeLockingScheme.MVCC);
            c1 = new UnitTestCacheFactory().createCache(cfg.clone());
            c2 = new UnitTestCacheFactory().createCache(cfg.clone());
            EventLog eventLog = new EventLog();
            c2.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            c2.put("/a/b/c", (Object)"x", (Object)"y");
            c2.addCacheListener((Object)eventLog);
            c1.put("/a/b/c", (Object)"k", (Object)"v");
            ArrayList<EventImpl> expected = new ArrayList<EventImpl>();
            expected.add(new EventImpl(true, c2, null, null, Fqn.fromString((String)"/a/b/c"), null, false, null, false, null, Event.Type.NODE_INVALIDATED));
            expected.add(new EventImpl(false, c2, null, null, Fqn.fromString((String)"/a/b/c"), null, false, null, false, null, Event.Type.NODE_INVALIDATED));
            assert (((Object)expected).equals(eventLog.events)) : "Expected " + expected + " but got " + eventLog.events;
            assert (c2.getNode("/a/b/c") == null);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            TestingUtil.killCaches(c1, c2);
            throw throwable;
        }
        TestingUtil.killCaches(c1, c2);
    }
}

