/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "optimistic"}, sequential=true, testName="optimistic.OptimisticVersioningTest")
public class OptimisticVersioningTest
extends AbstractOptimisticTestCase {
    private static final Log log = LogFactory.getLog(OptimisticVersioningTest.class);
    CacheSPI cache1;
    CacheSPI cache2;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache1 = this.createReplicatedCache(Configuration.CacheMode.REPL_SYNC);
        this.cache2 = this.createReplicatedCache(Configuration.CacheMode.REPL_SYNC);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        super.tearDown();
        this.destroyCache((Cache<Object, Object>)this.cache1);
        this.destroyCache((Cache<Object, Object>)this.cache2);
        this.cache1 = null;
        this.cache2 = null;
    }

    public void testVersionPropagation() {
        Fqn fqn = Fqn.fromString((String)"/a/b");
        String key = "key";
        this.cache1.put(fqn, (Object)key, (Object)"value");
        DataVersion v1 = this.cache1.getNode(fqn).getVersion();
        DataVersion v2 = this.cache2.getNode(fqn).getVersion();
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(fqn, (Object)key));
        AssertJUnit.assertEquals((String)"Version info should have propagated", (Object)v1, (Object)v2);
        this.cache1.put(fqn, (Object)key, (Object)"value2");
        v1 = this.cache1.getNode(fqn).getVersion();
        v2 = this.cache2.getNode(fqn).getVersion();
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache2.get(fqn, (Object)key));
        AssertJUnit.assertEquals((String)"Version info should have propagated", (Object)v1, (Object)v2);
    }

    public void testTwoCachesUpdatingSimultaneously() throws Exception {
        TransactionManager mgr1 = this.cache1.getTransactionManager();
        TransactionManager mgr2 = this.cache2.getTransactionManager();
        Fqn fqn = Fqn.fromString((String)"/a/b");
        String key = "key";
        this.cache1.put(fqn, (Object)key, (Object)"value");
        DataVersion v1 = this.cache1.getNode(fqn).getVersion();
        DataVersion v2 = this.cache2.getNode(fqn).getVersion();
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(fqn, (Object)key));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(fqn, (Object)key));
        AssertJUnit.assertEquals((String)"Version info should have propagated", (Object)v1, (Object)v2);
        mgr1.begin();
        this.cache1.put(fqn, (Object)key, (Object)"value2");
        Transaction tx1 = mgr1.suspend();
        mgr2.begin();
        this.cache2.put(fqn, (Object)key, (Object)"value3");
        Transaction tx2 = mgr2.suspend();
        mgr1.resume(tx1);
        mgr1.commit();
        try {
            mgr2.resume(tx2);
            mgr2.commit();
            AssertJUnit.assertTrue((String)"Should have failed", (boolean)false);
        }
        catch (RollbackException rbe) {
            AssertJUnit.assertTrue((String)"Should have failed", (boolean)true);
        }
        v1 = this.cache1.getNode(fqn).getVersion();
        v2 = this.cache2.getNode(fqn).getVersion();
        AssertJUnit.assertEquals((String)"Version info should have propagated", (Object)v1, (Object)v2);
    }

    public void testRemovalWithSpecifiedVersion() throws Exception {
        Fqn fqn = Fqn.fromString((String)"/test/node");
        NodeSPI root = this.cache1.getRoot();
        this.cache1.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)new NonLockingDataVersion());
        root.addChild(fqn);
        this.cache1.getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)new NonLockingDataVersion());
        this.cache1.removeNode(fqn);
        Assert.assertNull((Object)this.cache1.getRoot().getChild(fqn));
    }

    private static class NonLockingDataVersion
    implements DataVersion {
        private static final long serialVersionUID = 1L;

        private NonLockingDataVersion() {
        }

        public boolean newerThan(DataVersion dataVersion) {
            if (dataVersion instanceof DefaultDataVersion) {
                log.info((Object)"unexpectedly validating against a DefaultDataVersion", (Throwable)new Exception("Just a stack trace"));
            } else {
                log.trace((Object)"non locking lock check...");
            }
            return false;
        }
    }
}

