/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "optimistic"}, sequential=true, testName="optimistic.OptimisticWithPassivationTest")
public class OptimisticWithPassivationTest
extends AbstractOptimisticTestCase {
    protected CacheLoaderConfig getCacheLoaderConfig() throws Exception {
        return UnitTestCacheConfigurationFactory.buildSingleCacheLoaderConfig(true, null, "org.jboss.cache.loader.DummyInMemoryCacheLoader", "", false, false, false, false, false);
    }

    private CacheSPI createLocalCache() throws Exception {
        CacheSPI<Object, Object> cache = this.createCacheUnstarted(true);
        cache.getConfiguration().setCacheLoaderConfig(this.getCacheLoaderConfig());
        cache.create();
        cache.start();
        return cache;
    }

    public void testPassivationLocal() throws Exception {
        CacheSPI cache = this.createLocalCache();
        CacheLoader loader = cache.getCacheLoaderManager().getCacheLoader();
        cache.removeNode(this.fqn);
        loader.remove(this.fqn);
        AssertJUnit.assertNull((Object)loader.get(this.fqn));
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        cache.put(this.fqn, (Object)this.key, (Object)this.value);
        mgr.commit();
        AssertJUnit.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertNull((Object)loader.get(this.fqn));
        mgr.begin();
        cache.evict(this.fqn);
        mgr.commit();
        mgr.begin();
        AssertJUnit.assertEquals((Object)this.value, loader.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, (Object)cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertNull((Object)loader.get(this.fqn));
        mgr.commit();
        mgr.begin();
        cache.removeNode(this.fqn);
        loader.remove(this.fqn);
        mgr.commit();
    }
}

