/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.options;

import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.lock.LockType;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "pessimistic"}, sequential=true, testName="options.ForceWriteLockTest")
public class ForceWriteLockTest {
    protected CacheSPI<String, String> cache;
    private Fqn fqn = Fqn.fromString((String)"/a/b");
    private TransactionManager tm;
    protected Configuration.NodeLockingScheme nodeLockingScheme = Configuration.NodeLockingScheme.PESSIMISTIC;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        Configuration c = new Configuration();
        c.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        c.setNodeLockingScheme(this.nodeLockingScheme);
        UnitTestCacheFactory instance = new UnitTestCacheFactory();
        this.cache = (CacheSPI)instance.createCache(c);
        this.tm = this.cache.getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testControl() throws Exception {
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.tm.begin();
        this.cache.get(this.fqn, (Object)"k");
        this.assertLocked(this.cache.getInvocationContext().getGlobalTransaction(), this.fqn.getParent(), false);
        this.assertLocked(this.cache.getInvocationContext().getGlobalTransaction(), this.fqn, false);
        this.tm.commit();
        this.assertNotLocked(this.fqn);
    }

    public void testForceWithGetTx() throws Exception {
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.tm.begin();
        this.cache.getInvocationContext().getOptionOverrides().setForceWriteLock(true);
        this.cache.get(this.fqn, (Object)"k");
        this.assertLocked(this.cache.getInvocationContext().getGlobalTransaction(), this.fqn.getParent(), false);
        this.assertLocked(this.cache.getInvocationContext().getGlobalTransaction(), this.fqn, true);
        this.tm.commit();
        this.assertNotLocked(this.fqn);
        this.testControl();
    }

    public void testForceWithPutTx() throws Exception {
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.tm.begin();
        this.cache.getInvocationContext().getOptionOverrides().setForceWriteLock(true);
        this.cache.put(this.fqn, (Object)"k", (Object)"v2");
        this.assertLocked(this.cache.getInvocationContext().getGlobalTransaction(), this.fqn.getParent(), false);
        this.assertLocked(this.cache.getInvocationContext().getGlobalTransaction(), this.fqn, true);
        this.tm.commit();
        this.assertNotLocked(this.fqn);
        this.testControl();
    }

    public void testForceWithRemoveTx() throws Exception {
        this.cache.put(this.fqn, (Object)"k", (Object)"v");
        this.tm.begin();
        this.cache.getInvocationContext().getOptionOverrides().setForceWriteLock(true);
        this.cache.remove(this.fqn, (Object)"k");
        this.assertLocked(this.cache.getInvocationContext().getGlobalTransaction(), this.fqn.getParent(), false);
        this.assertLocked(this.cache.getInvocationContext().getGlobalTransaction(), this.fqn, true);
        this.tm.commit();
        this.assertNotLocked(this.fqn);
        this.testControl();
    }

    protected void assertNotLocked(Fqn fqn) {
        assert (!TestingUtil.extractLockManager(this.cache).isLocked(this.cache.peek(fqn, true))) : "Node " + fqn + " is locked!!";
    }

    protected void assertLocked(Object owner, Fqn fqn, boolean write_locked) {
        LockManager lm = TestingUtil.extractLockManager(this.cache);
        NodeSPI n = this.cache.peek(fqn, true);
        if (owner == null) {
            owner = Thread.currentThread();
        }
        AssertJUnit.assertTrue((String)("node " + fqn + " is not locked"), (boolean)lm.isLocked(n));
        if (write_locked) {
            AssertJUnit.assertTrue((String)("node " + fqn + " is not write-locked by owner " + owner), (boolean)lm.ownsLock(fqn, LockType.WRITE, owner));
        } else {
            AssertJUnit.assertTrue((String)("node " + fqn + " is not read-locked by owner " + owner), (boolean)lm.ownsLock(fqn, LockType.READ, owner));
        }
    }
}

