/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.profiling;

import java.io.IOException;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.testng.annotations.Test;

@Test(groups={"profiling"}, testName="profiling.MemoryFootprintTest", enabled=false)
public class MemoryFootprintTest {
    int numFqns = 100000;

    public void testLocal() throws IOException {
        Cache c = new UnitTestCacheFactory().createCache(false);
        c.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.MVCC);
        c.getConfiguration().setIsolationLevel(IsolationLevel.READ_COMMITTED);
        c.start();
        for (int i = 100000; i < 100000 + this.numFqns; ++i) {
            String key = "keyX" + i;
            String value = "valX" + i;
            Fqn fqn = Fqn.fromElements((Object[])new Integer[]{i});
            c.put(fqn, (Object)key, (Object)value);
        }
        System.out.println("Hit enter when done");
        System.in.read();
        c.stop();
    }
}

