/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.profiling;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.Node;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.profiling.ProfileTest;
import org.jboss.cache.util.Caches;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"profiling"}, enabled=false)
public class ProfileMapViewTest {
    protected static final long DURATION = 60000L;
    protected static final int NUM_THREADS = 15;
    protected static final int MAX_RANDOM_SLEEP_MILLIS = 1;
    protected static final int MAX_ENTRIES = 200;
    protected static final int WARMUP_LOOPS = 20000;
    protected static final boolean USE_SLEEP = false;
    private List<String> keys = new ArrayList<String>(200);
    private Random r = new Random();
    private Cache<String, String> cache;
    private Map<String, String> map;
    private Log log = LogFactory.getLog(ProfileTest.class);

    @BeforeTest
    public void setUp() {
        Configuration cfg = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL);
        cfg.setNodeLockingScheme(Configuration.NodeLockingScheme.MVCC);
        cfg.setConcurrencyLevel(500);
        this.cache = new UnitTestCacheFactory().createCache(cfg, false);
    }

    @AfterTest
    public void tearDown() {
        this.cache.stop();
    }

    public void testLocalModeMVCC_RC() throws Exception {
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.READ_COMMITTED);
        this.runCompleteTest();
    }

    public void testLocalModeMVCC_RR() throws Exception {
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.runCompleteTest();
    }

    private void runCompleteTest() throws Exception {
        this.init();
        this.startup();
        this.warmup();
        this.doTest();
        System.in.read();
    }

    protected void init() {
        long startTime = System.currentTimeMillis();
        this.log.warn((Object)"Starting init() phase");
        this.keys.clear();
        for (int i = 0; i < 200; ++i) {
            String key = this.createRandomKey(this.r);
            while (this.keys.contains(key)) {
                key = this.createRandomKey(this.r);
            }
            if (i % 10 == 0) {
                this.log.warn((Object)("Generated " + i + " fqns"));
            }
            this.keys.add(key);
        }
        System.gc();
        long duration = System.currentTimeMillis() - startTime;
        this.log.warn((Object)("Finished init() phase.  " + this.printDuration(duration)));
    }

    private String createRandomKey(Random r) {
        StringBuilder s = new StringBuilder("/");
        int depth = r.nextInt(3);
        for (int i = 0; i < depth; ++i) {
            s.append(r.nextInt(Integer.MAX_VALUE)).append("/");
        }
        return s.toString();
    }

    private Map<String, String> createMap(Cache<String, String> cache) {
        return Caches.asPartitionedMap((Node)cache.getRoot(), (Caches.ChildSelector)new Caches.HashKeySelector(128));
    }

    private void startup() {
        long startTime = System.currentTimeMillis();
        this.log.warn((Object)"Starting cache");
        this.cache.start();
        this.map = this.createMap(this.cache);
        long duration = System.currentTimeMillis() - startTime;
        this.log.warn((Object)("Started cache.  " + this.printDuration(duration)));
    }

    private void warmup() throws InterruptedException {
        long startTime = System.currentTimeMillis();
        ExecutorService exec = Executors.newFixedThreadPool(15);
        this.log.warn((Object)"Starting warmup");
        for (final String key : this.keys) {
            exec.execute(new Runnable(){

                public void run() {
                    ProfileMapViewTest.this.map.put(key, "value");
                }
            });
        }
        for (int i = 0; i < 20000; ++i) {
            exec.execute(new Runnable(){

                public void run() {
                    String key = (String)ProfileMapViewTest.this.keys.get(ProfileMapViewTest.this.r.nextInt(200));
                    ProfileMapViewTest.this.map.get(key);
                    ProfileMapViewTest.this.map.put(key, "value");
                    ProfileMapViewTest.this.map.remove(key);
                }
            });
        }
        exec.shutdown();
        exec.awaitTermination(360L, TimeUnit.SECONDS);
        long duration = System.currentTimeMillis() - startTime;
        this.log.warn((Object)("Finished warmup.  " + this.printDuration(duration)));
        this.cache.stop();
        this.cache.start();
        this.map = this.createMap(this.cache);
    }

    private void doTest() throws Exception {
        ExecutorService exec = Executors.newFixedThreadPool(15);
        long end = System.currentTimeMillis() + 60000L;
        long startTime = System.currentTimeMillis();
        this.log.warn((Object)"Starting test");
        int i = 0;
        while (System.currentTimeMillis() < end) {
            MyRunnable r = null;
            switch (i % 3) {
                case 0: {
                    r = new Putter(i++);
                    break;
                }
                case 1: {
                    r = new Getter(i++);
                    break;
                }
                case 2: {
                    r = new Remover(i++);
                }
            }
            exec.execute(r);
        }
        this.log.warn((Object)"Finished generating runnables; awaiting executor completion");
        exec.shutdown();
        exec.awaitTermination(i, TimeUnit.SECONDS);
        long duration = System.currentTimeMillis() - startTime;
        this.log.warn((Object)("Finished test.  " + this.printDuration(duration)));
    }

    private String getRandomString() {
        StringBuilder sb = new StringBuilder();
        int len = this.r.nextInt(10);
        for (int i = 0; i < len; ++i) {
            sb.append((char)(63 + this.r.nextInt(26)));
        }
        return sb.toString();
    }

    private String printDuration(long duration) {
        if (duration > 2000L) {
            double dSecs = (double)duration / 1000.0;
            return "Duration: " + dSecs + " seconds";
        }
        return "Duration: " + duration + " millis";
    }

    private class Remover
    extends MyRunnable {
        private Remover(int id) {
            this.id = id;
            this.mode = Mode.REMOVE;
        }
    }

    private class Getter
    extends MyRunnable {
        private Getter(int id) {
            this.id = id;
            this.mode = Mode.GET;
        }
    }

    private class Putter
    extends MyRunnable {
        private Putter(int id) {
            this.id = id;
            this.mode = Mode.PUT;
        }
    }

    private abstract class MyRunnable
    implements Runnable {
        int id;
        Mode mode;

        private MyRunnable() {
        }

        public void run() {
            if (this.id % 100 == 0) {
                ProfileMapViewTest.this.log.warn((Object)("Processing iteration " + this.id));
            }
            String k = ProfileMapViewTest.this.getRandomString();
            String key = (String)ProfileMapViewTest.this.keys.get(ProfileMapViewTest.this.r.nextInt(200));
            switch (this.mode) {
                case PUT: {
                    ProfileMapViewTest.this.map.put(key, ProfileMapViewTest.this.getRandomString());
                    break;
                }
                case GET: {
                    ProfileMapViewTest.this.map.get(key);
                    break;
                }
                case REMOVE: {
                    ProfileMapViewTest.this.map.remove(key);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        PUT,
        GET,
        REMOVE;

    }
}

