/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.replicated;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.event.NodeEvent;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="replicated.SyncCacheListenerTest")
public class SyncCacheListenerTest {
    private CacheSPI<Object, Object> cache1;
    private CacheSPI<Object, Object> cache2;
    private static final Log log_ = LogFactory.getLog(SyncCacheListenerTest.class);
    private static final String FACTORY = "org.jboss.cache.transaction.DummyContextFactory";

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        System.out.println("*** starting setUp()");
        System.setProperty("java.naming.factory.initial", FACTORY);
        this.initCaches();
        System.out.println("*** finished setUp()");
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        System.out.println("*** starting tearDown()");
        TestingUtil.killTransaction((TransactionManager)DummyTransactionManager.getInstance());
        this.destroyCaches();
        System.out.println("*** finished tearDown()");
    }

    private void initCaches() {
        Configuration conf1 = new Configuration();
        Configuration conf2 = new Configuration();
        conf1.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        conf2.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        conf1.setIsolationLevel(IsolationLevel.SERIALIZABLE);
        conf2.setIsolationLevel(IsolationLevel.SERIALIZABLE);
        conf1.setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        conf2.setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        conf1.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        conf2.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        conf1.setLockAcquisitionTimeout(5000L);
        conf2.setLockAcquisitionTimeout(5000L);
        this.cache1 = (CacheSPI)new UnitTestCacheFactory().createCache(conf1, false);
        this.cache2 = (CacheSPI)new UnitTestCacheFactory().createCache(conf2, false);
        this.cache1.start();
        this.cache2.start();
    }

    private void destroyCaches() {
        TestingUtil.killCaches(new Cache[]{this.cache1, this.cache2});
        this.cache1 = null;
        this.cache2 = null;
    }

    public void testSyncTxRepl() throws Exception {
        TransactionManager tm = this.cache1.getTransactionManager();
        tm.begin();
        Transaction tx = tm.getTransaction();
        Listener lis = new Listener();
        this.cache1.getNotifier().addCacheListener((Object)lis);
        lis.put("/a/b/c", "age", 38);
        tm.suspend();
        AssertJUnit.assertNull((String)"age on cache2 must be null as the TX has not yet been committed", (Object)this.cache2.get("/a/b/c", (Object)"age"));
        tm.resume(tx);
        tm.commit();
        Integer age = (Integer)this.cache2.get("/a/b/c", (Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertTrue((String)"\"age\" must be 38", (age == 38 ? 1 : 0) != 0);
    }

    public void testRemoteCacheListener() throws Exception {
        RemoteListener lis = new RemoteListener();
        this.cache2.getNotifier().addCacheListener((Object)lis);
        this.cache1.put("/a/b/c", (Object)"age", (Object)38);
        Integer age = (Integer)this.cache2.get("/a/b/c", (Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertTrue((String)"\"age\" must be 38", (age == 38 ? 1 : 0) != 0);
        this.cache1.remove("/a/b/c", (Object)"age");
    }

    public void testSyncRepl() throws Exception {
        Listener lis = new Listener();
        this.cache1.addCacheListener((Object)lis);
        lis.put("/a/b/c", "age", 38);
        Integer age = (Integer)this.cache2.get("/a/b/c", (Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertTrue((String)"\"age\" must be 38", (age == 38 ? 1 : 0) != 0);
    }

    public void testSyncTxReplMap() throws Exception {
        TransactionManager tm = this.cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        tm.begin();
        Transaction tx = tm.getTransaction();
        Listener lis = new Listener();
        this.cache1.getNotifier().addCacheListener((Object)lis);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("age", 38);
        map.put("name", "Ben");
        lis.put("/a/b/c", map);
        tm.suspend();
        AssertJUnit.assertNull((String)"age on cache2 must be null as the TX has not yet been committed", (Object)this.cache2.get("/a/b/c", (Object)"age"));
        tm.resume(tx);
        tm.commit();
        Integer age = (Integer)this.cache2.get("/a/b/c", (Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertTrue((String)"\"age\" must be 38", (age == 38 ? 1 : 0) != 0);
    }

    public void testSyncReplMap() throws Exception {
        Listener lis = new Listener();
        this.cache1.getNotifier().addCacheListener((Object)lis);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("age", 38);
        map.put("name", "Ben");
        lis.put("/a/b/c", map);
        Integer age = (Integer)this.cache2.get("/a/b/c", (Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertTrue((String)"\"age\" must be 38", (age == 38 ? 1 : 0) != 0);
    }

    @CacheListener
    public class RemoteListener {
        @NodeRemoved
        @NodeModified
        public void callback(NodeEvent e) {
            System.out.println("Callback got event " + e);
            log_.debug((Object)("Callback got event " + e));
            AssertJUnit.assertFalse((String)"node was removed on remote cache so isLocal should be false", (boolean)e.isOriginLocal());
        }
    }

    @CacheListener
    public class Listener {
        Object key_ = null;

        public void put(String fqn, Object key, Object val) {
            this.key_ = key;
            SyncCacheListenerTest.this.cache1.put(fqn, key, val);
        }

        public void put(String fqn, Map map) {
            if (map.size() == 0) {
                AssertJUnit.fail((String)"put(): map size can't be 0");
            }
            Set set = map.keySet();
            this.key_ = set.iterator().next();
            SyncCacheListenerTest.this.cache1.put(fqn, map);
        }

        @NodeModified
        public void nodeModified(NodeEvent ne) {
            if (!ne.isPre()) {
                log_.debug((Object)("nodeModified visited with fqn: " + ne.getFqn()));
                try {
                    SyncCacheListenerTest.this.cache1.get(ne.getFqn(), this.key_);
                }
                catch (CacheException e) {
                    e.printStackTrace();
                    AssertJUnit.fail((String)("nodeModified: test failed with exception: " + (Object)((Object)e)));
                }
            }
        }
    }
}

