/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.interceptors.OrderedSynchronizationHandler;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.cache.util.CachePrinter;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "transaction"}, sequential=true, testName="transaction.InvocationContextCleanupTest")
public class InvocationContextCleanupTest {
    private CacheSPI[] caches;

    private CacheSPI<?, ?> createCache(boolean optimistic) {
        Configuration c = new Configuration();
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        if (optimistic) {
            c.setNodeLockingScheme("OPTIMISTIC");
        }
        c.setClusterName("InvocationContextCleanupTest");
        c.setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        c.setLockAcquisitionTimeout(2000L);
        CacheSPI cache = (CacheSPI)new UnitTestCacheFactory().createCache(c, false);
        cache.start();
        return cache;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.caches != null) {
            for (int i = 0; i < this.caches.length; ++i) {
                if (this.caches[i] == null) continue;
                TestingUtil.killCaches(new Cache[]{this.caches[i]});
                this.caches[i] = null;
            }
            this.caches = null;
        }
    }

    public void testInvocationContextCleanupPessimistic() throws Exception {
        this.test2CachesSync(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test2CachesSync(boolean optimistic) throws Exception {
        this.caches = new CacheSPI[2];
        CacheSPI<?, ?> cache0 = this.createCache(optimistic);
        CacheSPI<?, ?> cache1 = this.createCache(optimistic);
        this.caches[0] = cache0;
        this.caches[1] = cache1;
        TestingUtil.blockUntilViewsReceived(this.caches, 2000L);
        TransactionManager mgr = this.caches[0].getTransactionManager();
        mgr.begin();
        cache0.put("/test", (Object)"x", (Object)"y");
        GlobalTransaction gtx = cache0.getTransactionTable().get(mgr.getTransaction());
        OrderedSynchronizationHandler orderedHandler = cache0.getTransactionTable().get(gtx).getOrderedSynchronizationHandler();
        orderedHandler.registerAtTail((Synchronization)new DummySynchronization(cache0, mgr));
        try {
            mgr.commit();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            throw throwable;
        }
        System.out.println(CachePrinter.printCacheLockingInfo((Cache)this.caches[0]));
        System.out.println(CachePrinter.printCacheLockingInfo((Cache)this.caches[1]));
        AssertJUnit.assertEquals((Object)"y", (Object)cache0.get("/test", (Object)"x"));
        AssertJUnit.assertEquals((Object)"y", (Object)cache0.get("/test", (Object)"x"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DummySynchronization
    implements Synchronization {
        private CacheSPI cache;
        private TransactionManager mgr;

        public DummySynchronization(CacheSPI<?, ?> cache, TransactionManager mgr) {
            this.cache = cache;
            this.mgr = mgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void beforeCompletion() {
            Transaction tx = null;
            try {
                tx = this.mgr.suspend();
            }
            catch (SystemException e) {
                throw new RuntimeException("Unable to sustend transaction! " + e.getMessage());
            }
            this.cache.put("/test", (Object)"blah", (Object)"blahblah");
            AssertJUnit.assertTrue((String)"Should fail with a lock exception!", (boolean)false);
            Object var4_4 = null;
            if (tx == null) return;
            try {
                this.mgr.resume(tx);
                return;
            }
            catch (Exception e2) {}
            return;
            {
                catch (Exception e) {
                    AssertJUnit.assertTrue((String)"Should fail!", (boolean)true);
                    Object var4_5 = null;
                    if (tx == null) return;
                    try {
                        this.mgr.resume(tx);
                        return;
                    }
                    catch (Exception e2) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (tx == null) throw throwable;
                try {
                    this.mgr.resume(tx);
                    throw throwable;
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        public void afterCompletion(int i) {
        }
    }
}

