/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.RPCManager;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.remote.ReplicateCommand;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.util.TestingUtil;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.blocks.RspFilter;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="transaction.PrepareCommitContentionTest")
public class PrepareCommitContentionTest {
    CacheSPI<Object, Object> c1;

    @BeforeMethod
    public void setUp() throws CloneNotSupportedException {
        this.c1 = (CacheSPI)new UnitTestCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC));
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.c1});
        this.c1 = null;
    }

    public void testOOBFlag() throws Exception {
        RPCManager origRpcManager;
        DelegatingRPCManager delegatingRPCManager = new DelegatingRPCManager();
        ComponentRegistry cr = TestingUtil.extractComponentRegistry(this.c1);
        delegatingRPCManager.delegate = origRpcManager = (RPCManager)cr.getComponent(RPCManager.class);
        cr.registerComponent((Object)delegatingRPCManager, RPCManager.class);
        cr.rewire();
        this.c1.getTransactionManager().begin();
        this.c1.put("/a", (Object)"k", (Object)"v");
        this.c1.getTransactionManager().commit();
        assert (delegatingRPCManager.log.get(CommitCommand.class).booleanValue()) : "Commit commands should be sent using OOB!";
        assert (!delegatingRPCManager.log.get(PrepareCommand.class).booleanValue()) : "Prepare commands should NOT be sent using OOB!";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegatingRPCManager
    implements RPCManager {
        RPCManager delegate;
        Map<Class<? extends ReplicableCommand>, Boolean> log = new HashMap<Class<? extends ReplicableCommand>, Boolean>();

        private DelegatingRPCManager() {
        }

        public void disconnect() {
            this.delegate.disconnect();
        }

        public void stop() {
            this.delegate.stop();
        }

        public void start() {
            this.delegate.start();
        }

        void logCall(ReplicableCommand command, boolean oob) {
            if (command instanceof ReplicateCommand) {
                ReplicableCommand cmd = ((ReplicateCommand)command).getSingleModification();
                this.log.put(cmd.getClass(), oob);
            }
        }

        public List<Object> callRemoteMethods(Vector<Address> recipients, ReplicableCommand cacheCommand, int mode, long timeout, RspFilter responseFilter, boolean useOutOfBandMessage) throws Exception {
            this.logCall(cacheCommand, useOutOfBandMessage);
            return this.delegate.callRemoteMethods(recipients, cacheCommand, mode, timeout, responseFilter, useOutOfBandMessage);
        }

        public List<Object> callRemoteMethods(Vector<Address> recipients, ReplicableCommand cacheCommand, int mode, long timeout, boolean useOutOfBandMessage) throws Exception {
            this.logCall(cacheCommand, useOutOfBandMessage);
            return this.delegate.callRemoteMethods(recipients, cacheCommand, mode, timeout, useOutOfBandMessage);
        }

        public List<Object> callRemoteMethods(Vector<Address> recipients, ReplicableCommand command, boolean synchronous, long timeout, boolean useOutOfBandMessage) throws Exception {
            this.logCall(command, useOutOfBandMessage);
            return this.delegate.callRemoteMethods(recipients, command, synchronous, timeout, useOutOfBandMessage);
        }

        public boolean isCoordinator() {
            return this.delegate.isCoordinator();
        }

        public Address getCoordinator() {
            return this.delegate.getCoordinator();
        }

        public Address getLocalAddress() {
            return this.delegate.getLocalAddress();
        }

        public List<Address> getMembers() {
            return this.delegate.getMembers();
        }

        public void fetchPartialState(List<Address> sources, Fqn sourceTarget, Fqn integrationTarget) throws Exception {
            this.delegate.fetchPartialState(sources, sourceTarget, integrationTarget);
        }

        public void fetchPartialState(List<Address> sources, Fqn subtree) throws Exception {
            this.delegate.fetchPartialState(sources, subtree);
        }

        public Channel getChannel() {
            return this.delegate.getChannel();
        }
    }
}

