/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction.pessimistic;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "transaction"}, sequential=true, testName="transaction.pessimistic.ConcurrentTransactionalTest")
public class ConcurrentTransactionalTest {
    private CacheSPI<Integer, String> cache;
    private Log logger_ = LogFactory.getLog(ConcurrentTransactionalTest.class);
    private static Throwable thread_ex = null;
    private static final int NUM = 10000;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
    }

    private void createCache(IsolationLevel level) {
        Configuration conf = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
        conf.setCacheMode(Configuration.CacheMode.LOCAL);
        conf.setIsolationLevel(level);
        conf.setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        conf.setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(conf);
        this.cache.put("/a/b/c", null);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
        thread_ex = null;
        TestingUtil.killTransaction(TransactionSetup.getManager());
    }

    public void testConcurrentAccessWithRWLock() throws Throwable {
        this.createCache(IsolationLevel.REPEATABLE_READ);
        this.work_();
    }

    public void testConcurrentAccessWithExclusiveLock() throws Throwable {
        this.createCache(IsolationLevel.SERIALIZABLE);
        this.work_();
    }

    private void work_() throws Throwable {
        try {
            Updater one = new Updater("Thread one");
            Updater two = new Updater("Thread two");
            long current = System.currentTimeMillis();
            one.start();
            two.start();
            one.join();
            two.join();
            if (thread_ex != null) {
                throw thread_ex;
            }
            long now = System.currentTimeMillis();
            this.log("*** Time elapsed: " + (now - current));
            System.out.println("cache content: " + this.cache.toString());
            Set keys = this.cache.getNode(Fqn.fromString((String)"/a/b/c")).getKeys();
            System.out.println("number of keys=" + keys.size());
            if (keys.size() != 10000) {
                this.scanForNullValues(keys);
                try {
                    System.out.println("size=" + keys.size());
                    LinkedList l = new LinkedList(keys);
                    Collections.sort(l);
                    System.out.println("keys: " + l);
                    for (int i = 0; i < 10000; ++i) {
                        if (l.contains(new Integer(i))) continue;
                        System.out.println("missing: " + i);
                    }
                    LinkedList<Integer> duplicates = new LinkedList<Integer>();
                    for (Integer integer : l) {
                        if (duplicates.contains(integer)) {
                            System.out.println(integer + " is a duplicate");
                            continue;
                        }
                        duplicates.add(integer);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            AssertJUnit.assertEquals((int)10000, (int)keys.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.toString());
        }
    }

    private void scanForNullValues(Set<Integer> keys) {
        for (Integer o : keys) {
            if (o != null) continue;
            System.err.println("found a null value in keys");
        }
    }

    private void log(String msg) {
        this.logger_.debug((Object)(" [" + Thread.currentThread() + "]: " + msg));
    }

    private class Updater
    extends Thread {
        private String val = null;
        private UserTransaction tx;

        public Updater(String name) {
            this.val = name;
        }

        public void run() {
            try {
                ConcurrentTransactionalTest.this.log("adding data");
                this.tx = TransactionSetup.getUserTransaction();
                for (int i = 0; i < 10000; ++i) {
                    ConcurrentTransactionalTest.this.log("adding data i=" + i);
                    this.tx.begin();
                    ConcurrentTransactionalTest.this.cache.put("/a/b/c", (Object)i, (Object)this.val);
                    this.tx.commit();
                    Updater.yield();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                thread_ex = t;
            }
        }
    }
}

