/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.Cache;
import org.jboss.cache.DataContainer;
import org.jboss.cache.DataContainerImpl;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.invocation.CacheInvocationDelegate;
import org.jboss.cache.util.Caches;
import org.jboss.cache.util.SimpleImmutableEntry;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true, testName="util.CachesTest")
public class CachesTest {
    String a = "a";
    String b = "b";
    String c = "c";
    Cache cache;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = new UnitTestCacheFactory().createCache();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCaches(this.cache);
        this.cache = null;
    }

    public void testSegment() {
        int i;
        Map m = Caches.asPartitionedMap((Cache)this.cache);
        this.testMap(m);
        m.clear();
        int c = 100;
        for (i = 0; i < c; ++i) {
            m.put(Integer.toHexString(i), "foo " + i);
        }
        for (i = 0; i < c; ++i) {
            AssertJUnit.assertEquals((Object)("foo " + i), m.get(Integer.toHexString(i)));
        }
    }

    public void testAsMap() {
        Map m = Caches.asMap((Cache)this.cache);
        this.testMap(m);
        for (Node n : this.cache.getRoot().getChildren()) {
            AssertJUnit.assertEquals((String)"/a", (String)n.getFqn().toString());
            AssertJUnit.assertEquals((Object)this.c, (Object)n.get((Object)"K"));
        }
        m.clear();
        m.put(this.a, this.a);
        this.testCollectionRemove(m.keySet());
        m.put(this.a, this.a);
        this.testCollectionRemove(m.values());
        m.put(this.a, this.a);
        this.testCollectionRemove(m.entrySet());
    }

    private void testCollectionRemove(Collection c) {
        Iterator i = c.iterator();
        AssertJUnit.assertEquals((boolean)true, (boolean)i.hasNext());
        try {
            i.remove();
            AssertJUnit.fail((String)"no next");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        i.next();
        i.remove();
        AssertJUnit.assertEquals((boolean)false, (boolean)i.hasNext());
        AssertJUnit.assertEquals((String)("C " + c), (int)0, (int)c.size());
    }

    public void testAsSimpleSet() {
        Set s = Caches.asSimpleSet((Node)this.cache.getRoot());
        this.testSet(s);
    }

    private void testSet(Set s) {
        AssertJUnit.assertEquals((int)0, (int)s.size());
        AssertJUnit.assertEquals((boolean)true, (boolean)s.add(this.a));
        AssertJUnit.assertEquals((boolean)false, (boolean)s.add(this.a));
        AssertJUnit.assertEquals((int)1, (int)s.size());
        AssertJUnit.assertEquals((String)"[a]", (String)s.toString());
        AssertJUnit.assertEquals((boolean)true, (boolean)s.contains(this.a));
        AssertJUnit.assertEquals((boolean)true, (boolean)s.remove(this.a));
        AssertJUnit.assertEquals((boolean)false, (boolean)s.remove(this.a));
        AssertJUnit.assertEquals((boolean)false, (boolean)s.contains(this.a));
        s.add(this.b);
        s.clear();
        AssertJUnit.assertEquals((boolean)false, (boolean)s.contains(this.b));
        s.add(this.c);
        Iterator i = s.iterator();
        s.add(this.a);
        s.remove(this.a);
        AssertJUnit.assertTrue((boolean)i.hasNext());
        AssertJUnit.assertEquals((Object)this.c, i.next());
        i.remove();
        AssertJUnit.assertEquals((boolean)false, (boolean)i.hasNext());
        AssertJUnit.assertEquals((int)0, (int)s.size());
        AssertJUnit.assertEquals((boolean)true, (boolean)s.isEmpty());
    }

    private void testMap(Map m) {
        AssertJUnit.assertEquals(null, (Object)m.put(this.a, this.b));
        AssertJUnit.assertEquals((Object)this.b, (Object)m.put(this.a, this.c));
        AssertJUnit.assertEquals((String)"{a=c}", (String)m.toString());
        AssertJUnit.assertEquals((int)1, (int)m.size());
        AssertJUnit.assertEquals((Object)"a", m.keySet().iterator().next());
        AssertJUnit.assertEquals((boolean)true, (boolean)m.containsKey(this.a));
        AssertJUnit.assertEquals((boolean)true, (boolean)m.containsValue(this.c));
        AssertJUnit.assertEquals((boolean)false, (boolean)m.containsValue(this.b));
        AssertJUnit.assertEquals((Object)this.c, m.remove(this.a));
        AssertJUnit.assertEquals(null, m.remove(this.a));
        AssertJUnit.assertEquals((int)0, (int)m.size());
        AssertJUnit.assertEquals((boolean)false, (boolean)m.keySet().iterator().hasNext());
        m.put(this.c, this.a);
        AssertJUnit.assertEquals((int)1, (int)m.keySet().size());
        AssertJUnit.assertEquals((int)1, (int)m.entrySet().size());
        AssertJUnit.assertEquals((int)1, (int)m.values().size());
        Iterator i = m.keySet().iterator();
        m.put(this.b, this.b);
        m.remove(this.b);
        AssertJUnit.assertEquals((boolean)true, (boolean)i.hasNext());
        AssertJUnit.assertEquals((Object)this.c, i.next());
        AssertJUnit.assertEquals((boolean)false, (boolean)i.hasNext());
        AssertJUnit.assertEquals((boolean)true, (boolean)m.keySet().contains(this.c));
        AssertJUnit.assertEquals((boolean)true, (boolean)m.entrySet().contains(new SimpleImmutableEntry((Object)this.c, (Object)this.a)));
        AssertJUnit.assertEquals((boolean)true, (boolean)m.values().contains(this.a));
        AssertJUnit.assertEquals((boolean)false, (boolean)m.keySet().contains(this.a));
        AssertJUnit.assertEquals((boolean)false, (boolean)m.entrySet().contains(new SimpleImmutableEntry((Object)this.a, (Object)this.c)));
        AssertJUnit.assertEquals((boolean)false, (boolean)m.values().contains(this.c));
        AssertJUnit.assertEquals((boolean)false, (boolean)m.isEmpty());
        m.clear();
        AssertJUnit.assertEquals((int)0, (int)m.size());
        m.put(this.a, this.a);
        m.clear();
        AssertJUnit.assertEquals((int)0, (int)m.size());
        AssertJUnit.assertEquals((boolean)true, (boolean)m.isEmpty());
    }

    public void testAsSimpleMap() {
        Map m = Caches.asSimpleMap((Node)this.cache.getRoot());
        this.testMap(m);
    }

    public void testSelector() {
        Map m = Caches.asPartitionedMap((Node)this.cache.getRoot(), (Caches.ChildSelector)new DepartmentSelector());
        Person f = new Person("Fred", this.a);
        Person g = new Person("George", this.b);
        Person h = new Person("Harry", this.b);
        m.put(f, 42);
        m.put(g, 69);
        m.put(h, 21);
        AssertJUnit.assertEquals((Object)42, m.get(f));
        AssertJUnit.assertEquals((Object)69, m.get(g));
        System.out.println(this.printDetails(this.cache));
    }

    private String printDetails(Cache c) {
        DataContainer dc = ((CacheInvocationDelegate)c).getDataContainer();
        return ((DataContainerImpl)dc).printDetails();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DepartmentSelector
    implements Caches.ChildSelector<Person> {
        public Fqn childName(Person key) {
            return Fqn.fromElements((Object[])new String[]{key.getDepartment()});
        }
    }

    public static class Person {
        String name;
        String department;

        public Person(String name, String department) {
            this.name = name;
            this.department = department;
        }

        public String getDepartment() {
            return this.department;
        }

        public String getName() {
            return this.name;
        }
    }
}

