/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TestDbPropertiesFactory {
    private static final Properties realProps = new Properties();
    private static int userIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getTestDbProperties() {
        Properties properties = realProps;
        synchronized (properties) {
            return TestDbPropertiesFactory.returnBasedOnDifferentInstance();
        }
    }

    private static Properties returnBasedOnDifferentInstance() {
        Properties toReturn = (Properties)realProps.clone();
        String jdbcUrl = toReturn.getProperty("cache.jdbc.url");
        Pattern pattern = Pattern.compile("jbossdb");
        Matcher matcher = pattern.matcher(jdbcUrl);
        boolean found = matcher.find();
        assert (found);
        String newJdbcUrl = matcher.replaceFirst("jbossdb" + userIndex++);
        System.out.println("newJdbcUrl = " + newJdbcUrl);
        toReturn.put("cache.jdbc.url", newJdbcUrl);
        return toReturn;
    }

    private static Properties returnBasedOnDifferentTables() {
        Properties toReturn = (Properties)realProps.clone();
        String tableName = toReturn.getProperty("cache.jdbc.table.name");
        int currentIndex = userIndex++;
        toReturn.setProperty("cache.jdbc.table.name", tableName + currentIndex);
        String pk = toReturn.getProperty("cache.jdbc.table.primarykey");
        toReturn.setProperty("cache.jdbc.table.primarykey", pk + currentIndex);
        return toReturn;
    }

    static {
        System.setProperty("derby.system.home", "derby");
        try {
            realProps.load(TestDbPropertiesFactory.class.getClassLoader().getResourceAsStream("cache-jdbc.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("Missing property file: cache-jdbc.properties", e);
        }
    }
}

