/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeEvicted;
import org.jboss.cache.notifications.event.NodeEvictedEvent;
import org.jboss.cache.util.internals.EvictionController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CacheListener
public class EvictionWatcher {
    Cache<?, ?> cache;
    List<Fqn> fqnsToWaitFor;
    CountDownLatch latch;
    EvictionController.Signaller signaller;

    public EvictionWatcher(Cache<?, ?> cache, Fqn ... fqnsToWaitFor) {
        this(cache, Arrays.asList(fqnsToWaitFor));
    }

    public EvictionWatcher(Cache<?, ?> cache, List<Fqn> fqnsToWaitFor) {
        this.cache = cache;
        this.fqnsToWaitFor = new ArrayList<Fqn>(fqnsToWaitFor);
        this.latch = new CountDownLatch(fqnsToWaitFor.size());
        EvictionController ec = new EvictionController(cache);
        this.signaller = ec.getEvictionThreadSignaller();
        cache.addCacheListener((Object)this);
    }

    @NodeEvicted
    public void receive(NodeEvictedEvent ee) {
        boolean xpect = false;
        if (ee.isPre() && this.fqnsToWaitFor.contains(ee.getFqn())) {
            xpect = true;
            this.fqnsToWaitFor.remove(ee.getFqn());
            this.latch.countDown();
        }
        if (ee.isPre()) {
            System.out.println("Saw " + ee.getFqn() + " was expecting? " + xpect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForEviction(long timeout, TimeUnit unit) throws InterruptedException {
        boolean bl;
        try {
            boolean evicted = this.latch.await(timeout, unit);
            this.signaller.waitForEvictionThreadCompletion(timeout, unit);
            bl = evicted;
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.cache.removeCacheListener((Object)this);
            throw throwable;
        }
        this.cache.removeCacheListener((Object)this);
        return bl;
    }
}

