/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util.license;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValidateLicenseHeaders {
    static final String COPYRIGHT_REGEX = "copyright\\s(\\(c\\))*\\s*[\\d]+(\\s*,\\s*[\\d]+|\\s*-\\s*[\\d]+)*";
    static final String DEFAULT_HEADER = "/*\n * JBoss, Home of Professional Open Source.\n * Copyright 2000 - 2008, Red Hat Middleware LLC, and individual contributors\n * as indicated by the @author tags. See the copyright.txt file in the\n * distribution for a full listing of individual contributors.\n *\n * This is free software; you can redistribute it and/or modify it\n * under the terms of the GNU Lesser General Public License as\n * published by the Free Software Foundation; either version 2.1 of\n * the License, or (at your option) any later version.\n *\n * This software is distributed in the hope that it will be useful,\n * but WITHOUT ANY WARRANTY; without even the implied warranty of\n * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU\n * Lesser General Public License for more details.\n *\n * You should have received a copy of the GNU Lesser General Public\n * License along with this software; if not, write to the Free\n * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA\n * 02110-1301 USA, or see the FSF site: http://www.fsf.org.\n */\n";
    static Logger log = Logger.getLogger("ValidateCopyrightHeaders");
    static boolean addDefaultHeader = false;
    static FileFilter dotJavaFilter = new DotJavaFilter();
    static TreeMap licenseHeaders = new TreeMap();
    static ArrayList noheaders = new ArrayList();
    static ArrayList invalidheaders = new ArrayList();
    static int totalCount;
    static int jbossCount;

    public static void main(String[] args) throws Exception {
        File jbossSrcRoot;
        if (args.length == 0 || args[0].startsWith("-h")) {
            log.info("Usage: ValidateLicenseHeaders [-addheader] src-root");
            System.exit(1);
        }
        int rootArg = 0;
        if (args.length == 2) {
            if (args[0].startsWith("-add")) {
                addDefaultHeader = true;
            } else {
                log.severe("Uknown argument: " + args[0]);
                log.info("Usage: ValidateLicenseHeaders [-addheader] src-root");
                System.exit(1);
            }
            rootArg = 1;
        }
        if (!(jbossSrcRoot = new File(args[rootArg])).exists()) {
            log.info("Src root does not exist, check " + jbossSrcRoot.getAbsolutePath());
            System.exit(1);
        }
        log.fine(licenseHeaders.toString());
        File[] files = jbossSrcRoot.listFiles(dotJavaFilter);
        log.info("Root files count: " + files.length);
        ValidateLicenseHeaders.processSourceFiles(files, 0);
        log.info("Processed " + totalCount);
        log.info("Updated jboss headers: " + jbossCount);
        log.info("Files with no headers: " + noheaders.size());
        FileWriter fw = new FileWriter("NoHeaders.txt");
        for (File file : noheaders) {
            fw.write(file.getAbsolutePath());
            fw.write(10);
        }
        fw.close();
        log.info("Files with invalid headers: " + invalidheaders.size());
        fw = new FileWriter("InvalidHeaders.txt");
        for (File file : invalidheaders) {
            fw.write(file.getAbsolutePath());
            fw.write(10);
        }
        fw.close();
        log.info("Creating HeadersSummary.txt");
        fw = new FileWriter("HeadersSummary.txt");
        for (Map.Entry entry : licenseHeaders.entrySet()) {
            String key = (String)entry.getKey();
            fw.write("+++ License type=" + key);
            fw.write(10);
            List list = (List)entry.getValue();
            for (LicenseHeader lh : list) {
                fw.write(9);
                fw.write(lh.id);
                fw.write(", count=");
                fw.write("" + lh.count);
                fw.write(10);
            }
        }
        fw.close();
    }

    public static String getElementContent(Element element) {
        if (element == null) {
            return null;
        }
        NodeList children = element.getChildNodes();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3 || child.getNodeType() == 4) {
                result.append(child.getNodeValue());
                continue;
            }
            if (child.getNodeType() == 8) continue;
            result.append(child.getFirstChild());
        }
        return result.toString().trim();
    }

    static void processSourceFiles(File[] files, int level) throws IOException {
        for (File f : files) {
            if (level == 0) {
                log.info("processing " + f);
            }
            if (f.isDirectory()) {
                File[] children = f.listFiles(dotJavaFilter);
                ValidateLicenseHeaders.processSourceFiles(children, level + 1);
                continue;
            }
            ValidateLicenseHeaders.parseHeader(f);
        }
    }

    static void parseHeader(File javaFile) throws IOException {
        ++totalCount;
        RandomAccessFile raf = new RandomAccessFile(javaFile, "rw");
        String line = raf.readLine();
        StringBuffer tmp = new StringBuffer();
        long endOfHeader = 0L;
        boolean packageOrImport = false;
        while (line != null) {
            long nextEOH = raf.getFilePointer();
            if ((line = line.trim()).startsWith("//")) {
                line = raf.readLine();
                continue;
            }
            if (line.startsWith("package") || line.startsWith("import") || line.indexOf("class") >= 0 || line.indexOf("interface") >= 0) {
                packageOrImport = true;
                break;
            }
            endOfHeader = nextEOH;
            if (line.startsWith("/**")) {
                tmp.append(line.substring(3));
            } else if (line.startsWith("/*")) {
                tmp.append(line.substring(2));
            } else if (line.startsWith("*")) {
                tmp.append(line.substring(1));
            } else {
                tmp.append(line);
            }
            tmp.append(' ');
            line = raf.readLine();
        }
        raf.close();
        if (tmp.length() == 0 || !packageOrImport) {
            ValidateLicenseHeaders.addDefaultHeader(javaFile);
            return;
        }
        String text = tmp.toString();
        text = text.replaceAll("[\\s*]+", " ");
        text = text.toLowerCase().trim();
        text = text.replaceAll(COPYRIGHT_REGEX, "...");
        if (tmp.length() == 0) {
            System.out.println("adding default header for " + javaFile);
            ValidateLicenseHeaders.addDefaultHeader(javaFile);
            return;
        }
        if (javaFile.toString().contains("BaseEvictionAlgorithm")) {
            System.out.println("Replacing header for " + javaFile);
            System.out.println("Existing header: " + tmp);
            System.out.println("Existing header: " + text);
            System.out.println("EOH: " + endOfHeader);
        }
        ValidateLicenseHeaders.replaceHeader(javaFile, endOfHeader);
    }

    static void replaceHeader(File javaFile, long endOfHeader) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Replacing legacy jboss header in: " + javaFile);
        }
        RandomAccessFile raf = new RandomAccessFile(javaFile, "rw");
        File bakFile = new File(javaFile.getAbsolutePath() + ".bak");
        FileOutputStream fos = new FileOutputStream(bakFile);
        fos.write(DEFAULT_HEADER.getBytes());
        FileChannel fc = raf.getChannel();
        long count = raf.length() - endOfHeader;
        fc.transferTo(endOfHeader, count, fos.getChannel());
        fc.close();
        fos.close();
        raf.close();
        if (!javaFile.delete()) {
            log.severe("Failed to delete java file: " + javaFile);
        }
        if (!bakFile.renameTo(javaFile)) {
            throw new SyncFailedException("Failed to replace: " + javaFile);
        }
    }

    static void addDefaultHeader(File javaFile) throws IOException {
        if (addDefaultHeader) {
            FileInputStream fis = new FileInputStream(javaFile);
            FileChannel fc = fis.getChannel();
            int size = (int)fc.size();
            ByteBuffer contents = ByteBuffer.allocate(size);
            fc.read(contents);
            fis.close();
            ByteBuffer hdr = ByteBuffer.wrap(DEFAULT_HEADER.getBytes());
            FileOutputStream fos = new FileOutputStream(javaFile);
            fos.write(hdr.array());
            fos.write(contents.array());
            fos.close();
        }
        noheaders.add(javaFile);
    }

    static class DotJavaFilter
    implements FileFilter {
        DotJavaFilter() {
        }

        public boolean accept(File pathname) {
            boolean accept = false;
            String name = pathname.getName();
            accept = pathname.isDirectory() ? !name.equals("gen-src") && !name.equals("gen-parsers") && !name.equals(".svn") : !name.endsWith("_Stub.java") && name.endsWith(".java");
            return accept;
        }
    }

    static class LicenseHeader {
        String id;
        String text;
        int count;
        ArrayList usage = new ArrayList();

        LicenseHeader(String id, String text) {
            this.id = id;
            this.text = text;
        }
    }
}

