/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import org.jboss.cache.optimistic.DataVersion;

public class Option
implements Cloneable {
    private boolean failSilently;
    private boolean cacheModeLocal;
    private DataVersion dataVersion;
    private boolean suppressLocking;
    private boolean forceDataGravitation;
    private boolean skipDataGravitation;
    private boolean forceWriteLock;
    private boolean skipCacheStatusCheck;
    private boolean forceAsynchronous;
    private boolean forceSynchronous;
    private long syncReplTimeout = -1L;
    private int groupRequestMode = -1;
    private int lockAcquisitionTimeout = -1;
    private boolean suppressPersistence;

    public boolean isSuppressLocking() {
        return this.suppressLocking;
    }

    public void setSuppressLocking(boolean suppressLocking) {
        this.suppressLocking = suppressLocking;
    }

    public boolean isFailSilently() {
        return this.failSilently;
    }

    public void setFailSilently(boolean failSilently) {
        this.failSilently = failSilently;
    }

    public boolean isCacheModeLocal() {
        return this.cacheModeLocal;
    }

    public void setCacheModeLocal(boolean cacheModeLocal) {
        this.cacheModeLocal = cacheModeLocal;
    }

    @Deprecated
    public DataVersion getDataVersion() {
        return this.dataVersion;
    }

    @Deprecated
    public void setDataVersion(DataVersion dataVersion) {
        this.dataVersion = dataVersion;
    }

    public boolean getForceDataGravitation() {
        return this.forceDataGravitation;
    }

    public void setForceDataGravitation(boolean enableDataGravitation) {
        this.forceDataGravitation = enableDataGravitation;
    }

    public boolean isSkipDataGravitation() {
        return this.skipDataGravitation;
    }

    public void setSkipDataGravitation(boolean skipDataGravitation) {
        this.skipDataGravitation = skipDataGravitation;
    }

    public boolean isForceAsynchronous() {
        return this.forceAsynchronous;
    }

    public void setForceAsynchronous(boolean forceAsynchronous) {
        this.forceAsynchronous = forceAsynchronous;
    }

    public boolean isForceSynchronous() {
        return this.forceSynchronous;
    }

    public void setForceSynchronous(boolean forceSynchronous) {
        this.forceSynchronous = forceSynchronous;
    }

    public int getLockAcquisitionTimeout() {
        return this.lockAcquisitionTimeout;
    }

    public void setLockAcquisitionTimeout(int lockAcquisitionTimeout) {
        this.lockAcquisitionTimeout = lockAcquisitionTimeout;
    }

    public String toString() {
        return "Option{failSilently=" + this.failSilently + ", cacheModeLocal=" + this.cacheModeLocal + ", dataVersion=" + this.dataVersion + ", suppressLocking=" + this.suppressLocking + ", lockAcquisitionTimeout=" + this.lockAcquisitionTimeout + ", forceDataGravitation=" + this.forceDataGravitation + ", skipDataGravitation=" + this.skipDataGravitation + ", forceAsynchronous=" + this.forceAsynchronous + ", forceSynchronous=" + this.forceSynchronous + '}';
    }

    @Deprecated
    public Option clone() throws CloneNotSupportedException {
        return (Option)super.clone();
    }

    public Option copy() {
        try {
            return (Option)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Option option = (Option)o;
        if (this.skipDataGravitation != option.skipDataGravitation) {
            return false;
        }
        if (this.cacheModeLocal != option.cacheModeLocal) {
            return false;
        }
        if (this.failSilently != option.failSilently) {
            return false;
        }
        if (this.forceDataGravitation != option.forceDataGravitation) {
            return false;
        }
        if (this.suppressLocking != option.suppressLocking) {
            return false;
        }
        if (this.dataVersion != null ? !this.dataVersion.equals(option.dataVersion) : option.dataVersion != null) {
            return false;
        }
        if (this.forceWriteLock != option.forceWriteLock) {
            return false;
        }
        if (this.forceAsynchronous != option.forceAsynchronous) {
            return false;
        }
        if (this.forceSynchronous != option.forceSynchronous) {
            return false;
        }
        if (this.lockAcquisitionTimeout != option.lockAcquisitionTimeout) {
            return false;
        }
        return this.suppressPersistence == option.suppressPersistence;
    }

    public int hashCode() {
        int result = this.failSilently ? 1 : 0;
        result = 29 * result + (this.cacheModeLocal ? 1 : 0);
        result = 29 * result + (this.dataVersion != null ? this.dataVersion.hashCode() : 0);
        result = 29 * result + (this.suppressLocking ? 1 : 0);
        result = 29 * result + (this.forceDataGravitation ? 1 : 0);
        result = 29 * result + (this.skipDataGravitation ? 1 : 0);
        result = 29 * result + (this.forceWriteLock ? 0 : 1);
        result = 29 * result + (this.forceAsynchronous ? 0 : 1);
        result = 29 * result + (this.forceSynchronous ? 0 : 1);
        result = 29 * result + this.lockAcquisitionTimeout;
        result = 29 * result + (this.suppressPersistence ? 0 : 1);
        return result;
    }

    public void reset() {
        this.skipDataGravitation = false;
        this.cacheModeLocal = false;
        this.failSilently = false;
        this.forceDataGravitation = false;
        this.suppressLocking = false;
        this.dataVersion = null;
        this.forceWriteLock = false;
        this.forceAsynchronous = false;
        this.forceSynchronous = false;
        this.lockAcquisitionTimeout = -1;
        this.suppressPersistence = false;
    }

    public void setForceWriteLock(boolean forceWriteLock) {
        this.forceWriteLock = forceWriteLock;
    }

    public boolean isForceWriteLock() {
        return this.forceWriteLock;
    }

    public void setSkipCacheStatusCheck(boolean skipCacheStatusCheck) {
        this.skipCacheStatusCheck = skipCacheStatusCheck;
    }

    public boolean isSkipCacheStatusCheck() {
        return this.skipCacheStatusCheck;
    }

    public long getSyncReplTimeout() {
        return this.syncReplTimeout;
    }

    public void setSyncReplTimeout(long syncReplTimeout) {
        this.syncReplTimeout = syncReplTimeout;
    }

    public int getGroupRequestMode() {
        return this.groupRequestMode;
    }

    public void setGroupRequestMode(int groupRequestMode) {
        this.groupRequestMode = groupRequestMode;
    }

    public boolean isSuppressPersistence() {
        return this.suppressPersistence;
    }

    public void setSuppressPersistence(boolean suppressPersistence) {
        this.suppressPersistence = suppressPersistence;
    }
}

