/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.cache.pojo.notification;


import static org.testng.AssertJUnit.assertEquals;
import static org.testng.AssertJUnit.assertSame;

import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Configuration.CacheMode;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.PojoCacheFactory;
import org.jboss.cache.pojo.notification.event.Event;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

//$Id: ReplicatedSetTest.java 6747 2008-09-17 23:24:20Z jason.greene@jboss.com $

/**
 * Tests replicated set notifications
 *
 * @author Jason T. Greene
 */
@Test(groups = {"functional"})
public class ReplicatedSetTest extends SetTest
{
   private PojoCache listenerCache;

   @BeforeMethod(alwaysRun = true)
   protected void setUp() throws Exception
   {
      Configuration config = UnitTestCacheConfigurationFactory.createConfiguration(CacheMode.REPL_SYNC);
      config.setFetchInMemoryState(false);
      config.setSyncCommitPhase(true);
      Configuration config2 = UnitTestCacheConfigurationFactory.createConfiguration(CacheMode.REPL_SYNC);
      config2.setFetchInMemoryState(false);
      config2.setSyncCommitPhase(true);
      cache = PojoCacheFactory.createCache(config, false);
      cache.start();
      listenerCache = PojoCacheFactory.createCache(config2, false);
      listenerCache.start();
      listenerCache.addListener(listener);
   }

   @AfterMethod(alwaysRun = true)
   protected void tearDown() throws Exception
   {
      cache.stop();
      listenerCache.stop();
      listener.clear();
   }

   protected void verifyNotification(Event notification)
   {
      assertSame(listenerCache, notification.getContext().getPojoCache());
      assertEquals(false, notification.isLocal());
   }


}
