/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.io.IOException;
import java.io.Serializable;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.engine.EntityInfo;
import org.hibernate.search.engine.SearchFactoryImplementor;

public class DocumentExtractor {
    private final SearchFactoryImplementor searchFactoryImplementor;
    private final String[] projection;
    private final IndexSearcher searcher;
    private final Query preparedQuery;

    public DocumentExtractor(Query preparedQuery, IndexSearcher searcher, SearchFactoryImplementor searchFactoryImplementor, String ... projection) {
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.projection = projection;
        this.searcher = searcher;
        this.preparedQuery = preparedQuery;
    }

    private EntityInfo extract(Document document) {
        Class clazz = DocumentBuilder.getDocumentClass(document);
        Serializable id = DocumentBuilder.getDocumentId(this.searchFactoryImplementor, clazz, document);
        Object[] projected = null;
        if (this.projection != null && this.projection.length > 0) {
            projected = DocumentBuilder.getDocumentFields(this.searchFactoryImplementor, clazz, document, this.projection);
        }
        EntityInfo entityInfo = new EntityInfo(clazz, id, projected);
        return entityInfo;
    }

    public EntityInfo extract(Hits hits, int index) throws IOException {
        Document doc = hits.doc(index);
        EntityInfo entityInfo = this.extract(doc);
        Object[] eip = entityInfo.projection;
        if (eip != null && eip.length > 0) {
            for (int x = 0; x < this.projection.length; ++x) {
                if ("__HSearch_Score".equals(this.projection[x])) {
                    eip[x] = Float.valueOf(hits.score(index));
                    continue;
                }
                if ("__HSearch_id".equals(this.projection[x])) {
                    eip[x] = entityInfo.id;
                    continue;
                }
                if ("__HSearch_Document".equals(this.projection[x])) {
                    eip[x] = doc;
                    continue;
                }
                if ("__HSearch_DocumentId".equals(this.projection[x])) {
                    eip[x] = hits.id(index);
                    continue;
                }
                if ("__HSearch_Boost".equals(this.projection[x])) {
                    eip[x] = Float.valueOf(doc.getBoost());
                    continue;
                }
                if ("__HSearch_Explanation".equals(this.projection[x])) {
                    eip[x] = this.searcher.explain(this.preparedQuery, hits.id(index));
                    continue;
                }
                if (!"__HSearch_This".equals(this.projection[x])) continue;
                entityInfo.indexesOfThis.add(x);
            }
        }
        return entityInfo;
    }
}

