/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.EnumSet;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNode<K, V> {
    protected Map<Object, Node<K, V>> children;
    protected Fqn<?> fqn;
    protected final EnumSet<NodeFlags> flags = EnumSet.noneOf(NodeFlags.class);

    public boolean isDeleted() {
        return this.flags.contains((Object)NodeFlags.DELETED);
    }

    public void markAsDeleted(boolean marker) {
        this.markAsDeleted(marker, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsDeleted(boolean marker, boolean recursive) {
        this.setFlag(NodeFlags.DELETED, marker);
        if (recursive && this.children != null) {
            AbstractNode abstractNode = this;
            synchronized (abstractNode) {
                for (Node<K, V> child : this.children.values()) {
                    ((NodeSPI)child).markAsDeleted(marker, true);
                }
            }
        }
    }

    public void setResident(boolean resident) {
        this.setFlag(NodeFlags.RESIDENT, resident);
    }

    public boolean isResident() {
        return this.flags.contains((Object)NodeFlags.RESIDENT);
    }

    public boolean equals(Object another) {
        if (another instanceof AbstractNode) {
            AbstractNode anotherNode = (AbstractNode)another;
            return this.fqn == null && anotherNode.fqn == null || this.fqn != null && anotherNode.fqn != null && this.fqn.equals(anotherNode.fqn);
        }
        return false;
    }

    public int hashCode() {
        return this.fqn.hashCode();
    }

    protected void setFlag(NodeFlags flag, boolean status) {
        if (status) {
            this.flags.add(flag);
        } else {
            this.flags.remove((Object)flag);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeFlags {
        CHILDREN_LOADED,
        DATA_LOADED,
        LOCK_FOR_CHILD_INSERT_REMOVE,
        VALID,
        DELETED,
        RESIDENT,
        MODIFIED_IN_WORKSPACE,
        CREATED_IN_WORKSPACE,
        CHILDREN_MODIFIED_IN_WORKSPACE,
        VERSIONING_IMPLICIT,
        RESURRECTED_IN_WORKSPACE;

    }
}

