/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.FqnComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class Fqn<E>
implements Cloneable,
Externalizable,
Comparable<Fqn<?>> {
    public static final String SEPARATOR = "/";
    private static final long serialVersionUID = -5351930616956603651L;
    private static final Log log = LogFactory.getLog(Fqn.class);
    protected List<E> elements;
    private transient int hash_code = 0;
    protected int size = 0;
    public static final Fqn ROOT = new Fqn(true);
    protected String stringRepresentation;

    protected Fqn(boolean internalMarker) {
        this.elements = Collections.emptyList();
        this.size = 0;
    }

    protected Fqn(boolean internalMarker, List<?> names, boolean safe) {
        if (names != null) {
            ArrayList arrayList = this.elements = safe ? names : new ArrayList(names);
            if (this.elements.size() > 0) {
                if (SEPARATOR.equals(this.elements.get(0))) {
                    this.elements.remove(0);
                }
                if ("".equals(this.elements.get(0))) {
                    this.elements.remove(0);
                }
            }
            this.size = this.elements.size();
        } else {
            this.elements = Collections.emptyList();
            this.size = 0;
        }
    }

    protected Fqn(boolean internalMarker, Fqn<?> base, List<?> relative) {
        ArrayList<Object> elements = new ArrayList<Object>(base.elements.size() + relative.size());
        elements.addAll(base.elements);
        elements.addAll(relative);
        this.elements = elements;
        this.size = elements.size();
    }

    @Deprecated
    public Fqn() {
        this(true);
    }

    @Deprecated
    public Fqn(List<E> names) {
        this(true, names, false);
    }

    public static <E> Fqn<E> fromList(List<E> names) {
        return new Fqn<E>(true, names, false);
    }

    @Deprecated
    public Fqn(List<E> names, boolean safe) {
        this(true, names, safe);
    }

    @Deprecated
    public Fqn(E ... names) {
        this(true, Arrays.asList(names), true);
    }

    public static <E> Fqn<E> fromElements(E ... elements) {
        return new Fqn<E>(true, Arrays.asList(elements), true);
    }

    @Deprecated
    public Fqn(Fqn<E> base, Fqn<E> relative) {
        this(true, base, relative.elements);
    }

    public static Fqn<Object> fromRelativeFqn(Fqn<?> base, Fqn<?> relative) {
        return new Fqn<Object>(true, base, relative.elements);
    }

    @Deprecated
    public Fqn(Fqn<E> base, List<E> relative) {
        this(true, base, relative);
    }

    public static Fqn<Object> fromRelativeList(Fqn<?> base, List<?> relativeElements) {
        return new Fqn<Object>(true, base, relativeElements);
    }

    @Deprecated
    public Fqn(Fqn<E> base, E ... childNames) {
        this(true, base, Arrays.asList(childNames));
    }

    public static Fqn<Object> fromRelativeElements(Fqn<?> base, Object ... relativeElements) {
        return new Fqn<Object>(true, base, Arrays.asList(relativeElements));
    }

    public static Fqn<String> fromString(String stringRepresentation) {
        if (stringRepresentation == null || stringRepresentation.equals(SEPARATOR)) {
            return ROOT;
        }
        List<String> elements = Arrays.asList(stringRepresentation.split(SEPARATOR));
        return new Fqn<String>(true, elements, false);
    }

    public static Fqn<Object> fromExternalStream(ObjectInput in) throws IOException, ClassNotFoundException {
        Fqn<Object> f = new Fqn<Object>(true);
        f.readExternal(in);
        return f;
    }

    public Fqn<E> getAncestor(int generation) {
        if (generation == 0) {
            return Fqn.root();
        }
        return this.getSubFqn(0, generation);
    }

    public Fqn<E> getSubFqn(int startIndex, int endIndex) {
        List<E> el = this.elements.subList(startIndex, endIndex);
        return new Fqn<E>(true, el, true);
    }

    public int size() {
        return this.size;
    }

    public E get(int n) {
        return this.elements.get(n);
    }

    public E getLastElement() {
        if (this.isRoot()) {
            return null;
        }
        return this.elements.get(this.size - 1);
    }

    public boolean hasElement(E element) {
        return this.elements.indexOf(element) != -1;
    }

    public Fqn<E> clone() throws CloneNotSupportedException {
        try {
            return (Fqn)super.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error((Object)("Unable to clone Fqn " + this), (Throwable)e);
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Fqn)) {
            return false;
        }
        Fqn other = (Fqn)obj;
        return this.size == other.size() && ((Object)this.elements).equals(other.elements);
    }

    public int hashCode() {
        if (this.hash_code == 0) {
            this.hash_code = this.calculateHashCode();
        }
        return this.hash_code;
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            this.stringRepresentation = this.getStringRepresentation(this.elements);
        }
        return this.stringRepresentation;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this.size);
        for (E element : this.elements) {
            out.writeObject(element);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readShort();
        this.elements = new ArrayList(this.size);
        for (int i = 0; i < this.size; ++i) {
            Object e = in.readObject();
            this.elements.add(e);
        }
    }

    public boolean isChildOf(Fqn<E> parentFqn) {
        return parentFqn.size() != this.size && this.isChildOrEquals(parentFqn);
    }

    public boolean isChildOrEquals(Fqn<E> parentFqn) {
        List<E> parentList = parentFqn.elements;
        if (parentList.size() > this.size) {
            return false;
        }
        for (int i = parentList.size() - 1; i >= 0; --i) {
            if (parentList.get(i).equals(this.elements.get(i))) continue;
            return false;
        }
        return true;
    }

    protected int calculateHashCode() {
        int hashCode = 0;
        int count = 1;
        for (E element : this.elements) {
            E o = element;
            hashCode += o == null ? 0 : o.hashCode() * count++;
        }
        if (hashCode == 0) {
            hashCode = 65261;
        }
        return hashCode;
    }

    protected String getStringRepresentation(List elements) {
        StringBuilder builder = new StringBuilder();
        for (Object e : elements) {
            if (SEPARATOR.equals(e) || "".equals(e)) continue;
            builder.append(SEPARATOR);
            builder.append(e);
        }
        return builder.length() == 0 ? SEPARATOR : builder.toString();
    }

    public Fqn<E> getParent() {
        switch (this.size) {
            case 0: 
            case 1: {
                return Fqn.root();
            }
        }
        return new Fqn<E>(true, this.elements.subList(0, this.size - 1), true);
    }

    public static <T> Fqn<T> root() {
        return ROOT;
    }

    public boolean isRoot() {
        return this.size == 0;
    }

    public String getLastElementAsString() {
        if (this.isRoot()) {
            return SEPARATOR;
        }
        E last = this.getLastElement();
        if (last instanceof String) {
            return (String)last;
        }
        return String.valueOf(this.getLastElement());
    }

    public List<E> peekElements() {
        return this.elements;
    }

    @Override
    public int compareTo(Fqn<?> Fqn2) {
        return FqnComparator.INSTANCE.compare(this, Fqn2);
    }
}

