/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.jboss.cache.eviction.EvictionListEntry;
import org.jboss.cache.eviction.NodeEntry;

public class EvictionQueueList {
    EvictionListEntry head = null;
    EvictionListEntry tail = null;
    int modCount = 0;
    private int size = 0;

    EvictionQueueList() {
    }

    void addToTop(EvictionListEntry entry) {
        EvictionListEntry formerHead = this.head;
        this.head = entry;
        if (formerHead != null) {
            formerHead.previous = this.head;
            this.head.next = formerHead;
            this.head.previous = null;
        } else {
            this.tail = entry;
        }
        ++this.size;
        ++this.modCount;
    }

    void addToBottom(EvictionListEntry entry) {
        EvictionListEntry formerTail = this.tail;
        this.tail = entry;
        if (formerTail != null) {
            this.tail.previous = formerTail;
            formerTail.next = this.tail;
            this.tail.next = null;
        } else {
            this.head = entry;
        }
        ++this.size;
        ++this.modCount;
    }

    void remove(EvictionListEntry entry) {
        if (this.isEmpty()) {
            return;
        }
        if (this.isSingleNode(entry)) {
            this.head = null;
            this.tail = null;
        } else if (this.isTail(entry)) {
            this.tail = entry.previous;
            entry.previous.next = null;
        } else if (this.isHead(entry)) {
            this.head = entry.next;
            this.head.previous = null;
        } else {
            entry.next.previous = entry.previous;
            entry.previous.next = entry.next;
        }
        --this.size;
        ++this.modCount;
    }

    int size() {
        return this.size;
    }

    void clear() {
        this.head = null;
        this.tail = null;
        this.size = 0;
        ++this.modCount;
    }

    EvictionListEntry getFirst() {
        if (this.head == null) {
            throw new NoSuchElementException("List is empty");
        }
        return this.head;
    }

    EvictionListEntry getLast() {
        if (this.tail == null) {
            throw new NoSuchElementException("List is empty");
        }
        return this.tail;
    }

    Iterator iterator() {
        return new EvictionListIterator();
    }

    NodeEntry[] toNodeEntryArray() {
        if (this.isEmpty()) {
            return null;
        }
        NodeEntry[] ret = new NodeEntry[this.size];
        int i = 0;
        EvictionListEntry temp = this.head;
        do {
            ret[i] = temp.node;
            temp = temp.next;
            ++i;
        } while (temp != null);
        return ret;
    }

    EvictionListEntry[] toArray() {
        if (this.isEmpty()) {
            return null;
        }
        EvictionListEntry[] ret = new EvictionListEntry[this.size];
        int i = 0;
        EvictionListEntry temp = this.head;
        do {
            ret[i] = temp;
            temp = temp.next;
            ++i;
        } while (temp != null);
        return ret;
    }

    void fromArray(EvictionListEntry[] evictionListEntries) {
        for (EvictionListEntry evictionListEntry : evictionListEntries) {
            this.addToBottom(evictionListEntry);
        }
    }

    private boolean isEmpty() {
        return this.head == null && this.tail == null;
    }

    private boolean isSingleNode(EvictionListEntry entry) {
        return this.isTail(entry) && this.isHead(entry);
    }

    private boolean isTail(EvictionListEntry entry) {
        return entry.next == null;
    }

    private boolean isHead(EvictionListEntry entry) {
        return entry.previous == null;
    }

    public String toString() {
        return Arrays.asList(this.toArray()).toString();
    }

    class EvictionListIterator
    implements ListIterator {
        EvictionListEntry next;
        EvictionListEntry previous;
        EvictionListEntry cursor;
        int initialModCount;

        EvictionListIterator() {
            this.next = EvictionQueueList.this.head;
            this.initialModCount = EvictionQueueList.this.modCount;
        }

        public boolean hasNext() {
            this.doConcurrentModCheck();
            return this.next != null;
        }

        public Object next() {
            this.doConcurrentModCheck();
            this.forwardCursor();
            return this.cursor.node;
        }

        public boolean hasPrevious() {
            this.doConcurrentModCheck();
            return this.previous != null;
        }

        public Object previous() {
            this.doConcurrentModCheck();
            this.rewindCursor();
            return this.cursor.node;
        }

        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            this.doConcurrentModCheck();
            if (this.cursor == null) {
                throw new IllegalStateException("Cannot remove from iterator when there is nothing at the current iteration point");
            }
            EvictionQueueList.this.remove(this.cursor);
            this.cursor = null;
            ++this.initialModCount;
        }

        public void set(Object o) {
            this.doConcurrentModCheck();
            this.cursor.node = (NodeEntry)o;
        }

        public void add(Object o) {
            this.doConcurrentModCheck();
            ++this.initialModCount;
        }

        private void doConcurrentModCheck() {
            if (EvictionQueueList.this.modCount != this.initialModCount) {
                throw new ConcurrentModificationException();
            }
        }

        private void forwardCursor() {
            if (this.next == null) {
                throw new NoSuchElementException("No more objects to iterate.");
            }
            this.previous = this.cursor;
            this.cursor = this.next;
            this.next = this.cursor.next;
        }

        private void rewindCursor() {
            if (this.previous == null) {
                throw new NoSuchElementException();
            }
            this.next = this.cursor;
            this.cursor = this.previous;
            this.previous = this.cursor.previous;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EvictionListComparator
    implements Comparator<EvictionListEntry> {
        Comparator<NodeEntry> nodeEntryComparator;

        EvictionListComparator(Comparator<NodeEntry> nodeEntryComparator) {
            this.nodeEntryComparator = nodeEntryComparator;
        }

        @Override
        public int compare(EvictionListEntry e1, EvictionListEntry e2) {
            return this.nodeEntryComparator.compare(e1.node, e2.node);
        }
    }
}

