/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.marshall.NodeDataExceptionMarker;
import org.jboss.cache.marshall.NodeDataMarker;
import org.jboss.cache.util.MapCopy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCacheLoader
implements CacheLoader {
    protected CacheSPI cache;
    protected RegionManager regionManager;
    private static final Log log = LogFactory.getLog(AbstractCacheLoader.class);
    private static final boolean trace = log.isTraceEnabled();
    protected BuddyFqnTransformer buddyFqnTransformer = new BuddyFqnTransformer();
    protected Map<Object, List<Modification>> transactions = new ConcurrentHashMap<Object, List<Modification>>();

    public void put(Fqn fqn, Map<Object, Object> attributes, boolean erase) throws Exception {
        if (erase) {
            this.removeData(fqn);
        }
        MapCopy<Object, Object> attrs = attributes == null ? null : new MapCopy<Object, Object>(attributes);
        this.put(fqn, attrs);
    }

    @Override
    public void storeEntireState(ObjectInputStream is) throws Exception {
        this.storeState(Fqn.ROOT, is);
    }

    @Override
    public void storeState(Fqn subtree, ObjectInputStream in) throws Exception {
        this.remove(subtree);
        boolean moveToBuddy = subtree.isChildOf(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN) && subtree.size() > 1;
        Object objectFromStream = this.cache.getMarshaller().objectFromObjectStream(in);
        if (objectFromStream instanceof NodeDataMarker) {
            return;
        }
        if (objectFromStream instanceof NodeDataExceptionMarker) {
            NodeDataExceptionMarker ndem = (NodeDataExceptionMarker)objectFromStream;
            throw new CacheException("State provider cacheloader at node " + ndem.getCacheNodeIdentity() + " threw exception during loadState (see Caused by)", ndem.getCause());
        }
        List nodeData = (List)objectFromStream;
        for (Object aNodeData : nodeData) {
            NodeData nd = (NodeData)aNodeData;
            if (!nd.isExceptionMarker()) continue;
            NodeDataExceptionMarker ndem = (NodeDataExceptionMarker)nd;
            throw new CacheException("State provider cacheloader at node " + ndem.getCacheNodeIdentity() + " threw exception during loadState (see Caused by)", ndem.getCause());
        }
        this.storeStateHelper(subtree, nodeData, moveToBuddy);
    }

    protected void storeStateHelper(Fqn subtree, List nodeData, boolean moveToBuddy) throws Exception {
        Object aNodeData;
        NodeData nd;
        Iterator i$ = nodeData.iterator();
        while (i$.hasNext() && !(nd = (NodeData)(aNodeData = i$.next())).isMarker()) {
            Fqn fqn = moveToBuddy ? this.buddyFqnTransformer.getBackupFqn(subtree, nd.getFqn()) : nd.getFqn();
            if (nd.getAttributes() != null) {
                this.put(fqn, nd.getAttributes(), true);
                continue;
            }
            this.put(fqn, null);
        }
    }

    @Override
    public void loadEntireState(ObjectOutputStream os) throws Exception {
        this.loadState(Fqn.ROOT, os);
    }

    @Override
    public void loadState(Fqn subtree, ObjectOutputStream os) throws Exception {
        this.loadStateHelper(subtree, os);
    }

    @Override
    public void setCache(CacheSPI c) {
        this.cache = c;
    }

    @Override
    public void setRegionManager(RegionManager regionManager) {
        this.regionManager = regionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void regionAwareMarshall(Fqn fqn, Object toMarshall) throws Exception {
        Region r = this.regionManager == null ? null : this.regionManager.getRegion(fqn, Region.Type.MARSHALLING, false);
        ClassLoader originalClassLoader = null;
        boolean needToResetLoader = false;
        Thread current = null;
        if (r != null) {
            needToResetLoader = true;
            current = Thread.currentThread();
            originalClassLoader = current.getContextClassLoader();
            current.setContextClassLoader(r.getClassLoader());
        }
        try {
            this.doMarshall(fqn, toMarshall);
        }
        finally {
            if (needToResetLoader) {
                current.setContextClassLoader(originalClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object regionAwareUnmarshall(Fqn fqn, Object toUnmarshall) throws Exception {
        Region r = this.regionManager == null ? null : this.regionManager.getRegion(fqn, Region.Type.MARSHALLING, false);
        ClassLoader originalClassLoader = null;
        boolean needToResetLoader = false;
        Thread current = null;
        if (r != null) {
            if (trace) {
                log.trace((Object)("Using region " + r.getFqn() + ", which has registered class loader " + r.getClassLoader() + " as a context class loader."));
            }
            needToResetLoader = true;
            current = Thread.currentThread();
            originalClassLoader = current.getContextClassLoader();
            current.setContextClassLoader(r.getClassLoader());
        }
        try {
            Object object = this.doUnmarshall(fqn, toUnmarshall);
            if (needToResetLoader) {
                current.setContextClassLoader(originalClassLoader);
            }
            return object;
        }
        catch (Throwable throwable) {
            if (needToResetLoader) {
                current.setContextClassLoader(originalClassLoader);
            }
            throw throwable;
        }
    }

    protected void doMarshall(Fqn fqn, Object toMarshall) throws Exception {
        throw new RuntimeException("Should be overridden");
    }

    protected Object doUnmarshall(Fqn fqn, Object toUnmarshall) throws Exception {
        throw new RuntimeException("Should be overridden");
    }

    protected void loadStateHelper(Fqn fqn, ObjectOutputStream out) throws Exception {
        LinkedList<NodeData> list = new LinkedList<NodeData>();
        this.getNodeDataList(fqn, list);
        if (trace) {
            log.trace((Object)("Loading state of " + list.size() + " nodes into stream"));
        }
        this.cache.getMarshaller().objectToObjectStream(list, out, fqn);
    }

    protected void getNodeDataList(Fqn fqn, List<NodeData> list) throws Exception {
        Map<Object, Object> attrs = this.get(fqn);
        NodeData nd = attrs == null || attrs.size() == 0 ? new NodeData(fqn) : new NodeData(fqn, attrs);
        list.add(nd);
        Set<?> childrenNames = this.getChildrenNames(fqn);
        if (childrenNames == null) {
            return;
        }
        for (Object childrenName : childrenNames) {
            String childName = (String)childrenName;
            Fqn<Object> tmpFqn = Fqn.fromRelativeElements(fqn, childName);
            if (this.cache.getInternalFqns().contains(tmpFqn)) continue;
            this.getNodeDataList(tmpFqn, list);
        }
    }

    @Override
    public void put(List<Modification> modifications) throws Exception {
        block9: for (Modification m : modifications) {
            switch (m.getType()) {
                case PUT_DATA: {
                    this.put(m.getFqn(), m.getData());
                    continue block9;
                }
                case PUT_DATA_ERASE: {
                    this.removeData(m.getFqn());
                    this.put(m.getFqn(), m.getData());
                    continue block9;
                }
                case PUT_KEY_VALUE: {
                    this.put(m.getFqn(), m.getKey(), m.getValue());
                    continue block9;
                }
                case REMOVE_DATA: {
                    this.removeData(m.getFqn());
                    continue block9;
                }
                case REMOVE_KEY_VALUE: {
                    this.remove(m.getFqn(), m.getKey());
                    continue block9;
                }
                case REMOVE_NODE: {
                    this.remove(m.getFqn());
                    continue block9;
                }
                case MOVE: {
                    this._move(m.getFqn(), m.getFqn2());
                    continue block9;
                }
            }
            throw new CacheException("Unknown modificatiobn " + (Object)((Object)m.getType()));
        }
    }

    private void _move(Fqn fqn, Fqn parent) throws Exception {
        Map<Object, Object> data;
        Object name = fqn.getLastElement();
        Fqn<Object> newFqn = Fqn.fromRelativeElements(parent, name);
        Set<?> childrenNames = this.getChildrenNames(fqn);
        if (childrenNames != null) {
            for (Object c : childrenNames) {
                this._move(Fqn.fromRelativeElements(fqn, c), newFqn);
            }
        }
        if ((data = this.get(fqn)) != null) {
            this.remove(fqn);
            this.put(newFqn, data);
        }
    }

    protected Marshaller getMarshaller() {
        return this.cache.getMarshaller();
    }

    @Override
    public void create() throws Exception {
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void prepare(Object tx, List<Modification> modifications, boolean one_phase) throws Exception {
        if (one_phase) {
            this.put(modifications);
        } else {
            this.transactions.put(tx, modifications);
        }
    }

    @Override
    public void commit(Object tx) throws Exception {
        List<Modification> modifications = this.transactions.remove(tx);
        if (modifications == null) {
            throw new Exception("transaction " + tx + " not found in transaction table");
        }
        this.put(modifications);
    }

    @Override
    public void rollback(Object tx) {
        this.transactions.remove(tx);
    }
}

