/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.HashMap;
import java.util.List;
import javax.transaction.Status;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.factories.CommandsFactory;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.statetransfer.StateTransferManager;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;
import org.jboss.cache.transaction.TransactionTable;

public abstract class LockUtil {
    private static final Log log = LogFactory.getLog(StateTransferManager.class);
    private static final boolean trace = log.isTraceEnabled();

    public static boolean breakTransactionLock(NodeSPI node, LockManager lockManager, GlobalTransaction gtx, boolean localTx, TransactionTable tx_table, TransactionManager tm) {
        boolean broken = false;
        int tryCount = 0;
        int lastStatus = Integer.MIN_VALUE;
        while (!broken && lockManager.ownsLock(node.getFqn(), (Object)gtx)) {
            int status = LockUtil.breakTransactionLock(gtx, node, lockManager, tx_table, tm, localTx, lastStatus, tryCount);
            if (status == Integer.MIN_VALUE) {
                broken = true;
            } else if (status != lastStatus) {
                tryCount = 0;
            }
            lastStatus = status;
            ++tryCount;
        }
        return broken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int breakTransactionLock(GlobalTransaction gtx, NodeSPI node, LockManager lockManager, TransactionTable transactionTable, TransactionManager tm, boolean localTx, int lastStatus, int tryCount) {
        int status = 5;
        Transaction tx = transactionTable.getLocalTransaction(gtx);
        if (tx != null) {
            try {
                status = tx.getStatus();
                if (status != lastStatus) {
                    tryCount = 0;
                }
                switch (status) {
                    case 0: 
                    case 1: 
                    case 5: 
                    case 7: {
                        if (tryCount == 0) {
                            if (trace) {
                                log.trace((Object)("Attempting to break transaction lock held  by " + gtx + " by rolling back local tx"));
                            }
                            tm.resume(tx);
                            try {
                                tx.rollback();
                                break;
                            }
                            finally {
                                tm.suspend();
                            }
                        }
                        if (tryCount > 100) {
                            lockManager.unlock(node.getFqn(), (Object)gtx);
                            status = Integer.MIN_VALUE;
                        }
                        break;
                    }
                    case 8: 
                    case 9: {
                        if (tryCount < 10) break;
                    }
                    case 3: 
                    case 4: 
                    case 6: {
                        lockManager.unlock(node.getFqn(), (Object)gtx);
                        status = Integer.MIN_VALUE;
                        break;
                    }
                    case 2: {
                        if (tryCount == 0 && localTx) {
                            if (trace) {
                                log.trace((Object)("Attempting to break transaction lock held by " + gtx + " by marking local tx as " + "rollback-only"));
                            }
                            tx.setRollbackOnly();
                            break;
                        }
                        if (tryCount < 10) break;
                    }
                    default: {
                        lockManager.unlock(node.getFqn(), (Object)gtx);
                        status = Integer.MIN_VALUE;
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Exception breaking locks held by " + gtx), (Throwable)e);
                lockManager.unlock(node.getFqn(), (Object)gtx);
                status = Integer.MIN_VALUE;
            }
        } else if (lockManager.ownsLock(node.getFqn(), (Object)gtx)) {
            lockManager.unlock(node.getFqn(), (Object)gtx);
            status = Integer.MIN_VALUE;
        }
        return status;
    }

    public static void manageReverseRemove(InvocationContext ctx, NodeSPI childNode, boolean reverseRemoveCheck, List createdNodes, CommandsFactory commandsFactory) {
        if (ctx.getGlobalTransaction() != null) {
            boolean needToReverseRemove;
            Fqn fqn = childNode.getFqn();
            TransactionEntry entry = ctx.getTransactionEntry();
            boolean bl = needToReverseRemove = reverseRemoveCheck && childNode.isDeleted() && entry != null && entry.getRemovedNodes().contains(fqn);
            if (!needToReverseRemove) {
                return;
            }
            childNode.markAsDeleted(false);
            HashMap oldData = new HashMap(childNode.getDataDirect());
            PutDataMapCommand command = commandsFactory.buildPutDataMapCommand(ctx.getGlobalTransaction(), fqn, oldData);
            entry.addModification(command);
            childNode.clearDataDirect();
            if (createdNodes != null) {
                createdNodes.add(childNode);
            }
        }
    }

    private static interface TransactionLockStatus
    extends Status {
        public static final int STATUS_BROKEN = Integer.MIN_VALUE;
    }
}

