/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.Domain;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.InstanceAdvisorDelegate;
import org.jboss.aop.InterceptorChainObserver;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.AdviceType;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.GeneratedAdvisorInterceptor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.metadata.SimpleMetaData;

public class GeneratedInstanceAdvisorMixin
implements InstanceAdvisor,
Serializable {
    static final long serialVersionUID = -3057976129116723527L;
    protected ArrayList<Interceptor> insertedInterceptors = null;
    protected ArrayList<Interceptor> appendedInterceptors = null;
    protected WeakReference<Object> instanceRef;
    public boolean hasInstanceAspects = false;
    private InterceptorChainObserver interceptorChainObserver;
    InstanceAdvisorDelegate delegate;

    public GeneratedInstanceAdvisorMixin() {
    }

    public GeneratedInstanceAdvisorMixin(Object instance, GeneratedClassAdvisor genadvisor) {
        this.instanceRef = new WeakReference<Object>(instance);
        this.delegate = new InstanceAdvisorDelegate(genadvisor, this);
        this.delegate.initialize();
        this.interceptorChainObserver = genadvisor.getInterceptorChainObserver();
    }

    public boolean hasInterceptors() {
        return this.appendedInterceptors != null || this.insertedInterceptors != null;
    }

    public Object getPerInstanceAspect(String def) {
        return this.delegate.getPerInstanceAspect(def);
    }

    public Object getPerInstanceAspect(AspectDefinition def) {
        return this.delegate.getPerInstanceAspect(def);
    }

    public Object getPerInstanceJoinpointAspect(Joinpoint joinpoint, AspectDefinition def) {
        return this.delegate.getPerInstanceJoinpointAspect(joinpoint, def);
    }

    public SimpleMetaData getMetaData() {
        return this.delegate.getMetaData();
    }

    public Interceptor[] getInterceptors() {
        ArrayList<Interceptor> newlist = new ArrayList<Interceptor>();
        if (this.insertedInterceptors != null && this.insertedInterceptors.size() > 0) {
            for (Interceptor icptr : this.insertedInterceptors) {
                Interceptor interceptor = ((GeneratedAdvisorInterceptor)icptr).create(null, null);
                if (interceptor == null) continue;
                newlist.add(interceptor);
            }
        }
        if (this.appendedInterceptors != null && this.appendedInterceptors.size() > 0) {
            for (Interceptor icptr : this.appendedInterceptors) {
                newlist.add(((GeneratedAdvisorInterceptor)icptr).create(null, null));
            }
        }
        return newlist.toArray(new Interceptor[newlist.size()]);
    }

    public Interceptor[] getInterceptors(Interceptor[] advisorChain) {
        if (this.insertedInterceptors == null && this.appendedInterceptors == null) {
            return advisorChain;
        }
        ArrayList<Interceptor> newlist = new ArrayList<Interceptor>();
        if (this.insertedInterceptors != null && this.insertedInterceptors.size() > 0) {
            for (Interceptor icptr : this.insertedInterceptors) {
                Interceptor interceptor = ((GeneratedAdvisorInterceptor)icptr).create(null, null);
                if (interceptor == null) continue;
                newlist.add(interceptor);
            }
        }
        if (advisorChain != null) {
            newlist.addAll(Arrays.asList(advisorChain));
        }
        if (this.appendedInterceptors != null && this.appendedInterceptors.size() > 0) {
            for (Interceptor icptr : this.appendedInterceptors) {
                newlist.add(((GeneratedAdvisorInterceptor)icptr).create(null, null));
            }
        }
        return newlist.toArray(new Interceptor[newlist.size()]);
    }

    public GeneratedAdvisorInterceptor[] getWrappers() {
        ArrayList<Interceptor> newlist = new ArrayList<Interceptor>();
        if (this.insertedInterceptors != null) {
            newlist.addAll(this.insertedInterceptors);
        }
        if (this.appendedInterceptors != null) {
            newlist.addAll(this.appendedInterceptors);
        }
        return newlist.toArray(new GeneratedAdvisorInterceptor[newlist.size()]);
    }

    public Interceptor[] getWrappers(Interceptor[] advisorChain) {
        if (this.insertedInterceptors == null && this.appendedInterceptors == null) {
            return advisorChain;
        }
        ArrayList<Interceptor> newlist = new ArrayList<Interceptor>();
        if (this.insertedInterceptors != null) {
            newlist.addAll(this.insertedInterceptors);
        }
        if (advisorChain != null) {
            newlist.addAll(Arrays.asList(advisorChain));
        }
        if (this.appendedInterceptors != null) {
            newlist.addAll(this.appendedInterceptors);
        }
        return newlist.toArray(new GeneratedAdvisorInterceptor[newlist.size()]);
    }

    public void insertInterceptor(int index, Interceptor interceptor) {
        ArrayList<Interceptor> newList = new ArrayList<Interceptor>();
        if (this.insertedInterceptors != null && this.insertedInterceptors.size() > 0) {
            newList.addAll(this.insertedInterceptors);
        }
        newList.add(index, this.createWrapper(interceptor));
        this.insertedInterceptors = newList;
        this.hasInstanceAspects = true;
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorAdded(this);
        }
    }

    public void insertInterceptor(Interceptor interceptor) {
        ArrayList<Interceptor> newList = new ArrayList<Interceptor>();
        if (this.insertedInterceptors != null && this.insertedInterceptors.size() > 0) {
            newList.addAll(this.insertedInterceptors);
        }
        newList.add(this.createWrapper(interceptor));
        this.insertedInterceptors = newList;
        this.hasInstanceAspects = true;
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorAdded(this);
        }
    }

    public void appendInterceptor(Interceptor interceptor) {
        ArrayList<Interceptor> newList = new ArrayList<Interceptor>();
        if (this.appendedInterceptors != null && this.appendedInterceptors.size() > 0) {
            newList.addAll(this.appendedInterceptors);
        }
        newList.add(this.createWrapper(interceptor));
        this.appendedInterceptors = newList;
        this.hasInstanceAspects = true;
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorAdded(this);
        }
    }

    public void appendInterceptor(int index, Interceptor interceptor) {
        ArrayList<Interceptor> newList = new ArrayList<Interceptor>();
        if (this.appendedInterceptors != null && this.appendedInterceptors.size() > 0) {
            newList.addAll(this.appendedInterceptors);
        }
        newList.add(index, this.createWrapper(interceptor));
        this.appendedInterceptors = newList;
        this.hasInstanceAspects = true;
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorAdded(this);
        }
    }

    public void removeInterceptor(String name) {
        int interceptorsRemoved = this.internalRemoveInterceptor(name);
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorsRemoved(this, interceptorsRemoved);
        }
    }

    private int internalRemoveInterceptor(String name) {
        ArrayList<Interceptor> newList;
        GeneratedAdvisorInterceptor interceptor;
        int i;
        int size;
        int interceptorsRemoved = 0;
        if (this.insertedInterceptors != null) {
            size = this.insertedInterceptors.size();
            for (i = 0; i < size; ++i) {
                interceptor = (GeneratedAdvisorInterceptor)this.insertedInterceptors.get(i);
                if (!interceptor.getName().equals(name)) continue;
                newList = new ArrayList<Interceptor>();
                newList.addAll(this.insertedInterceptors);
                newList.remove(i);
                this.insertedInterceptors = newList;
                ++interceptorsRemoved;
            }
        }
        if (this.appendedInterceptors != null) {
            size = this.appendedInterceptors.size();
            for (i = 0; i < size; ++i) {
                interceptor = (GeneratedAdvisorInterceptor)this.appendedInterceptors.get(i);
                if (!interceptor.getName().equals(name)) continue;
                newList = new ArrayList();
                newList.addAll(this.appendedInterceptors);
                newList.remove(i);
                this.appendedInterceptors = newList;
                ++interceptorsRemoved;
            }
        }
        this.hasInstanceAspects = this.insertedInterceptors != null && this.insertedInterceptors.size() > 0 || this.appendedInterceptors != null && this.appendedInterceptors.size() > 0;
        return interceptorsRemoved;
    }

    public final boolean hasAspects() {
        return this.hasInstanceAspects;
    }

    public void insertInterceptorStack(String stackName) {
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        if (stack == null) {
            throw new RuntimeException("Stack " + stackName + " not found.");
        }
        ClassAdvisor classAdvisor = null;
        Object inst = this.getInstance();
        if (inst instanceof Advised) {
            Advised advised = (Advised)inst;
            classAdvisor = (ClassAdvisor)advised._getAdvisor();
        }
        int interceptorsAdded = 0;
        for (InterceptorFactory factory : stack.getInterceptorFactories()) {
            Interceptor interceptor;
            if (!factory.isDeployed() || (interceptor = factory.create(classAdvisor, null)) == null) continue;
            this.insertInterceptor(interceptor);
            ++interceptorsAdded;
        }
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorsAdded(this, interceptorsAdded);
        }
    }

    public void appendInterceptorStack(String stackName) {
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        if (stack == null) {
            throw new RuntimeException("Stack " + stackName + " not found.");
        }
        ClassAdvisor classAdvisor = null;
        Object inst = this.getInstance();
        if (inst instanceof Advised) {
            Advised advised = (Advised)inst;
            classAdvisor = (ClassAdvisor)advised._getAdvisor();
        }
        int interceptorsAdded = 0;
        for (InterceptorFactory factory : stack.getInterceptorFactories()) {
            Interceptor interceptor;
            if (!factory.isDeployed() || (interceptor = factory.create(classAdvisor, null)) == null) continue;
            this.appendInterceptor(interceptor);
            ++interceptorsAdded;
        }
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorsAdded(this, interceptorsAdded);
        }
    }

    public void removeInterceptorStack(String stackName) {
        AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
        if (stack == null) {
            throw new RuntimeException("Stack " + stackName + " not found.");
        }
        ClassAdvisor classAdvisor = null;
        Object inst = this.getInstance();
        if (inst instanceof Advised) {
            Advised advised = (Advised)inst;
            classAdvisor = (ClassAdvisor)advised._getAdvisor();
        }
        int interceptorsRemoved = 0;
        for (InterceptorFactory factory : stack.getInterceptorFactories()) {
            Interceptor interceptor;
            if (!factory.isDeployed() || (interceptor = factory.create(classAdvisor, null)) == null) continue;
            interceptorsRemoved += this.internalRemoveInterceptor(interceptor.getName());
        }
        if (this.interceptorChainObserver != null) {
            this.interceptorChainObserver.instanceInterceptorsRemoved(this, interceptorsRemoved);
        }
    }

    public Domain getDomain() {
        throw new RuntimeException("Should be handled by generated advisors");
    }

    protected void finalize() {
        ClassLoader classLoader = this.delegate.getAdvisor().getClazz().getClassLoader();
        if (this.interceptorChainObserver == null || !AspectManager.getRegisteredCLs().containsKey(classLoader)) {
            return;
        }
        this.interceptorChainObserver.allInstanceInterceptorsRemoved(this);
    }

    private GeneratedAdvisorInterceptor createWrapper(Interceptor interceptor) {
        return new GeneratedAdvisorInterceptor(new InstanceInterceptorFactory(interceptor), null, null);
    }

    public Object getInstance() {
        if (this.instanceRef != null) {
            Object instance = this.instanceRef.get();
            return instance;
        }
        return null;
    }

    public class InstanceInterceptorFactory
    implements InterceptorFactory {
        private Interceptor interceptor;

        private InstanceInterceptorFactory(Interceptor interceptor) {
            this.interceptor = interceptor;
        }

        public Interceptor create(Advisor advisor, Joinpoint joinpoint) {
            return this.interceptor;
        }

        public String getClassName() {
            return this.interceptor.getClass().getName();
        }

        public String getAdvice() {
            return "invoke";
        }

        public AspectDefinition getAspect() {
            return null;
        }

        public String getName() {
            return this.interceptor.getName();
        }

        public boolean isDeployed() {
            return true;
        }

        public AdviceType getType() {
            return AdviceType.AROUND;
        }
    }
}

