/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.search;

import java.util.List;
import java.util.NoSuchElementException;
import org.jboss.cache.search.CacheEntityId;
import org.jboss.cache.search.CacheEntityLoader;
import org.jboss.cache.search.QueryResultIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryResultIteratorImpl
implements QueryResultIterator {
    private int index = 0;
    private List<CacheEntityId> idList;
    private CacheEntityLoader entityLoader;
    private int lowerLimit = 0;
    private int upperLimit = 0;

    public QueryResultIteratorImpl(List<CacheEntityId> idList, CacheEntityLoader entityLoader) {
        this.idList = idList;
        this.entityLoader = entityLoader;
        this.upperLimit = idList.size() - 1;
    }

    @Override
    public void jumpToResult(int index) throws IndexOutOfBoundsException {
        if (index > this.idList.size() || index < 0) {
            throw new IndexOutOfBoundsException("The index you entered is either greater than the size of the list or negative");
        }
        this.index = index;
    }

    @Override
    public void first() {
        this.index = 0;
    }

    @Override
    public void last() {
        this.index = this.idList.size() - 1;
    }

    @Override
    public void afterFirst() {
        this.index = 1;
    }

    @Override
    public void beforeLast() {
        this.index = this.idList.size() - 2;
    }

    @Override
    public boolean isFirst() {
        return this.idList.get(this.index) == this.idList.get(0);
    }

    @Override
    public boolean isLast() {
        return this.index == this.idList.size() - 1;
    }

    @Override
    public boolean isAfterFirst() {
        return this.idList.get(this.index) == this.idList.get(1);
    }

    @Override
    public boolean isBeforeLast() {
        return this.idList.get(this.index) == this.idList.get(this.idList.size() - 2);
    }

    @Override
    public boolean hasNext() {
        return this.index <= this.upperLimit;
    }

    @Override
    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Out of boundaries");
        }
        Object toReturn = this.entityLoader.load(this.idList.get(this.index));
        ++this.index;
        return toReturn;
    }

    @Override
    public boolean hasPrevious() {
        return this.index >= this.lowerLimit;
    }

    public Object previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("Out of boundaries");
        }
        Object toReturn = this.entityLoader.load(this.idList.get(this.index));
        --this.index;
        return toReturn;
    }

    @Override
    public int nextIndex() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Out of boundaries");
        }
        return this.index + 1;
    }

    @Override
    public int previousIndex() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("Out of boundaries");
        }
        return this.index - 1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache");
    }

    public void set(Object o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache");
    }

    public void add(Object o) {
        throw new UnsupportedOperationException("Not supported as you are trying to change something in the cache");
    }
}

