/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.SynonymFilter;
import org.apache.solr.analysis.SynonymMap;
import org.apache.solr.core.Config;
import org.apache.solr.core.SolrCore;
import org.apache.solr.util.StrUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynonymFilterFactory
extends BaseTokenFilterFactory {
    private SynonymMap synMap;
    private boolean ignoreCase;
    private boolean expand;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        String synonyms = args.get("synonyms");
        this.ignoreCase = this.getBoolean("ignoreCase", false);
        this.expand = this.getBoolean("expand", true);
        if (synonyms != null) {
            List<String> wlist = null;
            try {
                wlist = Config.getLines(synonyms);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.synMap = new SynonymMap();
            SynonymFilterFactory.parseRules(wlist, this.synMap, "=>", ",", this.ignoreCase, this.expand);
            if (wlist.size() <= 20) {
                SolrCore.log.fine("SynonymMap " + synonyms + ":" + this.synMap);
            }
        }
    }

    private static void parseRules(List<String> rules, SynonymMap map, String mappingSep, String synSep, boolean ignoreCase, boolean expansion) {
        int count = 0;
        for (String rule : rules) {
            List<List<String>> target;
            List<List<String>> source;
            List<String> mapping = StrUtils.splitSmart(rule, mappingSep, false);
            if (mapping.size() > 2) {
                throw new RuntimeException("Invalid Synonym Rule:" + rule);
            }
            if (mapping.size() == 2) {
                source = SynonymFilterFactory.getSynList(mapping.get(0), synSep);
                target = SynonymFilterFactory.getSynList(mapping.get(1), synSep);
            } else {
                source = SynonymFilterFactory.getSynList(mapping.get(0), synSep);
                if (expansion) {
                    target = source;
                } else {
                    target = new ArrayList<List<String>>(1);
                    target.add(source.get(0));
                }
            }
            boolean includeOrig = false;
            for (List<String> fromToks : source) {
                ++count;
                for (List<String> toToks : target) {
                    map.add(ignoreCase ? StrUtils.toLower(fromToks) : fromToks, SynonymMap.makeTokens(toToks), includeOrig, true);
                }
            }
        }
    }

    private static List<List<String>> getSynList(String str, String separator) {
        List<String> strList = StrUtils.splitSmart(str, separator, false);
        ArrayList<List<String>> synList = new ArrayList<List<String>>();
        for (String toks : strList) {
            List<String> tokList = StrUtils.splitWS(toks, true);
            synList.add(tokList);
        }
        return synList;
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new SynonymFilter(input, this.synMap, this.ignoreCase);
    }
}

