/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.util.List;
import org.apache.solr.core.AbstractSolrEventListener;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.NamedList;

class QuerySenderListener
extends AbstractSolrEventListener {
    QuerySenderListener() {
    }

    public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher currentSearcher) {
        final SolrIndexSearcher searcher = newSearcher;
        SolrCore core = SolrCore.getSolrCore();
        log.info("QuerySenderListener sending requests to " + newSearcher);
        for (NamedList nlst : (List)this.args.get("queries")) {
            try {
                LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, nlst){

                    public SolrIndexSearcher getSearcher() {
                        return searcher;
                    }

                    public void close() {
                    }
                };
                SolrQueryResponse rsp = new SolrQueryResponse();
                core.execute((SolrQueryRequest)req, rsp);
                NamedList values = rsp.getValues();
                for (int i = 0; i < values.size(); ++i) {
                    Object o = values.getVal(i);
                    if (!(o instanceof DocList)) continue;
                    DocList docs = (DocList)o;
                    DocIterator iter = docs.iterator();
                    while (iter.hasNext()) {
                        newSearcher.doc(iter.nextDoc());
                    }
                }
                req.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.info("QuerySenderListener done.");
        }
    }
}

