/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Version;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.PojoCacheThreadContext;
import org.jboss.cache.pojo.impl.CacheListenerAdaptor;
import org.jboss.cache.pojo.impl.CachedType;
import org.jboss.cache.pojo.impl.PojoCacheDelegate;
import org.jboss.cache.pojo.impl.PojoCacheThreadContextImpl;
import org.jboss.cache.pojo.interceptors.PojoTxSynchronizationHandler;
import org.jboss.cache.transaction.BatchModeTransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoCacheImpl
implements PojoCache {
    private CacheSPI<Object, Object> cache = null;
    protected final Log log_ = LogFactory.getLog(this.getClass());
    private PojoCacheDelegate delegate_;
    private Map cachedTypes_ = new WeakHashMap();
    private boolean hasCreate_ = false;
    private CacheListenerAdaptor listenerAdaptor = new CacheListenerAdaptor(this);
    private PojoCacheThreadContext threadContext = new PojoCacheThreadContextImpl();

    public PojoCacheImpl(String configStr, boolean toStart) {
        try {
            XmlConfigurationParser parser = new XmlConfigurationParser();
            Configuration expected = parser.parseFile(configStr);
            this.init(expected, toStart);
        }
        catch (Exception e) {
            throw new PojoCacheException("Failed to start " + configStr, e);
        }
    }

    public PojoCacheImpl(Configuration config, boolean toStart) {
        this.init(config, toStart);
    }

    private void init(Configuration config, boolean toStart) {
        try {
            this.cache = (CacheSPI)DefaultCacheFactory.getInstance().createCache(config, toStart);
        }
        catch (Exception e) {
            throw new PojoCacheException("init " + config + " failed", e);
        }
        this.delegate_ = new PojoCacheDelegate(this);
    }

    public CacheSPI<Object, Object> getCacheSPI() {
        return this.cache;
    }

    @Override
    public Object attach(String id, Object pojo) throws PojoCacheException {
        return this.attach(Fqn.fromString((String)id), pojo);
    }

    @Override
    public Object attach(Fqn<?> id, Object pojo) throws PojoCacheException {
        return this.attach(id, pojo, null, null);
    }

    public Object attach(Fqn<?> id, Object pojo, String field, Object source) throws PojoCacheException {
        TransactionManager tm = this.getTransactionManager();
        boolean createdTransaction = this.setupTransaction(tm);
        try {
            Object obj;
            Object object = obj = this.delegate_.putObject(id, pojo, field, source);
            return object;
        }
        catch (Throwable t) {
            this.setRollbackOnly(tm);
            throw new PojoCacheException("attach failed " + id, t);
        }
        finally {
            if (createdTransaction) {
                this.endTransaction(tm, id);
            }
        }
    }

    public Object detach(Fqn<?> id, String field, Object source) throws PojoCacheException {
        TransactionManager tm = this.getTransactionManager();
        boolean createdTransaction = this.setupTransaction(tm);
        try {
            Object obj;
            Object object = obj = this.delegate_.removeObject(id, field, source);
            return object;
        }
        catch (Throwable t) {
            this.setRollbackOnly(tm);
            throw new PojoCacheException("detach failed " + id, t);
        }
        finally {
            if (createdTransaction) {
                this.endTransaction(tm, id);
            }
        }
    }

    private void endTransaction(TransactionManager tm, Fqn<?> id) {
        block6: {
            try {
                switch (tm.getStatus()) {
                    case 0: 
                    case 2: 
                    case 7: {
                        tm.commit();
                        break;
                    }
                    case 1: {
                        tm.rollback();
                    }
                }
            }
            catch (Throwable t) {
                if (!this.log_.isWarnEnabled()) break block6;
                this.log_.warn((Object)("Could not end transaction for operation on: " + id), t);
            }
        }
    }

    private void setRollbackOnly(TransactionManager tm) {
        block3: {
            try {
                if (tm.getStatus() != 1) {
                    tm.setRollbackOnly();
                }
            }
            catch (Throwable t) {
                if (!this.log_.isWarnEnabled()) break block3;
                this.log_.warn((Object)"Could not rollback transaction!", t);
            }
        }
    }

    private boolean setupTransaction(TransactionManager tm) {
        boolean created = false;
        try {
            Transaction transaction = tm.getTransaction();
            if (transaction == null) {
                tm.begin();
                transaction = tm.getTransaction();
                created = true;
            }
            transaction.registerSynchronization((Synchronization)PojoTxSynchronizationHandler.create());
        }
        catch (Exception e) {
            throw new PojoCacheException("Error creating transaction", e);
        }
        return created;
    }

    private TransactionManager getTransactionManager() {
        TransactionManager tm = this.cache.getConfiguration().getRuntimeConfig().getTransactionManager();
        if (tm == null) {
            tm = BatchModeTransactionManager.getInstance();
        }
        return tm;
    }

    @Override
    public Object detach(String id) throws PojoCacheException {
        return this.detach(Fqn.fromString((String)id));
    }

    @Override
    public Object detach(Fqn<?> id) throws PojoCacheException {
        return this.detach(id, null, null);
    }

    @Override
    public String getPojoID(Object pojo) {
        throw new PojoCacheException("getPojoID not yet implemented");
    }

    @Override
    public boolean exists(Fqn<?> id) {
        return this.delegate_.exists(id);
    }

    @Override
    public Object find(String id) throws PojoCacheException {
        return this.find(Fqn.fromString((String)id));
    }

    @Override
    public Object find(Fqn<?> id) throws PojoCacheException {
        try {
            return this.find(id, null, null);
        }
        catch (CacheException e) {
            throw new PojoCacheException("find " + id + " failed ", e);
        }
    }

    public Object find(Fqn<?> id, String field, Object source) throws CacheException {
        return this.delegate_.getObject(id, field, source);
    }

    @Override
    public Map<Fqn<?>, Object> findAll(String id) throws PojoCacheException {
        return this.findAll(Fqn.fromString((String)id));
    }

    @Override
    public Map<Fqn<?>, Object> findAll(Fqn<?> id) throws PojoCacheException {
        if (id == null) {
            id = Fqn.ROOT;
        }
        try {
            return this.delegate_.findObjects(id);
        }
        catch (CacheException e) {
            throw new PojoCacheException("findAll " + id + " failed", e);
        }
    }

    public String getVersion() {
        return Version.printVersion();
    }

    @Override
    public void create() throws PojoCacheException {
        this.log_.info((Object)("PojoCache version: " + this.getVersion()));
        try {
            this.cache.create();
        }
        catch (Exception e) {
            throw new PojoCacheException("PojoCache create exception", e);
        }
        this.hasCreate_ = true;
    }

    @Override
    public void start() throws PojoCacheException {
        if (!this.hasCreate_) {
            this.create();
        }
        try {
            this.log_.info((Object)("PojoCache version: " + this.getVersion()));
            this.cache.start();
        }
        catch (Exception e) {
            throw new PojoCacheException("Failed starting " + e, e);
        }
    }

    @Override
    public void stop() throws PojoCacheException {
        this.cache.stop();
    }

    @Override
    public void destroy() throws PojoCacheException {
        this.cache.destroy();
    }

    @Override
    public Collection<Object> getListeners() {
        return this.listenerAdaptor.getListeners();
    }

    @Override
    public void addListener(Object listener) {
        this.addListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Object listener, Pattern pattern) {
        CacheListenerAdaptor cacheListenerAdaptor = this.listenerAdaptor;
        synchronized (cacheListenerAdaptor) {
            try {
                boolean wasEmpty = this.listenerAdaptor.isEmpty();
                this.listenerAdaptor.addListener(listener, pattern);
                if (wasEmpty) {
                    this.cache.addCacheListener((Object)this.listenerAdaptor);
                }
            }
            catch (IllegalArgumentException e) {
                e.fillInStackTrace();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Object listener) {
        CacheListenerAdaptor cacheListenerAdaptor = this.listenerAdaptor;
        synchronized (cacheListenerAdaptor) {
            this.listenerAdaptor.removeListener(listener);
            if (this.listenerAdaptor.isEmpty()) {
                this.cache.removeCacheListener((Object)this.listenerAdaptor);
            }
        }
    }

    @Override
    public PojoCacheThreadContext getThreadContext() {
        return this.threadContext;
    }

    @Override
    public Cache<Object, Object> getCache() {
        return this.cache;
    }

    public synchronized CachedType getCachedType(Class clazz) {
        CachedType type = (CachedType)this.cachedTypes_.get(clazz);
        if (type == null) {
            type = new CachedType(clazz);
            this.cachedTypes_.put(clazz, type);
            return type;
        }
        return type;
    }

    public String toString() {
        return this.getClass().getName() + " cache=" + this.cache + " delegate=" + this.delegate_ + " types=" + this.cachedTypes_.size();
    }
}

