package org.jboss.cache.search;

import org.jboss.cache.Fqn;

/**
 *
 * This class is used to get fqns, keys and documentId's by calling methods on {@link org.jboss.cache.search.Transformer}
 *
 @author Navin Surtani  - navin@surtani.org
 */
public class CacheEntityId
{
   Fqn fqn;
   String key;
   String documentId;

   public CacheEntityId(String documentId)
   {
      if(documentId == null) throw new NullPointerException("documentId is null");
      this.documentId = documentId;
   }

   public CacheEntityId(Fqn fqn, String key)
   {
      if(fqn == null) throw new NullPointerException("Fqn is null");
      if(key == null) throw new NullPointerException("Key is null");
      this.fqn = fqn;
      this.key = key;
   }

   /**
    * Gets the Fqn from the instance of CacheEntityId.
    *
    * @return Fqn from the instance of CacheEntityId.
    */

   public Fqn getFqn()
   {
      if (fqn != null) return fqn;
      if (documentId != null)
      {
         fqn = Transformer.getFqn(documentId);
         return fqn;
      }

      if(documentId == null)
      throw new IllegalArgumentException("docId is null");

      throw new IllegalArgumentException("Fqn is null");
   }

   /**
    * Gets the key from the instance of CacheEntityId.
    *
    * @return Key from the instance of CacheEntityId.
    */

   public String getKey()
   {
      if (key != null) return key;
      if (documentId != null)
      {
         key = Transformer.getKey(documentId);
         return key;
      }

      throw new IllegalArgumentException("At least key or documentId must be set to call this method");
   }

   /**
    * Gets a documentId String from an Fqn and key combination.
    *
    * @return documentId String.
    */


   public String getDocumentId() throws InvalidKeyException
   {
      if (key == null || fqn == null)
      {
         throw new IllegalArgumentException("Either your key or fqn is null. Please check again.");
      }

      return Transformer.generateId(fqn, key);
   }
}
