package org.jboss.cache.search;

import org.jboss.cache.Cache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;
import java.util.ArrayList;

/**
 * Class that is used to load objects from a list of CacheEntityId ids.
 *
 * @author Navin Surtani  - navin@surtani.org
 */
public class CacheEntityLoader
{
   Cache cache;
   private static final Log log = LogFactory.getLog(CacheEntityLoader.class);

   public CacheEntityLoader(Cache cache)
   {
      this.cache = cache;
   }

   /**
    * Takes a list of entity ids and gets them from the cache.
    * @param ids list of cache entity IDs.  Cannot be null.
    * @return List of objects loaded from the cache.  The list returned will be exactly the same size as the ids list passed in.
    * @throws NullPointerException if ids is null.
    */
   public List<Object> load(List<CacheEntityId> ids)
   {
      List<Object> retVal = new ArrayList<Object>(ids.size());

      for (CacheEntityId id: ids)
      {
         retVal.add( cache.get(id.getFqn(), id.getKey()) );
         if(log.isTraceEnabled()) log.trace("Created list of return values. Size is  " + retVal.size() );         
      }
      return retVal;
   }

   /**
    * Takes a list of entity ids and gets them from the cache.
    * @param id cache entity id to look up in the cache.
    * @return the object from the cache, or null if one cannot be found.
    * @throws NullPointerException if ids is null.
    */
   public Object load(CacheEntityId id)
   {
      return cache.get(id.getFqn(), id.getKey());
   }


}
