package org.jboss.cache.search;

import java.util.ListIterator;

/**
 * Iterates over query results
 *
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 */
public interface QueryResultIterator extends ListIterator
{
   /**
    * Jumps to a specific index in the iterator.
    *
    * @param index index to jump to.
    * @throws IndexOutOfBoundsException if the index is out of bounds
    */
   void jumpToResult(int index) throws IndexOutOfBoundsException;

   /**
    * Jumps to the first result
    */
   void first();

   /**
    * Jumps to the last result
    */
   void last();

   /**
    * Jumps to the one-after-the-first result
    */
   void afterFirst();

   /**
    * Jumps to the one-before-the-last result
    */
   void beforeLast();

   /**
    * @return true if the current result is the first
    */
   boolean isFirst();

   /**
    * @return true if the current result is the last
    */
   boolean isLast();

   /**
    * @return true if the current result is one after the first
    */
   boolean isAfterFirst();

   /**
    * @return true if the current result is one before the last
    */
   boolean isBeforeLast();
}
