package org.jboss.cache.search;

import org.apache.lucene.search.Query;
import org.jboss.cache.Cache;

/**
 * @author Navin Surtani  - navin@surtani.org
 *         <p/>
 *         This will be the most used interface in JBossCache searchable. It extends Cache and therefore will have
 *         the standard get(), put() and remove() methods. The additional method is the createQuery method which people
 *         will use to build their Hibernate Search queries from a luceneQuery - Hibernate Search users will be very familiar
 *         with this.
 */
public interface SearchableCache<K, V> extends Cache<K, V>
{

   /**
    * Creates a CacheQuery object from a luceneQuery.
    *
    * @param luceneQuery - from {@link org.apache.lucene.search.Query}
    * @return a CacheQuery instance from which the user can get a list/iterator object.
    */
   public CacheQuery createQuery(Query luceneQuery);

   /**
    * Creates a CacheQuery from a lucene query and a class array.
    *
    * @param classes - array of classes to be searched from.
    * @param luceneQuery - from {@link org.apache.lucene.search.Query}
    * @return a CacheQuery instance from which the user can get a list/iterator object.
    */
   public CacheQuery createQuery(Query luceneQuery, Class... classes);

}
