package org.jboss.cache.search;

import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.annotations.common.reflection.ReflectionManager;

import java.util.Iterator;
import java.util.Properties;
import java.util.Map;
import java.util.HashMap;

/**
 * Class that implements {@link org.hibernate.search.cfg.SearchConfiguration} so that within JBossCache Searchable, there is no
 * need for a Hibernate Core configuration object.
 *
 * @author Navin Surtani  - navin@surtani.org
 */
public class SearchableCacheCfgImpl implements SearchConfiguration
{
   protected Map<String, Class> classes;
   private Properties properties;

   public SearchableCacheCfgImpl(Class[] classArray, Properties properties)
   {
      // null chks
      if (classArray == null) throw new NullPointerException("Classes provided are null");
      this.properties = properties;
      if (this.properties == null) this.properties = new Properties();
      
      classes = new HashMap<String, Class>();

      // loop thru your classArray
      // populate your Map

      for (Class c: classArray)
      {
         String classname = c.getName();
         classes.put(classname, c);
      }
   }

   public Iterator getClassMappings()
   {
      return classes.values().iterator();
   }

   public Class getClassMapping(String name)
   {
      return classes.get(name);
   }

   public String getProperty(String propertyName)
   {
      return properties.getProperty(propertyName);
   }

   public Properties getProperties()
   {
      return properties;
   }

   public ReflectionManager getReflectionManager()
   {
      return null;
   }

}
